/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

public enum StateTransferStatus {
    IDLE,
    SENDING,
    SEND_OK,
    SEND_FAILED,
    SEND_CANCELED;


    public static StateTransferStatus merge(StateTransferStatus one, StateTransferStatus two) {
        switch (one) {
            case IDLE: {
                return two;
            }
            case SENDING: {
                return two == IDLE ? one : two;
            }
            case SEND_OK: {
                switch (two) {
                    case IDLE: 
                    case SENDING: {
                        return one;
                    }
                }
                return two;
            }
            case SEND_FAILED: {
                switch (two) {
                    case IDLE: 
                    case SENDING: 
                    case SEND_OK: 
                    case SEND_CANCELED: {
                        return one;
                    }
                }
                return two;
            }
            case SEND_CANCELED: {
                switch (two) {
                    case IDLE: 
                    case SENDING: 
                    case SEND_OK: {
                        return one;
                    }
                }
                return two;
            }
        }
        throw new IllegalStateException();
    }

    public static String toText(StateTransferStatus status) {
        switch (status) {
            case IDLE: {
                return "IDLE";
            }
            case SENDING: {
                return "SENDING";
            }
            case SEND_OK: {
                return "OK";
            }
            case SEND_FAILED: {
                return "ERROR";
            }
            case SEND_CANCELED: {
                return "CANCELED";
            }
        }
        throw new IllegalStateException();
    }
}

