/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.activemq.artemis.cli.CLIException;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.DataAbstract;

public abstract class LockAbstract
extends DataAbstract {
    private static RandomAccessFile serverLockFile = null;
    private static FileLock serverLockLock = null;

    public static void unlock() {
        try {
            if (serverLockFile != null) {
                serverLockFile.close();
                serverLockFile = null;
            }
            if (serverLockLock != null) {
                serverLockLock.close();
                serverLockLock = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        if (this.getBrokerInstance() == null) {
            System.err.println("Warning: You are running a data tool outside of any broker instance. Modifying data on a running server might break the server's data");
            System.err.println();
        } else {
            this.lockCLI(this.getLockPlace());
        }
        return null;
    }

    void lockCLI(File lockPlace) throws Exception {
        if (lockPlace != null) {
            lockPlace.mkdirs();
            if (serverLockFile == null) {
                File fileLock = new File(lockPlace, "cli.lock");
                serverLockFile = new RandomAccessFile(fileLock, "rw");
            }
            try {
                FileLock lock = serverLockFile.getChannel().tryLock();
                if (lock == null) {
                    throw new CLIException("Error: There is another process using the server at " + lockPlace + ". Cannot start the process!");
                }
                serverLockLock = lock;
            }
            catch (OverlappingFileLockException e) {
                throw new CLIException("Error: There is another process using the server at " + lockPlace + ". Cannot start the process!");
            }
        }
    }

    private File getLockPlace() throws Exception {
        String brokerInstance = this.getBrokerInstance();
        if (brokerInstance != null) {
            return new File(new File(brokerInstance), "lock");
        }
        return null;
    }
}

