/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.AddressSettingDefinition;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.ClusterConnectionDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.HTTPConnectorDefinition;
import org.wildfly.extension.messaging.activemq.JGroupsDiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemRootResourceDefinition;
import org.wildfly.extension.messaging.activemq.QueueDefinition;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.SocketDiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeDefinition;

public class MessagingTransformerRegistration
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "messaging-activemq";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        MessagingTransformerRegistration.registerTransformers_WF_23(builder.createBuilder(MessagingExtension.VERSION_13_0_0, MessagingExtension.VERSION_12_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_22(builder.createBuilder(MessagingExtension.VERSION_12_0_0, MessagingExtension.VERSION_11_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_21(builder.createBuilder(MessagingExtension.VERSION_11_0_0, MessagingExtension.VERSION_10_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_20(builder.createBuilder(MessagingExtension.VERSION_10_0_0, MessagingExtension.VERSION_9_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_19(builder.createBuilder(MessagingExtension.VERSION_9_0_0, MessagingExtension.VERSION_8_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_18(builder.createBuilder(MessagingExtension.VERSION_8_0_0, MessagingExtension.VERSION_7_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_17(builder.createBuilder(MessagingExtension.VERSION_7_0_0, MessagingExtension.VERSION_6_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_16(builder.createBuilder(MessagingExtension.VERSION_6_0_0, MessagingExtension.VERSION_5_0_0));
        MessagingTransformerRegistration.registerTransformers_WF_15(builder.createBuilder(MessagingExtension.VERSION_5_0_0, MessagingExtension.VERSION_4_0_0));
        MessagingTransformerRegistration.registerTransformers_EAP_7_2_0(builder.createBuilder(MessagingExtension.VERSION_4_0_0, MessagingExtension.VERSION_3_0_0));
        MessagingTransformerRegistration.registerTransformers_EAP_7_1_0(builder.createBuilder(MessagingExtension.VERSION_3_0_0, MessagingExtension.VERSION_2_0_0));
        MessagingTransformerRegistration.registerTransformers_EAP_7_0_0(builder.createBuilder(MessagingExtension.VERSION_2_0_0, MessagingExtension.VERSION_1_0_0));
        builder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{MessagingExtension.VERSION_1_0_0, MessagingExtension.VERSION_2_0_0, MessagingExtension.VERSION_3_0_0, MessagingExtension.VERSION_4_0_0, MessagingExtension.VERSION_5_0_0, MessagingExtension.VERSION_6_0_0, MessagingExtension.VERSION_7_0_0, MessagingExtension.VERSION_8_0_0, MessagingExtension.VERSION_9_0_0, MessagingExtension.VERSION_10_0_0, MessagingExtension.VERSION_11_0_0, MessagingExtension.VERSION_12_0_0, MessagingExtension.VERSION_13_0_0}});
    }

    private static void registerTransformers_WF_23(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.NETWORK_CHECK_LIST, ServerDefinition.NETWORK_CHECK_NIC, ServerDefinition.NETWORK_CHECK_PERIOD, ServerDefinition.NETWORK_CHECK_PING6_COMMAND, ServerDefinition.NETWORK_CHECK_PING_COMMAND, ServerDefinition.NETWORK_CHECK_TIMEOUT, ServerDefinition.NETWORK_CHECK_URL_LIST, ServerDefinition.CRITICAL_ANALYZER_CHECK_PERIOD, ServerDefinition.CRITICAL_ANALYZER_ENABLED, ServerDefinition.CRITICAL_ANALYZER_POLICY, ServerDefinition.CRITICAL_ANALYZER_TIMEOUT, ServerDefinition.JOURNAL_MAX_ATTIC_FILES});
        server.discardOperations(new String[]{"print-data"});
        ResourceTransformationDescriptionBuilder bridge = server.addChildResource(MessagingExtension.BRIDGE_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(bridge, new AttributeDefinition[]{BridgeDefinition.CALL_TIMEOUT});
        ((AttributeTransformationDescriptionBuilder)bridge.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE})).end();
        ResourceTransformationDescriptionBuilder clusterConnection = server.addChildResource(MessagingExtension.CLUSTER_CONNECTION_PATH);
        ((AttributeTransformationDescriptionBuilder)clusterConnection.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE})).end();
    }

    private static void registerTransformers_WF_22(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.NETWORK_CHECK_LIST});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.NETWORK_CHECK_NIC});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.NETWORK_CHECK_PERIOD});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.NETWORK_CHECK_PING6_COMMAND});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.NETWORK_CHECK_PING_COMMAND});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.NETWORK_CHECK_TIMEOUT});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.NETWORK_CHECK_URL_LIST});
        server.addChildResource(MessagingExtension.JMS_TOPIC_PATH).discardOperations(new String[]{"pause", "resume"});
        ((AttributeTransformationDescriptionBuilder)server.addChildResource(MessagingExtension.JMS_TOPIC_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{CommonAttributes.PAUSED})).end();
    }

    private static void registerTransformers_WF_21(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder externalConnectionFactory = subsystem.addChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(externalConnectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD, ConnectionFactoryAttributes.Common.CONNECTION_TTL, CommonAttributes.CALL_TIMEOUT, CommonAttributes.CALL_FAILOVER_TIMEOUT, ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE, ConnectionFactoryAttributes.Common.CONSUMER_MAX_RATE, ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE, ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE, ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE, ConnectionFactoryAttributes.Common.PROTOCOL_MANAGER_FACTORY, ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES, ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CLIENT_ID, ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE, ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE, ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE, ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND, ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND, ConnectionFactoryAttributes.Common.AUTO_GROUP, ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE, ConnectionFactoryAttributes.Common.RETRY_INTERVAL, ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER, CommonAttributes.MAX_RETRY_INTERVAL, ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS, ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION, ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME, ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS, ConnectionFactoryAttributes.Common.SCHEDULED_THREAD_POOL_MAX_SIZE, ConnectionFactoryAttributes.Common.THREAD_POOL_MAX_SIZE, ConnectionFactoryAttributes.Common.GROUP_ID, ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, ConnectionFactoryAttributes.Common.INITIAL_MESSAGE_PACKET_SIZE});
    }

    private static void registerTransformers_WF_20(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        ((AttributeTransformationDescriptionBuilder)server.getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{ServerDefinition.CREDENTIAL_REFERENCE.getName()})).end();
        ResourceTransformationDescriptionBuilder bridge = server.addChildResource(MessagingExtension.BRIDGE_PATH);
        ((AttributeTransformationDescriptionBuilder)bridge.getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{BridgeDefinition.CREDENTIAL_REFERENCE.getName()})).end();
        ResourceTransformationDescriptionBuilder jmsBridge = subsystem.addChildResource(MessagingExtension.JMS_BRIDGE_PATH);
        ((AttributeTransformationDescriptionBuilder)jmsBridge.getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{JMSBridgeDefinition.SOURCE_CREDENTIAL_REFERENCE.getName()})).end();
        ((AttributeTransformationDescriptionBuilder)jmsBridge.getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{JMSBridgeDefinition.TARGET_CREDENTIAL_REFERENCE.getName()})).end();
        ResourceTransformationDescriptionBuilder pooledConnectionFactory = server.addChildResource(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH);
        ((AttributeTransformationDescriptionBuilder)pooledConnectionFactory.getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE})).end();
    }

    private static void registerTransformers_WF_19(ResourceTransformationDescriptionBuilder subsystem) {
        subsystem.addChildResource(DiscoveryGroupDefinition.PATH).setCustomResourceTransformer(ResourceTransformer.DISCARD);
        subsystem.addChildRedirection(JGroupsDiscoveryGroupDefinition.PATH, DiscoveryGroupDefinition.PATH);
        subsystem.addChildRedirection(SocketDiscoveryGroupDefinition.PATH, DiscoveryGroupDefinition.PATH);
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        server.addChildRedirection(MessagingExtension.JGROUPS_BROADCAST_GROUP_PATH, MessagingExtension.BROADCAST_GROUP_PATH);
        server.addChildRedirection(MessagingExtension.SOCKET_BROADCAST_GROUP_PATH, MessagingExtension.BROADCAST_GROUP_PATH);
        server.addChildRedirection(JGroupsDiscoveryGroupDefinition.PATH, DiscoveryGroupDefinition.PATH);
        server.addChildRedirection(SocketDiscoveryGroupDefinition.PATH, DiscoveryGroupDefinition.PATH);
        server.addChildResource(DiscoveryGroupDefinition.PATH).setCustomResourceTransformer(ResourceTransformer.DISCARD);
        server.addChildResource(MessagingExtension.BROADCAST_GROUP_PATH).setCustomResourceTransformer(ResourceTransformer.DISCARD);
    }

    private static void registerTransformers_WF_18(ResourceTransformationDescriptionBuilder subsystem) {
    }

    private static void registerTransformers_WF_17(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder externalConnectionFactory = subsystem.addChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(externalConnectionFactory, ConnectionFactoryAttributes.Common.USE_TOPOLOGY, ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX);
        ResourceTransformationDescriptionBuilder externalPooledConnectionFactory = subsystem.addChildResource(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(externalPooledConnectionFactory, ConnectionFactoryAttributes.Common.USE_TOPOLOGY, ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX);
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        ResourceTransformationDescriptionBuilder connectionFactory = server.addChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(connectionFactory, ConnectionFactoryAttributes.Common.USE_TOPOLOGY);
        ResourceTransformationDescriptionBuilder pooledConnectionFactory = server.addChildResource(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(pooledConnectionFactory, ConnectionFactoryAttributes.Common.USE_TOPOLOGY);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.JOURNAL_FILE_OPEN_TIMEOUT});
    }

    private static void registerTransformers_WF_16(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder queue = subsystem.addChildResource(MessagingExtension.SERVER_PATH).addChildResource(MessagingExtension.QUEUE_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(queue, new AttributeDefinition[]{QueueDefinition.ROUTING_TYPE});
        ResourceTransformationDescriptionBuilder jmsBridge = subsystem.addChildResource(MessagingExtension.JMS_BRIDGE_PATH);
        jmsBridge.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{JMSBridgeDefinition.QUALITY_OF_SERVICE, JMSBridgeDefinition.FAILURE_RETRY_INTERVAL, JMSBridgeDefinition.MAX_RETRIES, JMSBridgeDefinition.MAX_BATCH_SIZE, JMSBridgeDefinition.MAX_BATCH_TIME});
    }

    private static void registerTransformers_WF_15(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        server.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{ServerDefinition.JOURNAL_POOL_FILES});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.GLOBAL_MAX_DISK_USAGE, ServerDefinition.DISK_SCAN_PERIOD, ServerDefinition.GLOBAL_MAX_MEMORY_SIZE});
    }

    private static void registerTransformers_EAP_7_2_0(ResourceTransformationDescriptionBuilder subsystem) {
        subsystem.rejectChildResource(DiscoveryGroupDefinition.PATH);
        subsystem.rejectChildResource(PathElement.pathElement((String)"remote-connector"));
        subsystem.rejectChildResource(MessagingExtension.HTTP_CONNECTOR_PATH);
        subsystem.rejectChildResource(PathElement.pathElement((String)"connector"));
        subsystem.rejectChildResource(PathElement.pathElement((String)"in-vm-connector"));
        subsystem.rejectChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        subsystem.rejectChildResource(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH);
        subsystem.rejectChildResource(MessagingExtension.EXTERNAL_JMS_QUEUE_PATH);
        subsystem.rejectChildResource(MessagingExtension.EXTERNAL_JMS_TOPIC_PATH);
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        server.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{ServerDefinition.JOURNAL_JDBC_NETWORK_TIMEOUT});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.JOURNAL_JDBC_LOCK_EXPIRATION, ServerDefinition.JOURNAL_JDBC_LOCK_RENEW_PERIOD, ServerDefinition.JOURNAL_NODE_MANAGER_STORE_TABLE});
        ResourceTransformationDescriptionBuilder addressSetting = server.addChildResource(MessagingExtension.ADDRESS_SETTING_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(addressSetting, new AttributeDefinition[]{AddressSettingDefinition.AUTO_CREATE_QUEUES, AddressSettingDefinition.AUTO_DELETE_QUEUES, AddressSettingDefinition.AUTO_CREATE_ADDRESSES, AddressSettingDefinition.AUTO_DELETE_ADDRESSES});
        ResourceTransformationDescriptionBuilder connectionFactory = server.addChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(connectionFactory, ConnectionFactoryAttributes.Common.INITIAL_MESSAGE_PACKET_SIZE);
    }

    private static void registerTransformers_EAP_7_1_0(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)server.addChildResource(MessagingExtension.BROADCAST_GROUP_PATH).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new JGroupsChannelDiscardAttributeChecker(), new AttributeDefinition[]{BroadcastGroupDefinition.JGROUPS_CHANNEL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{BroadcastGroupDefinition.JGROUPS_CHANNEL})).addRename((AttributeDefinition)CommonAttributes.JGROUPS_CLUSTER, CommonAttributes.JGROUPS_CHANNEL.getName())).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)server.addChildResource(DiscoveryGroupDefinition.PATH).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new JGroupsChannelDiscardAttributeChecker(), new AttributeDefinition[]{DiscoveryGroupDefinition.JGROUPS_CHANNEL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{DiscoveryGroupDefinition.JGROUPS_CHANNEL})).addRename((AttributeDefinition)CommonAttributes.JGROUPS_CLUSTER, CommonAttributes.JGROUPS_CHANNEL.getName())).end();
    }

    private static void registerTransformers_EAP_7_0_0(ResourceTransformationDescriptionBuilder subsystem) {
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(subsystem, new AttributeDefinition[]{MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_THREAD_POOL_MAX_SIZE, MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_MAX_SIZE});
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.ELYTRON_DOMAIN, ServerDefinition.JOURNAL_DATASOURCE, ServerDefinition.JOURNAL_MESSAGES_TABLE, ServerDefinition.JOURNAL_BINDINGS_TABLE, ServerDefinition.JOURNAL_JMS_BINDINGS_TABLE, ServerDefinition.JOURNAL_LARGE_MESSAGES_TABLE, ServerDefinition.JOURNAL_PAGE_STORE_TABLE, ServerDefinition.JOURNAL_DATABASE, ServerDefinition.JOURNAL_JDBC_NETWORK_TIMEOUT});
        ((AttributeTransformationDescriptionBuilder)server.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{ServerDefinition.CREDENTIAL_REFERENCE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ServerDefinition.CREDENTIAL_REFERENCE});
        ResourceTransformationDescriptionBuilder replicationMaster = server.addChildResource(MessagingExtension.REPLICATION_MASTER_PATH);
        replicationMaster.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{HAAttributes.CHECK_FOR_LIVE_SERVER});
        ResourceTransformationDescriptionBuilder replicationColocated = server.addChildResource(MessagingExtension.REPLICATION_COLOCATED_PATH);
        ResourceTransformationDescriptionBuilder masterForReplicationColocated = replicationColocated.addChildResource(MessagingExtension.CONFIGURATION_MASTER_PATH);
        masterForReplicationColocated.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{HAAttributes.CHECK_FOR_LIVE_SERVER});
        ResourceTransformationDescriptionBuilder bridge = server.addChildResource(MessagingExtension.BRIDGE_PATH);
        ((AttributeTransformationDescriptionBuilder)bridge.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{BridgeDefinition.CREDENTIAL_REFERENCE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{BridgeDefinition.CREDENTIAL_REFERENCE});
        ResourceTransformationDescriptionBuilder httpConnector = server.addChildResource(MessagingExtension.HTTP_CONNECTOR_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(httpConnector, new AttributeDefinition[]{HTTPConnectorDefinition.SERVER_NAME});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(bridge, new AttributeDefinition[]{BridgeDefinition.PRODUCER_WINDOW_SIZE});
        ResourceTransformationDescriptionBuilder jmsBridge = server.addChildResource(MessagingExtension.JMS_BRIDGE_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(jmsBridge, new AttributeDefinition[]{JMSBridgeDefinition.SOURCE_CREDENTIAL_REFERENCE});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(jmsBridge, new AttributeDefinition[]{JMSBridgeDefinition.TARGET_CREDENTIAL_REFERENCE});
        ResourceTransformationDescriptionBuilder clusterConnection = server.addChildResource(MessagingExtension.CLUSTER_CONNECTION_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(clusterConnection, new AttributeDefinition[]{ClusterConnectionDefinition.PRODUCER_WINDOW_SIZE});
        ResourceTransformationDescriptionBuilder connectionFactory = server.addChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(connectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST});
        connectionFactory.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT});
        ResourceTransformationDescriptionBuilder pooledConnectionFactory = server.addChildResource(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH);
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(pooledConnectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.REBALANCE_CONNECTIONS});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(pooledConnectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.STATISTICS_ENABLED});
        pooledConnectionFactory.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE, CommonAttributes.CALL_FAILOVER_TIMEOUT, ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE});
        MessagingTransformerRegistration.rejectDefinedAttributeWithDefaultValue(pooledConnectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE, ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, ConnectionFactoryAttributes.Pooled.ALLOW_LOCAL_TRANSACTIONS});
    }

    private static void rejectDefinedAttributeWithDefaultValue(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, attrs)).addRejectCheck(RejectAttributeChecker.DEFINED, attrs);
    }

    static class JGroupsChannelDiscardAttributeChecker
    implements DiscardAttributeChecker {
        JGroupsChannelDiscardAttributeChecker() {
        }

        public boolean isDiscardExpressions() {
            return false;
        }

        public boolean isDiscardUndefined() {
            return true;
        }

        public boolean isOperationParameterDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            return operation.get("operation").asString().equals("add") && JGroupsChannelDiscardAttributeChecker.discard(attributeValue, operation);
        }

        public boolean isResourceAttributeDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return JGroupsChannelDiscardAttributeChecker.discard(attributeValue, context.readResource(PathAddress.EMPTY_ADDRESS).getModel());
        }

        private static boolean discard(ModelNode attributeValue, ModelNode model) {
            return !model.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName()) || !attributeValue.isDefined() || model.hasDefined(CommonAttributes.JGROUPS_CHANNEL_FACTORY.getName()) && model.get(CommonAttributes.JGROUPS_CLUSTER.getName()).equals(attributeValue);
        }
    }
}

