/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.util.ElytronFilePasswordProvider;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.credential.store.impl.PropertiesCredentialStore;
import org.wildfly.security.encryption.CipherUtil;
import org.wildfly.security.encryption.SecretKeyUtil;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.pem.PemEntry;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronTool;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.tool.MaskCommand;

class CredentialStoreCommand
extends Command {
    public static int ACTION_NOT_DEFINED = 5;
    public static int ALIAS_NOT_FOUND = 6;
    public static int GENERAL_CONFIGURATION_ERROR = 7;
    public static final String RSA_ALGORITHM = "RSA";
    public static final String DSA_ALGORITHM = "DSA";
    public static final String EC_ALGORITHM = "EC";
    public static final String CREDENTIAL_STORE_COMMAND = "credential-store";
    public static final String STORE_LOCATION_PARAM = "location";
    public static final String IMPLEMENTATION_PROPERTIES_PARAM = "properties";
    public static final String CREDENTIAL_STORE_PASSWORD_PARAM = "password";
    public static final String CREDENTIAL_STORE_TYPE_PARAM = "type";
    public static final String SALT_PARAM = "salt";
    public static final String ITERATION_PARAM = "iteration";
    public static final String PASSWORD_CREDENTIAL_VALUE_PARAM = "secret";
    public static final String ADD_ALIAS_PARAM = "add";
    public static final String ALIAS_ARGUMENT = "alias";
    public static final String CHECK_ALIAS_PARAM = "exists";
    public static final String ALIASES_PARAM = "aliases";
    public static final String CREDENTIAL_TYPES = "credential-types";
    public static final String REMOVE_ALIAS_PARAM = "remove";
    public static final String CREATE_CREDENTIAL_STORE_PARAM = "create";
    public static final String HELP_PARAM = "help";
    public static final String PRINT_SUMMARY_PARAM = "summary";
    public static final String ENTRY_TYPE_PARAM = "entry-type";
    public static final String OTHER_PROVIDERS_PARAM = "other-providers";
    public static final String DEBUG_PARAM = "debug";
    public static final String CUSTOM_CREDENTIAL_STORE_PROVIDER_PARAM = "credential-store-provider";
    public static final String SIZE_PARAM = "size";
    public static final String GENERATE_KEY_PAIR_PARAM = "generate-key-pair";
    public static final String ALGORITHM_PARAM = "algorithm";
    public static final String EXPORT_KEY_PAIR_PUBLIC_KEY_PARAM = "export-key-pair-public-key";
    public static final String IMPORT_KEY_PAIR_PARAM = "import-key-pair";
    public static final String PRIVATE_KEY_LOCATION_PARAM = "private-key-location";
    public static final String PUBLIC_KEY_LOCATION_PARAM = "public-key-location";
    public static final String PRIVATE_KEY_STRING_PARAM = "private-key-string";
    public static final String PUBLIC_KEY_STRING_PARAM = "public-key-string";
    public static final String KEY_PASSPHRASE_PARAM = "key-passphrase";
    public static final String GENERATE_SECRET_KEY = "generate-secret-key";
    public static final String EXPORT_SECRET_KEY = "export-secret-key";
    public static final String IMPORT_SECRET_KEY = "import-secret-key";
    public static final String KEY_PARAM = "key";
    public static final String ENCRYPT = "encrypt";
    public static final String CLEAR_TEXT = "clear-text";
    private static final List<String> filebasedKeystoreTypes = Collections.unmodifiableList(Arrays.asList("JKS", "JCEKS", "PKCS12"));
    private final Options options;
    private CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;

    CredentialStoreCommand() {
        this.options = new Options();
        Option opt = new Option("l", STORE_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdLineStoreLocationDesc());
        opt.setArgName("loc");
        opt.setOptionalArg(false);
        this.options.addOption(opt);
        opt = new Option("u", IMPLEMENTATION_PROPERTIES_PARAM, true, ElytronToolMessages.msg.cmdLineImplementationPropertiesDesc());
        this.options.addOption(opt);
        opt = new Option("p", CREDENTIAL_STORE_PASSWORD_PARAM, true, ElytronToolMessages.msg.cmdLineCredentialStorePassword());
        opt.setArgName("pwd");
        this.options.addOption(opt);
        this.options.addOption("s", SALT_PARAM, true, ElytronToolMessages.msg.cmdLineSaltDesc());
        this.options.addOption("i", ITERATION_PARAM, true, ElytronToolMessages.msg.cmdLineIterationCountDesc());
        opt = new Option("x", PASSWORD_CREDENTIAL_VALUE_PARAM, true, ElytronToolMessages.msg.cmdLinePasswordCredentialValueDesc());
        opt.setArgName("secret to store");
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        opt = new Option("n", ENTRY_TYPE_PARAM, true, ElytronToolMessages.msg.cmdLineEntryTypeDesc());
        opt.setArgName(CREDENTIAL_STORE_TYPE_PARAM);
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        opt = new Option("o", OTHER_PROVIDERS_PARAM, true, ElytronToolMessages.msg.cmdLineOtherProvidersDesc());
        opt.setArgName("providers");
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        opt = new Option("q", CUSTOM_CREDENTIAL_STORE_PROVIDER_PARAM, true, ElytronToolMessages.msg.cmdLineCustomCredentialStoreProviderDesc());
        opt.setArgName("cs-provider");
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        this.options.addOption("c", CREATE_CREDENTIAL_STORE_PARAM, false, ElytronToolMessages.msg.cmdLineCreateCredentialStoreDesc());
        opt = new Option("t", CREDENTIAL_STORE_TYPE_PARAM, true, ElytronToolMessages.msg.cmdLineCredentialStoreTypeDesc());
        opt.setArgName(CREDENTIAL_STORE_TYPE_PARAM);
        this.options.addOption(opt);
        this.options.addOption("f", PRINT_SUMMARY_PARAM, false, ElytronToolMessages.msg.cmdLinePrintSummary());
        this.options.addOption("j", SIZE_PARAM, true, ElytronToolMessages.msg.cmdLineKeySizeDesc());
        this.options.addOption("k", ALGORITHM_PARAM, true, ElytronToolMessages.msg.cmdLineKeyAlgorithmDesc());
        this.options.addOption("kp", KEY_PASSPHRASE_PARAM, true, ElytronToolMessages.msg.cmdLineKeyPassphraseDesc());
        OptionGroup privateKP = new OptionGroup();
        Option privateString = new Option("pvk", PRIVATE_KEY_STRING_PARAM, true, ElytronToolMessages.msg.cmdLinePrivateKeyStringDesc());
        Option privateLocation = new Option("pvl", PRIVATE_KEY_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdLinePrivateKeyLocationDesc());
        privateKP.addOption(privateString);
        privateKP.addOption(privateLocation);
        this.options.addOptionGroup(privateKP);
        OptionGroup publicKP = new OptionGroup();
        Option publicString = new Option("pbk", PUBLIC_KEY_STRING_PARAM, true, ElytronToolMessages.msg.cmdLinePublicKeyStringDesc());
        Option publicLocation = new Option("pbl", PUBLIC_KEY_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdLinePublicKeyLocationDesc());
        publicKP.addOption(publicString);
        publicKP.addOption(publicLocation);
        this.options.addOptionGroup(publicKP);
        this.options.addOption(Option.builder().longOpt(SIZE_PARAM).hasArg().argName(SIZE_PARAM).desc(ElytronToolMessages.msg.keySize()).build());
        this.options.addOption(Option.builder().longOpt(KEY_PARAM).hasArg().argName(KEY_PARAM).desc(ElytronToolMessages.msg.key()).build());
        this.options.addOption(Option.builder().longOpt(CLEAR_TEXT).hasArg().argName("clear text").desc(ElytronToolMessages.msg.clearText()).build());
        OptionGroup og = new OptionGroup();
        Option a = new Option("a", ADD_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineAddAliasDesc());
        a.setArgName(ALIAS_ARGUMENT);
        Option e = new Option("e", CHECK_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineCheckAliasDesc());
        e.setArgName(ALIAS_ARGUMENT);
        Option r = new Option("r", REMOVE_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineRemoveAliasDesc());
        r.setArgName(ALIAS_ARGUMENT);
        Option v = new Option("v", ALIASES_PARAM, false, ElytronToolMessages.msg.cmdLineAliasesDesc());
        Option st = new Option("st", CREDENTIAL_TYPES, true, ElytronToolMessages.msg.cmdLineAliasTypes());
        st.setArgName(ALIAS_ARGUMENT);
        Option g = new Option("g", GENERATE_KEY_PAIR_PARAM, true, ElytronToolMessages.msg.cmdLineGenerateKeyPairDesc());
        g.setOptionalArg(false);
        g.setArgName(ALIAS_ARGUMENT);
        Option xp = new Option("xp", EXPORT_KEY_PAIR_PUBLIC_KEY_PARAM, true, ElytronToolMessages.msg.cmdLineExportPublicKeyDesc());
        xp.setOptionalArg(false);
        xp.setArgName(ALIAS_ARGUMENT);
        Option ikp = new Option("ikp", IMPORT_KEY_PAIR_PARAM, true, ElytronToolMessages.msg.cmdLineImportKeyPairDesc());
        ikp.setOptionalArg(false);
        ikp.setArgName(ALIAS_ARGUMENT);
        og.addOption(a);
        og.addOption(e);
        og.addOption(r);
        og.addOption(v);
        og.addOption(st);
        og.addOption(g);
        og.addOption(xp);
        og.addOption(ikp);
        og.addOption(Option.builder().longOpt(GENERATE_SECRET_KEY).hasArg().argName(ALIAS_ARGUMENT).desc(ElytronToolMessages.msg.generateSecretKey()).build());
        og.addOption(Option.builder().longOpt(EXPORT_SECRET_KEY).hasArg().argName(ALIAS_ARGUMENT).desc(ElytronToolMessages.msg.exportSecretKey()).build());
        og.addOption(Option.builder().longOpt(IMPORT_SECRET_KEY).hasArg().argName(ALIAS_ARGUMENT).desc(ElytronToolMessages.msg.importSecretKey()).build());
        og.addOption(Option.builder().longOpt(ENCRYPT).hasArg().argName(ALIAS_ARGUMENT).desc(ElytronToolMessages.msg.encrypt()).build());
        Option h = new Option("h", HELP_PARAM, false, ElytronToolMessages.msg.cmdLineHelp());
        Option d = new Option("d", DEBUG_PARAM, false, ElytronToolMessages.msg.cmdLineDebug());
        this.options.addOptionGroup(og);
        this.options.addOption(h);
        this.options.addOption(d);
    }

    private static void readAttributesForView(Path path, String prefix, String attributes, Map<String, Object> attrs) {
        try {
            Map<String, Object> newAttrs = Files.readAttributes(path, attributes, new LinkOption[0]);
            if (newAttrs != null) {
                for (Map.Entry<String, Object> e : newAttrs.entrySet()) {
                    attrs.put(prefix + e.getKey(), e.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Map<String, Object> readAttributesForPreservation(Path path) throws IOException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (Files.exists(path, new LinkOption[0])) {
            Set<String> supportedViews = path.getFileSystem().supportedFileAttributeViews();
            if (supportedViews.contains("posix")) {
                CredentialStoreCommand.readAttributesForView(path, "posix:", "posix:permissions", attrs);
            }
            if (supportedViews.contains("dos")) {
                CredentialStoreCommand.readAttributesForView(path, "dos:", "dos:readonly,hidden,archive,system", attrs);
            }
            if (supportedViews.contains("acl")) {
                CredentialStoreCommand.readAttributesForView(path, "acl:", "acl:acl", attrs);
            }
        }
        return attrs;
    }

    public static void setAttributesForPreservation(Path path, Map<String, Object> attrs) throws IOException {
        if (attrs != null && Files.exists(path, new LinkOption[0])) {
            for (Map.Entry<String, Object> attribute : attrs.entrySet()) {
                Files.setAttribute(path, attribute.getKey(), attribute.getValue(), new LinkOption[0]);
            }
        }
    }

    @Override
    public void execute(String[] args) throws Exception {
        CredentialStore credentialStore;
        this.setStatus(GENERAL_CONFIGURATION_ERROR);
        this.cmdLine = this.parser.parse(this.options, args, false);
        this.setEnableDebug(this.cmdLine.hasOption(DEBUG_PARAM));
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.help();
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            return;
        }
        this.printDuplicatesWarning(this.cmdLine);
        String location = this.cmdLine.getOptionValue(STORE_LOCATION_PARAM);
        if ((this.cmdLine.hasOption(ALIASES_PARAM) || this.cmdLine.hasOption(CHECK_ALIAS_PARAM) || this.cmdLine.hasOption(CREDENTIAL_TYPES)) && location != null && !Files.exists(Paths.get(location, new String[0]), new LinkOption[0])) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.storageFileDoesNotExist(location);
        }
        String csPassword = this.cmdLine.getOptionValue(CREDENTIAL_STORE_PASSWORD_PARAM);
        String password = csPassword == null ? "" : csPassword;
        String salt = this.cmdLine.getOptionValue(SALT_PARAM);
        String csType = this.cmdLine.getOptionValue(CREDENTIAL_STORE_TYPE_PARAM, KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE);
        int iterationCount = this.getArgumentAsInt(this.cmdLine.getOptionValue(ITERATION_PARAM));
        String entryType = this.cmdLine.getOptionValue(ENTRY_TYPE_PARAM);
        String otherProviders = this.cmdLine.getOptionValue(OTHER_PROVIDERS_PARAM);
        String csProvider = this.cmdLine.getOptionValue(CUSTOM_CREDENTIAL_STORE_PROVIDER_PARAM);
        boolean createStorage = this.cmdLine.hasOption(CREATE_CREDENTIAL_STORE_PARAM);
        if (createStorage && this.cmdLine.getArgs().length > 0) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.noArgumentOption(CREATE_CREDENTIAL_STORE_PARAM);
        }
        if (!createStorage && location != null && !Files.exists(Paths.get(location, new String[0]), new LinkOption[0])) {
            throw ElytronToolMessages.msg.locationDoesNotExistCreationDisabled(location);
        }
        boolean printSummary = this.cmdLine.hasOption(PRINT_SUMMARY_PARAM);
        String secret = this.cmdLine.getOptionValue(PASSWORD_CREDENTIAL_VALUE_PARAM);
        String key = this.cmdLine.getOptionValue(KEY_PARAM);
        int size = this.getArgumentAsInt(this.cmdLine.getOptionValue(SIZE_PARAM), 256);
        Map<String, String> implProps = CredentialStoreCommand.parseCredentialStoreProperties(this.cmdLine.getOptionValue(IMPLEMENTATION_PROPERTIES_PARAM));
        if (csProvider != null) {
            credentialStore = CredentialStore.getInstance((String)csType, (String)csProvider, this.getProvidersSupplier(csProvider));
        } else {
            try {
                credentialStore = CredentialStore.getInstance((String)csType);
            }
            catch (NoSuchAlgorithmException e) {
                credentialStore = CredentialStore.getInstance((String)csType, this.getProvidersSupplier(null));
            }
        }
        implProps.put(STORE_LOCATION_PARAM, location);
        implProps.putIfAbsent("modifiable", Boolean.TRUE.toString());
        implProps.putIfAbsent(CREATE_CREDENTIAL_STORE_PARAM, Boolean.valueOf(createStorage).toString());
        if (csType.equals(KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE)) {
            implProps.putIfAbsent("keyStoreType", "JCEKS");
        }
        String implPropsKeyStoreType = implProps.get("keyStoreType");
        if (location == null && implPropsKeyStoreType != null && filebasedKeystoreTypes.contains(implPropsKeyStoreType.toUpperCase(Locale.ENGLISH))) {
            throw ElytronToolMessages.msg.filebasedKeystoreLocationMissing(implPropsKeyStoreType);
        }
        CredentialStore.CredentialSourceProtectionParameter credentialSourceProtectionParameter = null;
        if (csPassword == null && !PropertiesCredentialStore.NAME.equals(csType) && (csPassword = this.prompt(false, ElytronToolMessages.msg.credentialStorePasswordPrompt(), createStorage, ElytronToolMessages.msg.credentialStorePasswordPromptConfirm())) == null) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(CREDENTIAL_STORE_PASSWORD_PARAM);
        }
        if (csPassword != null) {
            char[] passwordCredential = csPassword.startsWith("MASK-") ? MaskCommand.decryptMasked(csPassword) : csPassword.toCharArray();
            credentialSourceProtectionParameter = new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])passwordCredential))));
        }
        credentialStore.initialize(implProps, credentialSourceProtectionParameter, this.getProvidersSupplier(otherProviders).get());
        if (csPassword != null && !csPassword.startsWith("MASK-") && salt != null && iterationCount > -1) {
            password = MaskCommand.computeMasked(csPassword, salt, iterationCount);
        }
        String cipherTextToken = null;
        if (this.cmdLine.hasOption(ADD_ALIAS_PARAM)) {
            this.addAlias(secret, credentialStore, entryType, location);
        } else if (this.cmdLine.hasOption(REMOVE_ALIAS_PARAM)) {
            this.removeAlias(credentialStore, entryType, csType);
        } else if (this.cmdLine.hasOption(CHECK_ALIAS_PARAM)) {
            this.checkAlias(credentialStore, entryType, csType);
        } else if (this.cmdLine.hasOption(ALIASES_PARAM)) {
            this.aliases(credentialStore);
        } else if (this.cmdLine.hasOption(CREDENTIAL_TYPES)) {
            this.aliasCredentialTypes(credentialStore);
        } else if (this.cmdLine.hasOption(GENERATE_KEY_PAIR_PARAM)) {
            this.generateKeyPair(credentialStore);
        } else if (this.cmdLine.hasOption(EXPORT_KEY_PAIR_PUBLIC_KEY_PARAM)) {
            this.exportKeyPairPublicKey(credentialStore, entryType);
        } else if (this.cmdLine.hasOption(IMPORT_KEY_PAIR_PARAM)) {
            this.importKeyPair(credentialStore);
        } else if (this.cmdLine.hasOption(GENERATE_SECRET_KEY)) {
            this.generateSecretKey(credentialStore, entryType, size);
        } else if (this.cmdLine.hasOption(EXPORT_SECRET_KEY)) {
            this.exportSecretKey(credentialStore);
        } else if (this.cmdLine.hasOption(IMPORT_SECRET_KEY)) {
            this.importSecretKey(credentialStore, entryType, key);
        } else if (this.cmdLine.hasOption(ENCRYPT)) {
            cipherTextToken = this.encrypt(credentialStore);
        } else if (this.cmdLine.hasOption(CREATE_CREDENTIAL_STORE_PARAM)) {
            this.createCredentialStore(credentialStore);
        } else {
            this.setStatus(ACTION_NOT_DEFINED);
            throw ElytronToolMessages.msg.actionToPerformNotDefined();
        }
        if (printSummary) {
            StringBuilder com = new StringBuilder();
            if (this.cmdLine.hasOption(ADD_ALIAS_PARAM)) {
                if (implProps.get(CREATE_CREDENTIAL_STORE_PARAM) != null && implProps.get(CREATE_CREDENTIAL_STORE_PARAM).equals("true")) {
                    CredentialStoreCommand.getCreateDefaultSummary(implProps, com, password);
                    com.append("\n");
                }
                com.append("/subsystem=elytron/credential-store=test:add-alias(alias=");
                com.append(this.cmdLine.getOptionValue(ADD_ALIAS_PARAM));
                if (entryType != null) {
                    com.append(",entry-type=\"").append(entryType).append("\"");
                }
                com.append(",secret-value=\"");
                com.append(secret);
                com.append("\")");
            } else if (this.cmdLine.hasOption(REMOVE_ALIAS_PARAM)) {
                com.append("/subsystem=elytron/credential-store=test:remove-alias(alias=");
                com.append(this.cmdLine.getOptionValue(REMOVE_ALIAS_PARAM));
                com.append(")");
            } else if (this.cmdLine.hasOption(ALIASES_PARAM) || this.cmdLine.hasOption(CHECK_ALIAS_PARAM)) {
                com.append("/subsystem=elytron/credential-store=test:read-aliases()");
            } else if (this.cmdLine.hasOption(ENCRYPT)) {
                CredentialStoreCommand.getUseExpressionExample(com, cipherTextToken);
            } else if (this.cmdLine.hasOption(CREATE_CREDENTIAL_STORE_PARAM)) {
                if (PropertiesCredentialStore.NAME.equals(csType)) {
                    CredentialStoreCommand.getCreatePropertiesCredentialStoreSummary(com, location);
                } else {
                    CredentialStoreCommand.getCreateDefaultSummary(implProps, com, password);
                }
            }
            System.out.println(ElytronToolMessages.msg.commandSummary(com.toString()));
        }
    }

    private void addAlias(String secret, CredentialStore credentialStore, String entryType, String location) throws Exception {
        String alias = this.cmdLine.getOptionValue(ADD_ALIAS_PARAM);
        if (alias.length() == 0) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(ADD_ALIAS_PARAM);
        }
        if (secret == null && (secret = this.prompt(false, ElytronToolMessages.msg.secretToStorePrompt(), true, ElytronToolMessages.msg.secretToStorePromptConfirm())) == null) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(PASSWORD_CREDENTIAL_VALUE_PARAM);
        }
        Map<String, Object> locationAttributes = CredentialStoreCommand.readAttributesForPreservation(Paths.get(location, new String[0]));
        credentialStore.store(alias, this.createCredential(secret, entryType));
        credentialStore.flush();
        if (entryType != null) {
            System.out.println(ElytronToolMessages.msg.aliasStored(alias, entryType));
        } else {
            System.out.println(ElytronToolMessages.msg.aliasStored(alias));
        }
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        CredentialStoreCommand.setAttributesForPreservation(Paths.get(location, new String[0]), locationAttributes);
    }

    private void removeAlias(CredentialStore credentialStore, String entryType, String storeType) throws Exception {
        Class<? extends Credential> credClazz;
        String alias = this.cmdLine.getOptionValue(REMOVE_ALIAS_PARAM);
        if (credentialStore.exists(alias, credClazz = this.entryTypeToCredential(entryType, storeType))) {
            credentialStore.remove(alias, credClazz);
            credentialStore.flush();
            if (entryType != null) {
                System.out.println(ElytronToolMessages.msg.aliasRemoved(alias, entryType));
            } else {
                System.out.println(ElytronToolMessages.msg.aliasRemoved(alias));
            }
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else {
            if (entryType != null) {
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias, entryType));
            } else {
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
            }
            this.setStatus(ALIAS_NOT_FOUND);
        }
    }

    private void checkAlias(CredentialStore credentialStore, String entryType, String storeType) throws Exception {
        String alias = this.cmdLine.getOptionValue(CHECK_ALIAS_PARAM);
        if (credentialStore.exists(alias, this.entryTypeToCredential(entryType, storeType))) {
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            System.out.println(ElytronToolMessages.msg.aliasExists(alias));
        } else {
            this.setStatus(ALIAS_NOT_FOUND);
            if (entryType != null) {
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias, entryType));
            } else {
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
            }
        }
    }

    private void aliases(CredentialStore credentialStore) throws Exception {
        Set aliases = credentialStore.getAliases();
        if (aliases.size() != 0) {
            StringBuilder list = new StringBuilder();
            for (String alias : aliases) {
                list.append(alias).append(" ");
            }
            System.out.println(ElytronToolMessages.msg.aliases(list.toString()));
        } else {
            System.out.println(ElytronToolMessages.msg.noAliases());
        }
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
    }

    private void aliasCredentialTypes(CredentialStore credentialStore) {
        String alias = this.cmdLine.getOptionValue(CREDENTIAL_TYPES);
        Set types = credentialStore.getCredentialTypesForAlias(alias);
        if (types.size() != 0) {
            StringBuilder list = new StringBuilder();
            for (String type : types) {
                list.append(" ").append(type);
            }
            System.out.println(ElytronToolMessages.msg.types(list.toString(), alias));
        } else {
            System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
        }
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
    }

    private void generateKeyPair(CredentialStore credentialStore) throws Exception {
        String alias = this.cmdLine.getOptionValue(GENERATE_KEY_PAIR_PARAM);
        if (alias == null || alias.isEmpty()) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(GENERATE_KEY_PAIR_PARAM);
        }
        int size = this.getArgumentAsInt(this.cmdLine.getOptionValue(SIZE_PARAM));
        String algorithm = this.cmdLine.getOptionValue(ALGORITHM_PARAM);
        if (algorithm == null) {
            algorithm = RSA_ALGORITHM;
        }
        credentialStore.store(alias, (Credential)this.createKeyPairCredential(algorithm, size));
        credentialStore.flush();
        System.out.println(ElytronToolMessages.msg.aliasStored(alias, KeyPairCredential.class.getName()));
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
    }

    private void exportKeyPairPublicKey(CredentialStore credentialStore, String entryType) throws Exception {
        String alias = this.cmdLine.getOptionValue(EXPORT_KEY_PAIR_PUBLIC_KEY_PARAM);
        if (alias == null || alias.isEmpty()) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(EXPORT_KEY_PAIR_PUBLIC_KEY_PARAM);
        }
        if (credentialStore.exists(alias, KeyPairCredential.class)) {
            KeyPairCredential credential = (KeyPairCredential)credentialStore.retrieve(alias, KeyPairCredential.class);
            System.out.println(PublicKeyEntry.toString((PublicKey)credential.getKeyPair().getPublic()));
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else {
            this.setStatus(ALIAS_NOT_FOUND);
            if (entryType != null) {
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias, entryType));
            } else {
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importKeyPair(CredentialStore credentialStore) throws Exception {
        String privateKeyContent;
        byte[] keyData;
        FileInputStream stream;
        File keyFile;
        String publicKeyFile;
        String publicKeyString;
        String publicKeyContent;
        ElytronFilePasswordProvider passwordProvider;
        String alias;
        block17: {
            String privateKeyString;
            block16: {
                alias = this.cmdLine.getOptionValue(IMPORT_KEY_PAIR_PARAM);
                if (alias == null || alias.isEmpty()) {
                    this.setStatus(GENERAL_CONFIGURATION_ERROR);
                    throw ElytronToolMessages.msg.optionNotSpecified(IMPORT_KEY_PAIR_PARAM);
                }
                String passphrase = this.cmdLine.getOptionValue(KEY_PASSPHRASE_PARAM);
                if (passphrase == null || passphrase.isEmpty()) {
                    passphrase = this.prompt(false, ElytronToolMessages.msg.keyPassphrasePrompt(), true, ElytronToolMessages.msg.keyPassphrasePromptConfirm());
                }
                passwordProvider = new ElytronFilePasswordProvider(this.createCredential(passphrase, PasswordCredential.class.getName()));
                publicKeyContent = null;
                privateKeyString = this.cmdLine.getOptionValue(PRIVATE_KEY_STRING_PARAM);
                publicKeyString = this.cmdLine.getOptionValue(PUBLIC_KEY_STRING_PARAM);
                String privateKeyFile = this.cmdLine.getOptionValue(PRIVATE_KEY_LOCATION_PARAM);
                publicKeyFile = this.cmdLine.getOptionValue(PUBLIC_KEY_LOCATION_PARAM);
                if (privateKeyFile == null) break block16;
                if (!Files.exists(Paths.get(privateKeyFile, new String[0]), new LinkOption[0])) {
                    this.setStatus(GENERAL_CONFIGURATION_ERROR);
                    throw ElytronToolMessages.msg.keyFileDoesNotExist(privateKeyFile);
                }
                keyFile = new File(privateKeyFile);
                stream = null;
                keyData = null;
                try {
                    stream = new FileInputStream(keyFile);
                    keyData = new byte[stream.available()];
                    stream.read(keyData, 0, stream.available());
                }
                catch (Throwable throwable) {
                    CredentialStoreCommand.safeClose(stream);
                    throw throwable;
                }
                CredentialStoreCommand.safeClose(stream);
                privateKeyContent = new String(keyData);
                break block17;
            }
            if (privateKeyString != null) {
                privateKeyContent = privateKeyString;
            } else {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw ElytronToolMessages.msg.noPrivateKeySpecified();
            }
        }
        if (privateKeyContent.isEmpty()) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.noPrivateKeySpecified();
        }
        if (publicKeyFile != null) {
            if (!Files.exists(Paths.get(publicKeyFile, new String[0]), new LinkOption[0])) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw ElytronToolMessages.msg.keyFileDoesNotExist(publicKeyFile);
            }
            keyFile = new File(publicKeyFile);
            stream = null;
            keyData = null;
            try {
                stream = new FileInputStream(keyFile);
                keyData = new byte[stream.available()];
                stream.read(keyData, 0, stream.available());
            }
            finally {
                CredentialStoreCommand.safeClose(stream);
            }
            publicKeyContent = new String(keyData);
        } else if (publicKeyString != null) {
            publicKeyContent = publicKeyString;
        }
        KeyPairCredential keyPairCredential = this.parseKeyPairCredential(privateKeyContent, publicKeyContent, (FilePasswordProvider)passwordProvider);
        credentialStore.store(alias, (Credential)keyPairCredential);
        credentialStore.flush();
        System.out.println(ElytronToolMessages.msg.aliasStored(alias, KeyPairCredential.class.getName()));
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
    }

    private void generateSecretKey(CredentialStore credentialStore, String entryType, int size) throws Exception {
        SecretKey secretKey;
        String alias = this.cmdLine.getOptionValue(GENERATE_SECRET_KEY);
        if (alias.length() == 0) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(ALIAS_ARGUMENT);
        }
        try {
            secretKey = SecretKeyUtil.generateSecretKey((int)size);
        }
        catch (Exception e) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw e;
        }
        credentialStore.store(alias, this.createCredential(secretKey, entryType));
        credentialStore.flush();
        if (entryType != null) {
            System.out.println(ElytronToolMessages.msg.aliasStored(alias, entryType));
        } else {
            System.out.println(ElytronToolMessages.msg.aliasStored(alias));
        }
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
    }

    private void exportSecretKey(CredentialStore credentialStore) throws Exception {
        String alias = this.cmdLine.getOptionValue(EXPORT_SECRET_KEY);
        if (alias.length() == 0) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(ALIAS_ARGUMENT);
        }
        if (credentialStore.exists(alias, SecretKeyCredential.class)) {
            SecretKey secretKey = ((SecretKeyCredential)credentialStore.retrieve(alias, SecretKeyCredential.class)).getSecretKey();
            String encoded = SecretKeyUtil.exportSecretKey((SecretKey)secretKey);
            System.out.println(ElytronToolMessages.msg.exportedSecretKey(alias, encoded));
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else {
            this.setStatus(ALIAS_NOT_FOUND);
            System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
        }
    }

    private void importSecretKey(CredentialStore credentialStore, String entryType, String key) throws Exception {
        SecretKey secretKey;
        String alias = this.cmdLine.getOptionValue(IMPORT_SECRET_KEY);
        if (alias.length() == 0) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(ALIAS_ARGUMENT);
        }
        if (key == null && (key = this.prompt(true, ElytronToolMessages.msg.keyToImport(), false, null)) == null) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(KEY_PARAM);
        }
        try {
            secretKey = SecretKeyUtil.importSecretKey((String)key);
        }
        catch (Exception e) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw e;
        }
        credentialStore.store(alias, this.createCredential(secretKey, entryType));
        credentialStore.flush();
        if (entryType != null) {
            System.out.println(ElytronToolMessages.msg.aliasStored(alias, entryType));
        } else {
            System.out.println(ElytronToolMessages.msg.aliasStored(alias));
        }
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
    }

    private String encrypt(CredentialStore credentialStore) throws Exception {
        String alias = this.cmdLine.getOptionValue(ENCRYPT);
        if (alias.length() == 0) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(ALIAS_ARGUMENT);
        }
        String cipherTextToken = null;
        if (credentialStore.exists(alias, SecretKeyCredential.class)) {
            SecretKey secretKey = ((SecretKeyCredential)credentialStore.retrieve(alias, SecretKeyCredential.class)).getSecretKey();
            String clearText = this.cmdLine.getOptionValue(CLEAR_TEXT);
            if (clearText == null) {
                clearText = this.prompt(false, ElytronToolMessages.msg.clearTextToImport(), true, ElytronToolMessages.msg.clearTextToImportAgain());
            }
            cipherTextToken = CipherUtil.encrypt((String)clearText, (SecretKey)secretKey);
            System.out.println(ElytronToolMessages.msg.encryptedToken(cipherTextToken, alias));
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else {
            this.setStatus(ALIAS_NOT_FOUND);
            System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
        }
        return cipherTextToken;
    }

    private void createCredentialStore(CredentialStore credentialStore) throws Exception {
        credentialStore.flush();
        System.out.println(ElytronToolMessages.msg.credentialStoreCreated());
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
    }

    private Credential createCredential(String secret, String entryType) {
        if (entryType == null || PasswordCredential.class.getSimpleName().equals(entryType) || PasswordCredential.class.getName().equals(entryType)) {
            return new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])secret.toCharArray()));
        }
        throw ElytronToolMessages.msg.unknownEntryType(entryType);
    }

    private KeyPairCredential createKeyPairCredential(String algorithm, int size) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator;
        switch (algorithm) {
            case "RSA": {
                size = 512 <= size && size <= 16384 ? size : 2048;
                break;
            }
            case "DSA": {
                size = 512 <= size && size <= 1024 && size % 64 == 0 || size == 2048 || size == 3072 ? size : 2048;
                break;
            }
            case "EC": {
                size = 112 <= size && size <= 571 ? size : 256;
                break;
            }
            default: {
                algorithm = RSA_ALGORITHM;
                size = 2048;
            }
        }
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronToolMessages.msg.unknownKeyPairAlgorithm(algorithm);
        }
        try {
            keyPairGenerator.initialize(size, new SecureRandom());
        }
        catch (InvalidParameterException e) {
            throw ElytronToolMessages.msg.invalidKeySize(e.getMessage());
        }
        KeyPairCredential keyPairCredential = new KeyPairCredential(keyPairGenerator.generateKeyPair());
        return keyPairCredential;
    }

    private KeyPairCredential parseKeyPairCredential(String privateKeyContent, String publicKeyContent, FilePasswordProvider passwordProvider) throws Exception {
        KeyPair keyPair;
        try {
            keyPair = (KeyPair)((PemEntry)Pem.parsePemOpenSSHContent((CodePointIterator)CodePointIterator.ofString((String)privateKeyContent), (FilePasswordProvider)passwordProvider).next()).tryCast(KeyPair.class);
            if (keyPair == null) {
                throw ElytronToolMessages.msg.xmlNoPemContent();
            }
        }
        catch (IllegalArgumentException e) {
            if (publicKeyContent == null || publicKeyContent.isEmpty()) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw ElytronToolMessages.msg.noPublicKeySpecified();
            }
            PrivateKey privateKey = (PrivateKey)((PemEntry)Pem.parsePemContent((CodePointIterator)CodePointIterator.ofString((String)privateKeyContent)).next()).tryCast(PrivateKey.class);
            if (privateKey == null) {
                throw ElytronToolMessages.msg.xmlNoPemContent();
            }
            PublicKey publicKey = (PublicKey)((PemEntry)Pem.parsePemContent((CodePointIterator)CodePointIterator.ofString((String)publicKeyContent)).next()).tryCast(PublicKey.class);
            if (publicKey == null) {
                throw ElytronToolMessages.msg.xmlNoPemContent();
            }
            keyPair = new KeyPair(publicKey, privateKey);
        }
        return new KeyPairCredential(keyPair);
    }

    private Credential createCredential(SecretKey secretKey, String entryType) {
        if (entryType == null || SecretKeyCredential.class.getSimpleName().equals(entryType) || SecretKeyCredential.class.getName().equals(entryType)) {
            return new SecretKeyCredential(secretKey);
        }
        throw ElytronToolMessages.msg.unknownEntryType(entryType);
    }

    private Class<? extends Credential> entryTypeToCredential(String entryType, String storeType) {
        if (entryType == null) {
            return CredentialStoreCommand.defaultCredentialType(storeType);
        }
        if (PasswordCredential.class.getSimpleName().equals(entryType) || PasswordCredential.class.getName().equals(entryType)) {
            return PasswordCredential.class;
        }
        if (KeyPairCredential.class.getName().equals(entryType)) {
            return KeyPairCredential.class;
        }
        if (SecretKeyCredential.class.getSimpleName().equals(entryType) || SecretKeyCredential.class.getName().equals(entryType)) {
            return SecretKeyCredential.class;
        }
        throw ElytronToolMessages.msg.unknownEntryType(entryType);
    }

    private static Class<? extends Credential> defaultCredentialType(String storeType) {
        if (PropertiesCredentialStore.NAME.equals(storeType)) {
            return SecretKeyCredential.class;
        }
        return PasswordCredential.class;
    }

    @Override
    protected Set<String> aliases() {
        return Stream.of("cs", "credstore").collect(Collectors.toSet());
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(WIDTH);
        help.printHelp(ElytronToolMessages.msg.cmdHelp(this.getToolCommand(), CREDENTIAL_STORE_COMMAND), ElytronToolMessages.msg.cmdLineCredentialStoreHelpHeader().concat(ElytronToolMessages.msg.cmdLineActionsHelpHeader()), this.options, "", true);
    }

    static Map<String, String> parseCredentialStoreProperties(String attributeString) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (attributeString != null) {
            for (String pair : attributeString.split(";")) {
                String[] parts = pair.split("=");
                if (parts[0] == null || parts[0].isEmpty() || parts[1] == null) {
                    throw ElytronToolMessages.msg.cannotParseProps();
                }
                attributes.put(parts[0], parts[1]);
            }
        }
        return attributes;
    }

    static String formatPropertiesForCli(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            properties.remove(CREATE_CREDENTIAL_STORE_PARAM);
            properties.remove(STORE_LOCATION_PARAM);
            properties.remove("modifiable");
            boolean first = true;
            StringBuilder attr = new StringBuilder("implementation-properties={");
            for (String name : properties.keySet()) {
                if (!first) {
                    attr.append(",");
                } else {
                    first = false;
                }
                attr.append("\"" + name + "\"=>\"" + properties.get(name) + "\"");
            }
            attr.append("}");
            return attr.toString();
        }
        return "";
    }

    private int getArgumentAsInt(String argument) throws Exception {
        return this.getArgumentAsInt(argument, -1);
    }

    private int getArgumentAsInt(String argument, int defaultValue) throws Exception {
        if (argument != null && !argument.isEmpty()) {
            try {
                return Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw new Exception(e);
            }
        }
        return defaultValue;
    }

    static void getCreateDefaultSummary(Map<String, String> implProps, StringBuilder com, String password) {
        com.append("/subsystem=elytron/credential-store=test:add(");
        com.append("relative-to=jboss.server.data.dir,");
        if (implProps != null && !implProps.isEmpty()) {
            String props;
            if (implProps.get(CREATE_CREDENTIAL_STORE_PARAM) != null) {
                com.append("create=").append(implProps.get(CREATE_CREDENTIAL_STORE_PARAM)).append(",");
            }
            if (implProps.get("modifiable") != null) {
                com.append("modifiable=").append(implProps.get("modifiable")).append(",");
            }
            if (implProps.get(STORE_LOCATION_PARAM) != null) {
                com.append("location=\"").append(implProps.get(STORE_LOCATION_PARAM)).append("\",");
            }
            if (!(props = CredentialStoreCommand.formatPropertiesForCli(implProps)).isEmpty()) {
                com.append(props);
                com.append(",");
            }
        }
        com.append("credential-reference={");
        com.append("clear-text=\"");
        com.append(password);
        com.append("\"})");
    }

    static void getCreatePropertiesCredentialStoreSummary(StringBuilder com, String location) {
        com.append("/subsystem=elytron/secret-key-credential-store=test:add(");
        com.append("relative-to=jboss.server.data.dir,");
        com.append("path=\"").append(location).append("\")");
    }

    static void getUseExpressionExample(StringBuilder com, String cipherTextToken) {
        com.append("/subsystem=example:write-attribute(");
        com.append("name=example,");
        com.append("value=\"${ENC::RESOLVER:").append(cipherTextToken).append("}\")");
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

