/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.buffer;

import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.buffer.TimedBufferObserver;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.jboss.logging.Logger;

public final class TimedBuffer
extends CriticalComponentImpl {
    protected static final int CRITICAL_PATHS = 6;
    protected static final int CRITICAL_PATH_FLUSH = 0;
    protected static final int CRITICAL_PATH_STOP = 1;
    protected static final int CRITICAL_PATH_START = 2;
    protected static final int CRITICAL_PATH_CHECK_SIZE = 3;
    protected static final int CRITICAL_PATH_ADD_BYTES = 4;
    protected static final int CRITICAL_PATH_SET_OBSERVER = 5;
    private static final Logger logger = Logger.getLogger(TimedBuffer.class);
    private static final double MAX_TIMEOUT_ERROR_FACTOR = 1.5;
    private static final int MAX_CHECKS_ON_SLEEP = 20;
    private final Semaphore spinLimiter = new Semaphore(1);
    private final int bufferSize;
    private final ActiveMQBuffer buffer;
    private final int timeout;
    private final boolean logRates;
    private final AtomicLong bytesFlushed = new AtomicLong(0L);
    private final AtomicLong flushesDone = new AtomicLong(0L);
    private TimedBufferObserver bufferObserver;
    private CheckTimer timerRunnable;
    private int bufferLimit = 0;
    private List<IOCallback> callbacks;
    private volatile boolean pendingSync = false;
    private Thread timerThread;
    private volatile boolean started;
    private boolean delayFlush;
    private Timer logRatesTimer;
    private TimerTask logRatesTimerTask;
    private boolean spinning = false;

    public TimedBuffer(CriticalAnalyzer analyzer, int size, int timeout, boolean logRates) {
        super(analyzer, 6);
        this.bufferSize = size;
        this.logRates = logRates;
        if (logRates) {
            this.logRatesTimer = new Timer(true);
        }
        this.buffer = new ChannelBufferWrapper(Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocateDirect(size)));
        this.buffer.clear();
        this.bufferLimit = 0;
        this.callbacks = new ArrayList<IOCallback>();
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try (CriticalCloseable critical = this.measureCritical(2);){
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                block22: {
                    if (!this.started) break block22;
                    return;
                }
                try {
                    this.spinLimiter.acquire();
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
                this.timerRunnable = new CheckTimer();
                this.timerThread = new Thread((Runnable)this.timerRunnable, "activemq-buffer-timeout");
                this.timerThread.start();
                if (this.logRates) {
                    this.logRatesTimerTask = new LogRatesTimerTask();
                    this.logRatesTimer.scheduleAtFixedRate(this.logRatesTimerTask, 2000L, 2000L);
                }
                this.started = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Thread localTimer = null;
        try (CriticalCloseable measure = this.measureCritical(1);){
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                try {
                    if (!this.started) {
                        return;
                    }
                    this.flush();
                    this.bufferObserver = null;
                    this.timerRunnable.close();
                    this.spinLimiter.release();
                    if (this.logRates) {
                        this.logRatesTimerTask.cancel();
                    }
                    localTimer = this.timerThread;
                    this.timerThread = null;
                }
                finally {
                    this.started = false;
                }
            }
            if (localTimer == null) return;
            while (localTimer.isAlive()) {
                try {
                    localTimer.join(1000L);
                    if (!localTimer.isAlive()) continue;
                    localTimer.interrupt();
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObserver(TimedBufferObserver observer) {
        try (CriticalCloseable measure = this.measureCritical(5);){
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                if (this.bufferObserver != null) {
                    this.flush();
                }
                this.bufferObserver = observer;
            }
        }
        catch (Exception shouldNotHappen) {
            logger.debug((Object)shouldNotHappen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean checkSize(int sizeChecked) {
        boolean bl;
        Throwable throwable;
        CriticalCloseable measure;
        block24: {
            block20: {
                boolean bl2;
                block23: {
                    int remainingInFile;
                    block21: {
                        boolean bl3;
                        block22: {
                            measure = this.measureCritical(3);
                            throwable = null;
                            TimedBuffer timedBuffer = this;
                            // MONITORENTER : timedBuffer
                            if (!this.started) {
                                throw new IllegalStateException("TimedBuffer is not started");
                            }
                            if (sizeChecked > this.bufferSize) {
                                throw new IllegalStateException("Can't write records (size=" + sizeChecked + ") bigger than the bufferSize(" + this.bufferSize + ") on the journal");
                            }
                            if (this.bufferLimit != 0 && this.buffer.writerIndex() + sizeChecked <= this.bufferLimit) break block20;
                            this.flush();
                            this.delayFlush = true;
                            remainingInFile = this.bufferObserver.getRemainingBytes();
                            if (sizeChecked <= remainingInFile) break block21;
                            bl3 = false;
                            // MONITOREXIT : timedBuffer
                            if (measure == null) return bl3;
                            if (throwable == null) break block22;
                            try {
                                measure.close();
                                return bl3;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return bl3;
                            }
                        }
                        measure.close();
                        return bl3;
                    }
                    this.bufferLimit = Math.min(remainingInFile, this.bufferSize);
                    bl2 = true;
                    // MONITOREXIT : timedBuffer
                    if (measure == null) return bl2;
                    if (throwable == null) break block23;
                    {
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    try {
                        measure.close();
                        return bl2;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        return bl2;
                    }
                }
                measure.close();
                return bl2;
            }
            this.delayFlush = true;
            bl = true;
            // MONITOREXIT : timedBuffer
            if (measure == null) return bl;
            if (throwable == null) break block24;
            try {
                measure.close();
                return bl;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                return bl;
            }
        }
        measure.close();
        return bl;
        catch (Throwable throwable6) {
            if (measure == null) throw throwable6;
            if (throwable == null) {
                measure.close();
                throw throwable6;
            }
            try {
                measure.close();
                throw throwable6;
            }
            catch (Throwable throwable7) {
                throwable.addSuppressed(throwable7);
                throw throwable6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBytes(ActiveMQBuffer bytes, boolean sync, IOCallback callback) {
        try (CriticalCloseable measure = this.measureCritical(4);){
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                if (!this.started) {
                    throw new IllegalStateException("TimedBuffer is not started");
                }
                this.delayFlush = false;
                int readableBytes = bytes.readableBytes();
                int writerIndex = this.buffer.writerIndex();
                this.buffer.setBytes(writerIndex, bytes, bytes.readerIndex(), readableBytes);
                this.buffer.writerIndex(writerIndex + readableBytes);
                this.callbacks.add(callback);
                if (sync) {
                    this.pendingSync = true;
                    this.startSpin();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBytes(EncodingSupport bytes, boolean sync, IOCallback callback) {
        try (CriticalCloseable measure = this.measureCritical(4);){
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                if (!this.started) {
                    throw new IllegalStateException("TimedBuffer is not started");
                }
                this.delayFlush = false;
                bytes.encode(this.buffer);
                this.callbacks.add(callback);
                if (sync) {
                    this.pendingSync = true;
                    this.startSpin();
                }
            }
        }
    }

    public void flush() {
        this.flushBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean flushBatch() {
        boolean bl;
        Throwable throwable;
        CriticalCloseable measure;
        block19: {
            block17: {
                boolean bl2;
                block18: {
                    measure = this.measureCritical(0);
                    throwable = null;
                    TimedBuffer timedBuffer = this;
                    // MONITORENTER : timedBuffer
                    if (!this.started) {
                        throw new IllegalStateException("TimedBuffer is not started");
                    }
                    if (this.delayFlush || this.buffer.writerIndex() <= 0) break block17;
                    int pos = this.buffer.writerIndex();
                    if (this.logRates) {
                        this.bytesFlushed.addAndGet(pos);
                    }
                    this.bufferObserver.flushBuffer(this.buffer.byteBuf(), this.pendingSync, this.callbacks);
                    this.stopSpin();
                    this.pendingSync = false;
                    this.callbacks = new ArrayList<IOCallback>();
                    this.buffer.clear();
                    this.bufferLimit = 0;
                    this.flushesDone.incrementAndGet();
                    bl2 = pos > 0;
                    // MONITOREXIT : timedBuffer
                    if (measure == null) return bl2;
                    if (throwable == null) break block18;
                    try {
                        measure.close();
                        return bl2;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return bl2;
                    }
                }
                measure.close();
                return bl2;
            }
            bl = false;
            // MONITOREXIT : timedBuffer
            if (measure == null) return bl;
            if (throwable == null) break block19;
            {
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            try {
                measure.close();
                return bl;
            }
            catch (Throwable throwable4) {
                throwable.addSuppressed(throwable4);
                return bl;
            }
        }
        measure.close();
        return bl;
        catch (Throwable throwable5) {
            if (measure == null) throw throwable5;
            if (throwable == null) {
                measure.close();
                throw throwable5;
            }
            try {
                measure.close();
                throw throwable5;
            }
            catch (Throwable throwable6) {
                throwable.addSuppressed(throwable6);
                throw throwable5;
            }
        }
    }

    protected void sleep(long sleepNanos) {
        LockSupport.parkNanos(sleepNanos);
    }

    protected void stopSpin() {
        if (this.spinning) {
            try {
                this.spinLimiter.acquire();
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException((Throwable)e);
            }
            this.spinning = false;
        }
    }

    protected void startSpin() {
        if (!this.spinning) {
            this.spinLimiter.release();
            this.spinning = true;
        }
    }

    private class CheckTimer
    implements Runnable {
        int checks = 0;
        int failedChecks = 0;
        private volatile boolean closed = false;

        private CheckTimer() {
        }

        @Override
        public void run() {
            long lastFlushTime = System.nanoTime();
            boolean useSleep = true;
            while (!this.closed) {
                if (TimedBuffer.this.pendingSync) {
                    if (useSleep) {
                        lastFlushTime = System.nanoTime();
                        if (TimedBuffer.this.flushBatch()) {
                            long timeFromTheLastFlush = System.nanoTime() - lastFlushTime;
                            long timeToSleep = (long)TimedBuffer.this.timeout - timeFromTheLastFlush;
                            if (timeToSleep > 0L) {
                                useSleep = this.sleepIfPossible(timeToSleep);
                            }
                        }
                    } else if (TimedBuffer.this.bufferObserver != null && System.nanoTime() - lastFlushTime > (long)TimedBuffer.this.timeout) {
                        lastFlushTime = System.nanoTime();
                        TimedBuffer.this.flush();
                    }
                }
                try {
                    TimedBuffer.this.spinLimiter.acquire();
                    Thread.yield();
                    TimedBuffer.this.spinLimiter.release();
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
            }
        }

        private boolean sleepIfPossible(long nanosToSleep) {
            boolean useSleep = true;
            try {
                long startSleep = System.nanoTime();
                TimedBuffer.this.sleep(nanosToSleep);
                if (this.checks < 20) {
                    long elapsedSleep = System.nanoTime() - startSleep;
                    if ((double)elapsedSleep > (double)nanosToSleep * 1.5) {
                        ++this.failedChecks;
                    }
                    if (++this.checks >= 20 && (double)this.failedChecks > 10.0) {
                        logger.debug((Object)"LockSupport.parkNanos with nano seconds is not working as expected, Your kernel possibly doesn't support real time. the Journal TimedBuffer will spin for timeouts");
                        useSleep = false;
                    }
                }
            }
            catch (Exception e) {
                useSleep = false;
                logger.warn((Object)(e.getMessage() + ", disabling sleep on TimedBuffer, using spin now"), (Throwable)e);
            }
            return useSleep;
        }

        public void close() {
            this.closed = true;
        }
    }

    private class LogRatesTimerTask
    extends TimerTask {
        private boolean closed;
        private long lastExecution;
        private long lastBytesFlushed;
        private long lastFlushesDone;

        private LogRatesTimerTask() {
        }

        @Override
        public synchronized void run() {
            if (!this.closed) {
                long now = System.currentTimeMillis();
                long bytesF = TimedBuffer.this.bytesFlushed.get();
                long flushesD = TimedBuffer.this.flushesDone.get();
                if (this.lastExecution != 0L) {
                    double rate = 1000.0 * (double)(bytesF - this.lastBytesFlushed) / (double)(now - this.lastExecution);
                    ActiveMQJournalLogger.LOGGER.writeRate(rate, (long)(rate / 1048576.0));
                    double flushRate = 1000.0 * (double)(flushesD - this.lastFlushesDone) / (double)(now - this.lastExecution);
                    ActiveMQJournalLogger.LOGGER.flushRate(flushRate);
                }
                this.lastExecution = now;
                this.lastBytesFlushed = bytesF;
                this.lastFlushesDone = flushesD;
            }
        }

        @Override
        public synchronized boolean cancel() {
            this.closed = true;
            return super.cancel();
        }
    }
}

