/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldJBossAllConfiguration;
import org.jboss.as.weld.deployment.processors.WeldConfiguration;

public class WeldConfigurationProcessor
implements DeploymentUnitProcessor {
    private final boolean requireBeanDescriptorGlobal;
    private final boolean nonPortableModeGlobal;
    private final boolean developmentModeGlobal;

    public WeldConfigurationProcessor(boolean requireBeanDescriptorGlobal, boolean nonPortableModeGlobal, boolean developmentModeGlobal) {
        this.requireBeanDescriptorGlobal = requireBeanDescriptorGlobal;
        this.nonPortableModeGlobal = nonPortableModeGlobal;
        this.developmentModeGlobal = developmentModeGlobal;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        boolean requireBeanDescriptor = this.requireBeanDescriptorGlobal;
        boolean nonPortableMode = this.nonPortableModeGlobal;
        boolean developmentMode = this.developmentModeGlobal;
        WeldJBossAllConfiguration configuration = (WeldJBossAllConfiguration)deploymentUnit.getAttachment(WeldJBossAllConfiguration.ATTACHMENT_KEY);
        if (configuration != null) {
            requireBeanDescriptor = WeldConfigurationProcessor.getValue(configuration.getRequireBeanDescriptor(), this.requireBeanDescriptorGlobal);
            nonPortableMode = WeldConfigurationProcessor.getValue(configuration.getNonPortableMode(), this.nonPortableModeGlobal);
            developmentMode = WeldConfigurationProcessor.getValue(configuration.getDevelopmentMode(), this.developmentModeGlobal);
        }
        WeldConfiguration mergedConfiguration = new WeldConfiguration(requireBeanDescriptor, nonPortableMode, developmentMode);
        deploymentUnit.putAttachment(WeldConfiguration.ATTACHMENT_KEY, (Object)mergedConfiguration);
    }

    private static boolean getValue(Boolean value, boolean globalValue) {
        if (value != null) {
            return value;
        }
        return globalValue;
    }
}

