/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processor;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.spi.DeploymentUnitDependenciesProvider;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.msc.service.ServiceName;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class JpaDependenciesProvider
implements DeploymentUnitDependenciesProvider {
    public Set<ServiceName> getDependencies(DeploymentUnit deploymentUnit) {
        HashSet<ServiceName> dependencies;
        block3: {
            block2: {
                dependencies = new HashSet<ServiceName>();
                EarMetaData earConfig = (EarMetaData)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(Attachments.EAR_METADATA);
                if (earConfig == null || !earConfig.getInitializeInOrder() || earConfig.getModules().size() <= 1) break block2;
                if (deploymentUnit.getParent() != null) break block3;
                for (ResourceRoot root : DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit)) {
                    if (SubDeploymentMarker.isSubDeployment((ResourceRoot)root)) continue;
                    this.addDependencyOnPersistenceUnit(dependencies, (PersistenceUnitMetadataHolder)root.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS));
                }
                break block3;
            }
            for (ResourceRoot root : DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit)) {
                this.addDependencyOnPersistenceUnit(dependencies, (PersistenceUnitMetadataHolder)root.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS));
            }
        }
        return dependencies;
    }

    private void addDependencyOnPersistenceUnit(Set<ServiceName> dependencies, PersistenceUnitMetadataHolder persistenceUnits) {
        if (persistenceUnits != null && persistenceUnits.getPersistenceUnits() != null) {
            for (PersistenceUnitMetadata pu : persistenceUnits.getPersistenceUnits()) {
                Properties properties = pu.getProperties();
                String jpaContainerManaged = properties.getProperty("jboss.as.jpa.managed");
                boolean deployPU = jpaContainerManaged == null || Boolean.parseBoolean(jpaContainerManaged);
                if (!deployPU) continue;
                ServiceName serviceName = PersistenceUnitServiceImpl.getPUServiceName((PersistenceUnitMetadata)pu);
                dependencies.add(serviceName);
            }
        }
    }
}

