/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context;

import java.io.IOException;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context.ElytronSSLContextRegistry;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context._private.MicroProfileReactiveMessagingKafkaLogger;

public class WildFlyKafkaSSLEngineFactory
implements SslEngineFactory {
    private volatile SSLContext sslContext;

    public void configure(Map<String, ?> configs) {
        SSLContext context = ElytronSSLContextRegistry.getInstalledSSLContext((String)configs.get("wildfly.elytron.ssl.context"));
        if (context == null) {
            throw MicroProfileReactiveMessagingKafkaLogger.LOGGER.noElytronClientSSLContext((String)configs.get("wildfly.elytron.ssl.context"));
        }
        this.sslContext = context;
    }

    public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(peerHost, peerPort);
        sslEngine.setUseClientMode(true);
        SSLParameters sslParams = sslEngine.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("https");
        sslEngine.setSSLParameters(sslParams);
        return sslEngine;
    }

    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        throw new UnsupportedOperationException();
    }

    public boolean shouldBeRebuilt(Map<String, Object> nextConfigs) {
        return false;
    }

    public Set<String> reconfigurableConfigs() {
        return Collections.emptySet();
    }

    public KeyStore keystore() {
        return null;
    }

    public KeyStore truststore() {
        return null;
    }

    public void close() throws IOException {
        this.sslContext = null;
    }
}

