/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.jboss.logging.Logger;

public class LargeBody {
    private static final Logger logger = Logger.getLogger(LargeBody.class);
    private long bodySize = -1L;
    long NO_PENDING_ID;
    private long pendingRecordID = this.NO_PENDING_ID = -1L;
    StorageManager storageManager;
    private long messageID = -1L;
    private LargeServerMessage message;
    private boolean paged;
    private SequentialFile file;

    public LargeBody(LargeServerMessage message, StorageManager storageManager) {
        this.storageManager = storageManager;
        this.message = message;
    }

    public LargeBody(LargeServerMessage message, StorageManager storageManager, SequentialFile file) {
        this(message, storageManager);
        this.file = file;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public void setMessage(LargeServerMessage message) {
        this.message = message;
    }

    public void setPaged() {
        this.paged = true;
    }

    public boolean isPaged() {
        return this.paged;
    }

    public void clearFile() {
        if (this.file != null && this.file.isOpen()) {
            try {
                this.file.close();
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.file = null;
    }

    public synchronized void deleteFile() {
        try {
            this.validateFile();
            this.releaseResources(false, false);
            this.storageManager.deleteLargeMessageBody(this.message);
        }
        catch (Exception e) {
            this.storageManager.criticalError(e);
        }
    }

    public long getMessageID() {
        if (this.message == null) {
            return this.messageID;
        }
        return this.message.getMessageID();
    }

    public synchronized void addBytes(byte[] bytes) throws Exception {
        this.validateFile();
        if (!this.file.isOpen()) {
            this.file.open();
        }
        this.storageManager.addBytesToLargeMessage(this.file, this.getMessageID(), bytes);
        this.bodySize += (long)bytes.length;
    }

    public synchronized void addBytes(ActiveMQBuffer bytes) throws Exception {
        this.validateFile();
        if (!this.file.isOpen()) {
            this.file.open();
        }
        int readableBytes = bytes.readableBytes();
        this.storageManager.addBytesToLargeMessage(this.file, this.getMessageID(), bytes);
        this.bodySize += (long)readableBytes;
    }

    public synchronized void validateFile() throws ActiveMQException {
        this.ensureFileExists(true);
    }

    public synchronized void ensureFileExists(boolean toOpen) throws ActiveMQException {
        try {
            if (this.file == null) {
                if (this.getMessageID() <= 0L) {
                    throw new RuntimeException("MessageID not set on LargeMessage");
                }
                this.file = this.createFile();
                if (toOpen) {
                    this.openFile();
                }
                this.bodySize = this.file.size();
            }
        }
        catch (Exception e) {
            throw new ActiveMQInternalErrorException(e.getMessage(), e);
        }
    }

    public long getStoredBodySize() {
        return this.bodySize;
    }

    public void setBodySize(long size) {
        this.bodySize = size;
    }

    public long getBodySize() throws ActiveMQException {
        try {
            if (this.bodySize <= 0L) {
                if (this.file != null) {
                    this.bodySize = this.file.size();
                } else {
                    SequentialFile tmpFile = this.createFile();
                    this.bodySize = tmpFile.size();
                    tmpFile.close(false, false);
                }
            }
            return this.bodySize;
        }
        catch (Exception e) {
            ActiveMQIOErrorException errorException = new ActiveMQIOErrorException();
            errorException.initCause((Throwable)e);
            throw errorException;
        }
    }

    public LargeBodyReader getLargeBodyReader() {
        return new LargeBodyReaderImpl();
    }

    public SequentialFile getReadingFile() throws ActiveMQException {
        this.ensureFileExists(false);
        return this.file.cloneFile();
    }

    public void replaceFile(SequentialFile file) {
        this.file = file;
    }

    public SequentialFile getAppendFile() throws ActiveMQException {
        this.validateFile();
        return this.file;
    }

    public void checkDelete() {
        if (this.message.toMessage().getRefCount() <= 0 && this.message.toMessage().getUsage() <= 0 && this.message.toMessage().getDurableCount() <= 0) {
            if (logger.isTraceEnabled()) {
                try {
                    logger.trace((Object)("Deleting file " + this.getAppendFile() + " as the usage was complete"));
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.deleteFile();
        }
    }

    public void referenceOriginalMessage(LargeBody original) {
        if (original.isPaged()) {
            this.setPaged();
        }
        if (this.paged) {
            this.message.toMessage().removeAnnotation(Message.HDR_ORIG_MESSAGE_ID);
        }
    }

    public ActiveMQBuffer getReadOnlyBodyBuffer() {
        try {
            this.validateFile();
            this.file.open();
            int fileSize = (int)this.file.size();
            ByteBuffer buffer = ByteBuffer.allocate(fileSize);
            this.file.read(buffer);
            ChannelBufferWrapper channelBufferWrapper = new ChannelBufferWrapper(Unpooled.wrappedBuffer((ByteBuffer)buffer));
            return channelBufferWrapper;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.file.close(false, false);
            }
            catch (Exception exception) {}
        }
    }

    public int getBodyBufferSize() {
        boolean closeFile = this.file == null || !this.file.isOpen();
        try {
            this.openFile();
            long fileSize = this.file.size();
            int fileSizeAsInt = (int)fileSize;
            if (fileSizeAsInt < 0) {
                logger.warnf("suspicious large message file size of %d bytes for %s, will use %d instead.", (Object)fileSize, (Object)this.file.getFileName(), (Object)Integer.MAX_VALUE);
                fileSizeAsInt = Integer.MAX_VALUE;
            }
            int n = fileSizeAsInt;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (closeFile) {
                try {
                    this.file.close(false, false);
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void releaseResources(boolean sync, boolean sendEvent) {
        if (this.file != null && this.file.isOpen()) {
            try {
                if (sync) {
                    this.file.sync();
                }
                this.file.close(false, false);
                if (sendEvent) {
                    this.storageManager.largeMessageClosed(this.message);
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.largeMessageErrorReleasingResources(e);
            }
        }
    }

    public void copyInto(LargeServerMessage newMessage) throws Exception {
        this.copyInto(newMessage, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(LargeServerMessage newMessage, ByteBuf newHeader, int skipBytes) throws Exception {
        try (SequentialFile cloneFile = this.getReadingFile();){
            int bytesRead;
            byte[] bufferBytes = new byte[102400];
            ByteBuffer buffer = ByteBuffer.wrap(bufferBytes);
            if (!cloneFile.isOpen()) {
                cloneFile.open();
            }
            cloneFile.position((long)skipBytes);
            if (newHeader != null) {
                newMessage.addBytes((ActiveMQBuffer)new ChannelBufferWrapper(newHeader), true);
            }
            do {
                byte[] bufferToWrite;
                buffer.clear();
                bytesRead = cloneFile.read(buffer);
                if (bytesRead <= 0) {
                    break;
                }
                if (bytesRead == bufferBytes.length && this.storageManager instanceof JournalStorageManager && !((JournalStorageManager)this.storageManager).isReplicated()) {
                    bufferToWrite = bufferBytes;
                } else {
                    bufferToWrite = new byte[bytesRead];
                    System.arraycopy(bufferBytes, 0, bufferToWrite, 0, bytesRead);
                }
                newMessage.addBytes(bufferToWrite);
            } while (bytesRead >= bufferBytes.length);
        }
    }

    public SequentialFile createFile() {
        return this.storageManager.createFileForLargeMessage(this.getMessageID(), this.message.toMessage().isDurable());
    }

    protected void openFile() throws Exception {
        if (this.file == null) {
            this.validateFile();
        } else if (!this.file.isOpen()) {
            this.file.open();
        }
    }

    public boolean hasPendingRecord() {
        return this.pendingRecordID != this.NO_PENDING_ID;
    }

    public void clearPendingRecordID() {
        this.setPendingRecordID(this.NO_PENDING_ID);
    }

    public long getPendingRecordID() {
        return this.pendingRecordID;
    }

    public void setPendingRecordID(long pendingRecordID) {
        this.pendingRecordID = pendingRecordID;
    }

    class LargeBodyReaderImpl
    implements LargeBodyReader {
        private SequentialFile cFile;

        LargeBodyReaderImpl() {
        }

        public void open() throws ActiveMQException {
            try {
                if (this.cFile != null && this.cFile.isOpen()) {
                    this.cFile.close(false, false);
                }
                this.cFile = LargeBody.this.getReadingFile();
                this.cFile.open();
            }
            catch (Exception e) {
                throw new ActiveMQException(ActiveMQExceptionType.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
            }
        }

        public void position(long position) throws ActiveMQException {
            try {
                this.cFile.position(position);
            }
            catch (Exception e) {
                throw new ActiveMQException(ActiveMQExceptionType.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
            }
        }

        public long position() {
            return this.cFile.position();
        }

        public void close() throws ActiveMQException {
            try {
                if (this.cFile != null) {
                    this.cFile.close(false, false);
                    this.cFile = null;
                }
            }
            catch (Exception e) {
                throw new ActiveMQInternalErrorException(e.getMessage(), e);
            }
        }

        public int readInto(ByteBuffer bufferRead) throws ActiveMQException {
            try {
                return this.cFile.read(bufferRead);
            }
            catch (Exception e) {
                throw new ActiveMQInternalErrorException(e.getMessage(), e);
            }
        }

        public long getSize() throws ActiveMQException {
            return LargeBody.this.getBodySize();
        }
    }
}

