/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.security.BouncyIntegration;
import org.jboss.resteasy.security.smime.PKCS7SignatureWriter;
import org.jboss.resteasy.security.smime.SignedOutput;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.WriterException;

@Provider
@Produces(value={"text/plain"})
public class PKCS7SignatureTextWriter
implements AsyncMessageBodyWriter<SignedOutput> {
    @Context
    protected Providers providers;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return SignedOutput.class.isAssignableFrom(type);
    }

    public long getSize(SignedOutput smimeOutput, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(SignedOutput out, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        try {
            byte[] encoded = PKCS7SignatureWriter.sign(this.providers, out);
            os.write(Base64.getEncoder().encodeToString(encoded).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new WriterException((Throwable)e);
        }
    }

    public CompletionStage<Void> asyncWriteTo(SignedOutput out, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        try {
            byte[] encoded = PKCS7SignatureWriter.sign(this.providers, out);
            return entityStream.asyncWrite(Base64.getEncoder().encodeToString(encoded).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return ProviderHelper.completedException((Throwable)new WriterException((Throwable)e));
        }
    }

    static {
        BouncyIntegration.init();
    }
}

