/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import io.undertow.websockets.core.WebSocketChannel;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSession
implements io.undertow.server.session.Session {
    private static final Set<String> AUTO_REAUTHENTICATING_MECHANISMS = new HashSet<String>(Arrays.asList("BASIC", "DIGEST", "CLIENT_CERT"));
    static final String WEB_SOCKET_CHANNELS_ATTRIBUTE = "io.undertow.websocket.current-connections";
    private final UndertowSessionManager manager;
    private final Batch batch;
    private final Consumer<HttpServerExchange> closeTask;
    private final Instant startTime;
    private volatile Map.Entry<Session<LocalSessionContext>, SessionConfig> entry;

    public DistributableSession(UndertowSessionManager manager, Session<LocalSessionContext> session, SessionConfig config, Batch batch, Consumer<HttpServerExchange> closeTask) {
        this.manager = manager;
        this.entry = new AbstractMap.SimpleImmutableEntry<Session<LocalSessionContext>, SessionConfig>(session, config);
        this.batch = batch;
        this.closeTask = closeTask;
        this.startTime = !session.getMetaData().isNew() ? Instant.now() : null;
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDone(HttpServerExchange exchange) {
        block44: {
            try {
                Session<LocalSessionContext> session = this.entry.getKey();
                if (session.isValid()) {
                    Batcher batcher = this.manager.getSessionManager().getBatcher();
                    try (BatchContext context = batcher.resumeBatch(this.batch);){
                        if (this.batch.getState() == Batch.State.DISCARDED) {
                            this.batch.close();
                        }
                        try (Batch batch = this.batch.getState() == Batch.State.CLOSED ? batcher.createBatch() : this.batch;){
                            if (this.startTime != null) {
                                session.getMetaData().setLastAccess(this.startTime, Instant.now());
                            }
                            session.close();
                            break block44;
                        }
                    }
                    catch (Throwable e) {
                        UndertowClusteringLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                    }
                    break block44;
                }
                if (this.batch.getState() == Batch.State.CLOSED) break block44;
                Batcher batcher = this.manager.getSessionManager().getBatcher();
                try (BatchContext context = batcher.resumeBatch(this.batch);){
                    this.batch.close();
                }
            }
            finally {
                this.closeTask.accept(exchange);
            }
        }
    }

    public String getId() {
        return this.entry.getKey().getId();
    }

    public long getCreationTime() {
        Session<LocalSessionContext> session = this.entry.getKey();
        this.validate(session);
        try (BatchContext context = this.resumeBatch();){
            long l = session.getMetaData().getCreationTime().toEpochMilli();
            return l;
        }
    }

    public long getLastAccessedTime() {
        Session<LocalSessionContext> session = this.entry.getKey();
        this.validate(session);
        try (BatchContext context = this.resumeBatch();){
            long l = session.getMetaData().getLastAccessStartTime().toEpochMilli();
            return l;
        }
    }

    public int getMaxInactiveInterval() {
        Session<LocalSessionContext> session = this.entry.getKey();
        this.validate(session);
        try (BatchContext context = this.resumeBatch();){
            int n = (int)session.getMetaData().getMaxInactiveInterval().getSeconds();
            return n;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        Session<LocalSessionContext> session = this.entry.getKey();
        this.validate(session);
        try (BatchContext context = this.resumeBatch();){
            session.getMetaData().setMaxInactiveInterval(Duration.ofSeconds(interval));
        }
    }

    public Set<String> getAttributeNames() {
        Session<LocalSessionContext> session = this.entry.getKey();
        this.validate(session);
        try (BatchContext context = this.resumeBatch();){
            Set set = session.getAttributes().getAttributeNames();
            return set;
        }
    }

    public Object getAttribute(String name) {
        Session<LocalSessionContext> session = this.entry.getKey();
        this.validate(session);
        try (BatchContext context = this.resumeBatch();){
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().getAttribute(name);
                AuthenticatedSessionManager.AuthenticatedSession authenticatedSession = auth != null ? auth : ((LocalSessionContext)session.getLocalContext()).getAuthenticatedSession();
                return authenticatedSession;
            }
            if (WEB_SOCKET_CHANNELS_ATTRIBUTE.equals(name)) {
                List<WebSocketChannel> list = ((LocalSessionContext)session.getLocalContext()).getWebSocketChannels();
                return list;
            }
            Object object = session.getAttributes().getAttribute(name);
            return object;
        }
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        Session<LocalSessionContext> session = this.entry.getKey();
        this.validate(session);
        try (BatchContext context = this.resumeBatch();){
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)value;
                AuthenticatedSessionManager.AuthenticatedSession authenticatedSession = AUTO_REAUTHENTICATING_MECHANISMS.contains(auth.getMechanism()) ? this.setAuthenticatedSession(auth) : session.getAttributes().setAttribute(name, (Object)auth);
                return authenticatedSession;
            }
            if (WEB_SOCKET_CHANNELS_ATTRIBUTE.equals(name)) {
                List channels = (List)value;
                List<WebSocketChannel> list = this.setWebSocketChannels(channels);
                return list;
            }
            Object old = session.getAttributes().setAttribute(name, value);
            if (old == null) {
                this.manager.getSessionListeners().attributeAdded((io.undertow.server.session.Session)this, name, value);
            } else if (old != value) {
                this.manager.getSessionListeners().attributeUpdated((io.undertow.server.session.Session)this, name, value, old);
            }
            Object object = old;
            return object;
        }
    }

    public Object removeAttribute(String name) {
        Session<LocalSessionContext> session = this.entry.getKey();
        this.validate(session);
        try (BatchContext context = this.resumeBatch();){
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().removeAttribute(name);
                AuthenticatedSessionManager.AuthenticatedSession authenticatedSession = auth != null ? auth : this.setAuthenticatedSession(null);
                return authenticatedSession;
            }
            if (WEB_SOCKET_CHANNELS_ATTRIBUTE.equals(name)) {
                List<WebSocketChannel> auth = this.setWebSocketChannels(null);
                return auth;
            }
            Object old = session.getAttributes().removeAttribute(name);
            if (old != null) {
                this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, old);
            }
            Object object = old;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(HttpServerExchange exchange) {
        Map.Entry<Session<LocalSessionContext>, SessionConfig> entry = this.entry;
        Session<LocalSessionContext> session = entry.getKey();
        this.validate(exchange, session);
        this.validateBatch(session);
        this.manager.getSessionListeners().sessionDestroyed((io.undertow.server.session.Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
        try (BatchContext context = this.resumeBatch();){
            SessionAttributes attributes = session.getAttributes();
            for (String name : attributes.getAttributeNames()) {
                Object value = attributes.getAttribute(name);
                this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, value);
            }
            session.invalidate();
            if (exchange != null) {
                String id = session.getId();
                entry.getValue().clearSession(exchange, id);
            }
            this.batch.close();
        }
        finally {
            this.closeTask.accept(exchange);
        }
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        Session<LocalSessionContext> oldSession = this.entry.getKey();
        this.validate(exchange, oldSession);
        org.wildfly.clustering.web.session.SessionManager<LocalSessionContext, Batch> manager = this.manager.getSessionManager();
        String id = (String)manager.createIdentifier();
        try (BatchContext context = this.resumeBatch();){
            Session newSession = manager.createSession(id);
            for (String name : oldSession.getAttributes().getAttributeNames()) {
                newSession.getAttributes().setAttribute(name, oldSession.getAttributes().getAttribute(name));
            }
            newSession.getMetaData().setMaxInactiveInterval(oldSession.getMetaData().getMaxInactiveInterval());
            newSession.getMetaData().setLastAccess(oldSession.getMetaData().getLastAccessStartTime(), oldSession.getMetaData().getLastAccessEndTime());
            ((LocalSessionContext)newSession.getLocalContext()).setAuthenticatedSession(((LocalSessionContext)oldSession.getLocalContext()).getAuthenticatedSession());
            config.setSessionId(exchange, id);
            this.entry = new AbstractMap.SimpleImmutableEntry<Session, SessionConfig>(newSession, config);
            oldSession.invalidate();
        }
        this.manager.getSessionListeners().sessionIdChanged((io.undertow.server.session.Session)this, oldSession.getId());
        return id;
    }

    private AuthenticatedSessionManager.AuthenticatedSession setAuthenticatedSession(AuthenticatedSessionManager.AuthenticatedSession auth) {
        LocalSessionContext localContext = (LocalSessionContext)this.entry.getKey().getLocalContext();
        AuthenticatedSessionManager.AuthenticatedSession old = localContext.getAuthenticatedSession();
        localContext.setAuthenticatedSession(auth);
        return old;
    }

    private List<WebSocketChannel> setWebSocketChannels(List<WebSocketChannel> channels) {
        LocalSessionContext localContext = (LocalSessionContext)this.entry.getKey().getLocalContext();
        List<WebSocketChannel> old = localContext.getWebSocketChannels();
        localContext.setWebSocketChannels(channels);
        return old;
    }

    private void validate(Session<LocalSessionContext> session) {
        this.validate(null, session);
    }

    private void validate(HttpServerExchange exchange, Session<LocalSessionContext> session) {
        if (!session.isValid()) {
            this.closeTask.accept(exchange);
            throw UndertowClusteringLogger.ROOT_LOGGER.sessionIsInvalid(session.getId());
        }
    }

    private void validateBatch(Session<LocalSessionContext> session) {
        if (this.batch.getState() == Batch.State.CLOSED) {
            throw UndertowClusteringLogger.ROOT_LOGGER.batchIsAlreadyClosed(session.getId());
        }
    }

    private BatchContext resumeBatch() {
        Batch batch = this.batch.getState() != Batch.State.CLOSED ? this.batch : null;
        return this.manager.getSessionManager().getBatcher().resumeBatch(batch);
    }
}

