/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.infinispan.commons.stat.DefaultSimpleStat;
import org.infinispan.commons.stat.SimpleStat;
import org.infinispan.commons.time.TimeService;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;

public class ActionSequencer {
    private static final StatCollector NO_STATS = new StatCollector();
    private final Map<Object, SequenceEntry<?>> sequencer = new ConcurrentHashMap();
    private final LongAdder pendingActions = new LongAdder();
    private final LongAdder runningActions = new LongAdder();
    private final TimeService timeService;
    private final Executor executor;
    private final boolean forceExecutor;
    private volatile SimpleStat queueTimes = new DefaultSimpleStat();
    private volatile SimpleStat runningTimes = new DefaultSimpleStat();
    private volatile boolean collectStats;

    public ActionSequencer(Executor executor, boolean forceExecutor, TimeService timeService) {
        this.executor = executor;
        this.forceExecutor = forceExecutor;
        this.timeService = timeService;
    }

    private static <T> CompletionStage<T> safeNonBlockingCall(Callable<? extends CompletionStage<T>> action) {
        try {
            return action.call();
        }
        catch (Exception e) {
            return CompletableFutures.completedExceptionFuture(e);
        }
    }

    public <T> CompletionStage<T> orderOnKeys(Collection<?> keys, Callable<? extends CompletionStage<T>> action) {
        this.checkAction(action);
        Object[] dKeys = this.checkKeys(keys);
        if (dKeys.length == 0) {
            return ActionSequencer.safeNonBlockingCall(action);
        }
        StatCollector statCollector = this.newStatCollector();
        SequenceEntry entry = dKeys.length == 1 ? new SingleKeyNonBlockingSequenceEntry(action, dKeys[0], statCollector) : new MultiKeyNonBlockingSequenceEntry(action, dKeys, statCollector);
        this.registerAction(entry);
        return entry;
    }

    public <T> CompletionStage<T> orderOnKey(Object key, Callable<? extends CompletionStage<T>> action) {
        this.checkAction(action);
        StatCollector statCollector = this.newStatCollector();
        SingleKeyNonBlockingSequenceEntry entry = new SingleKeyNonBlockingSequenceEntry(action, this.checkKey(key), statCollector);
        this.registerAction(entry);
        return entry;
    }

    public long getPendingActions() {
        return this.pendingActions.longValue();
    }

    public long getRunningActions() {
        return this.runningActions.longValue();
    }

    public void resetStatistics() {
        this.runningTimes = new DefaultSimpleStat();
        this.queueTimes = new DefaultSimpleStat();
    }

    public long getAverageQueueTimeNanos() {
        return this.queueTimes.getAverage(-1L);
    }

    public long getAverageRunningTimeNanos() {
        return this.runningTimes.getAverage(-1L);
    }

    public void setStatisticEnabled(boolean enable) {
        this.collectStats = enable;
        if (!enable) {
            this.resetStatistics();
        }
    }

    public int getMapSize() {
        return this.sequencer.size();
    }

    private <T> void registerAction(SequenceEntry<T> entry) {
        entry.register();
    }

    private void checkAction(Callable<?> action) {
        Objects.requireNonNull(action, "Action cannot be null.");
    }

    private Object[] checkKeys(Collection<?> keys) {
        return Objects.requireNonNull(keys, "Keys cannot be null.").stream().filter(Objects::nonNull).distinct().toArray();
    }

    private Object checkKey(Object key) {
        return Objects.requireNonNull(key, "Key cannot be null.");
    }

    private void remove(Object key, SequenceEntry<?> entry) {
        this.sequencer.remove(key, entry);
    }

    private void remove(Object[] keys, SequenceEntry<?> entry) {
        for (Object key : keys) {
            this.sequencer.remove(key, entry);
        }
    }

    private StatCollector newStatCollector() {
        return this.collectStats ? new StatEnabledCollector() : NO_STATS;
    }

    private class StatEnabledCollector
    extends StatCollector {
        private volatile long createdTimestamp;
        private volatile long startedTimestamp;

        private StatEnabledCollector() {
            this.createdTimestamp = -1L;
            this.startedTimestamp = -1L;
        }

        @Override
        void taskCreated() {
            ActionSequencer.this.pendingActions.increment();
            this.createdTimestamp = ActionSequencer.this.timeService.time();
        }

        @Override
        void taskStarted() {
            ActionSequencer.this.runningActions.increment();
            this.startedTimestamp = ActionSequencer.this.timeService.time();
        }

        @Override
        void taskFinished() {
            ActionSequencer.this.runningActions.decrement();
            ActionSequencer.this.pendingActions.decrement();
            long endTimestamp = ActionSequencer.this.timeService.time();
            ActionSequencer.this.queueTimes.record(this.startedTimestamp - this.createdTimestamp);
            ActionSequencer.this.runningTimes.record(endTimestamp - this.startedTimestamp);
        }
    }

    private class MultiKeyNonBlockingSequenceEntry<T>
    extends SequenceEntry<T> {
        private final Object[] keys;

        MultiKeyNonBlockingSequenceEntry(Callable<? extends CompletionStage<T>> action, Object[] keys, StatCollector statCollector) {
            super(action, statCollector);
            this.keys = keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletionStage<?> putInMap() {
            AggregateCompletionStage<Void> previousCF = CompletionStages.aggregateCompletionStage();
            ActionSequencer actionSequencer = ActionSequencer.this;
            synchronized (actionSequencer) {
                BiFunction<Object, SequenceEntry, SequenceEntry> mapping = (key, previousEntry) -> this.waitFromPrevious((SequenceEntry<?>)previousEntry, previousCF);
                for (Object key2 : this.keys) {
                    ActionSequencer.this.sequencer.compute(key2, mapping);
                }
            }
            return previousCF.freeze();
        }

        @Override
        void removeFromMap() {
            ActionSequencer.this.remove(this.keys, this);
        }

        SequenceEntry<?> waitFromPrevious(SequenceEntry<?> previousEntry, AggregateCompletionStage<?> previousCF) {
            if (previousEntry != null) {
                previousCF.dependsOn(previousEntry);
            }
            return this;
        }
    }

    private class SingleKeyNonBlockingSequenceEntry<T>
    extends SequenceEntry<T> {
        private final Object key;

        SingleKeyNonBlockingSequenceEntry(Callable<? extends CompletionStage<T>> action, Object key, StatCollector statCollector) {
            super(action, statCollector);
            this.key = key;
        }

        @Override
        public CompletionStage<?> putInMap() {
            return ActionSequencer.this.sequencer.put(this.key, this);
        }

        @Override
        public void removeFromMap() {
            ActionSequencer.this.remove(this.key, this);
        }
    }

    private abstract class SequenceEntry<T>
    extends CompletableFuture<T>
    implements BiFunction<Object, Throwable, Void>,
    BiConsumer<T, Throwable>,
    Runnable {
        final Callable<? extends CompletionStage<T>> action;
        final StatCollector statCollector;

        SequenceEntry(Callable<? extends CompletionStage<T>> action, StatCollector statCollector) {
            this.action = action;
            this.statCollector = statCollector;
        }

        public void register() {
            this.statCollector.taskCreated();
            CompletionStage<?> previousStage = this.putInMap();
            if (previousStage != null) {
                previousStage.handleAsync(this, ActionSequencer.this.executor);
            } else if (ActionSequencer.this.forceExecutor) {
                ActionSequencer.this.executor.execute(this);
            } else {
                this.run();
            }
        }

        @Override
        public final void accept(T o, Throwable throwable) {
            this.removeFromMap();
            this.statCollector.taskFinished();
            if (throwable == null) {
                this.complete(o);
            } else {
                this.completeExceptionally(throwable);
            }
        }

        @Override
        public final Void apply(Object o, Throwable t) {
            this.run();
            return null;
        }

        @Override
        public final void run() {
            this.statCollector.taskStarted();
            CompletionStage cf = ActionSequencer.safeNonBlockingCall(this.action);
            cf.whenComplete(this);
        }

        abstract CompletionStage<?> putInMap();

        abstract void removeFromMap();
    }

    private static class StatCollector {
        private StatCollector() {
        }

        void taskCreated() {
        }

        void taskStarted() {
        }

        void taskFinished() {
        }
    }
}

