/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.Principal;

public final class CachePrincipalPair {
    private final String principalName;
    private final String cacheName;
    private final int hashCode;

    CachePrincipalPair(Principal userPrincipal, String cacheName) {
        this.principalName = userPrincipal.getName();
        this.cacheName = cacheName;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        result = 31 * result + (this.principalName == null ? 0 : this.principalName.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachePrincipalPair other = (CachePrincipalPair)obj;
        if (!this.cacheName.equals(other.cacheName)) {
            return false;
        }
        return this.principalName.equals(other.principalName);
    }

    public String toString() {
        return "CachePrincipalPair{cacheName=" + this.cacheName + ", principalName=" + this.principalName + '}';
    }
}

