/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.FunctionalCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.TxReadOnlyKeyCommand;
import org.infinispan.commands.functional.TxReadOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.ExceptionSyncInvocationStage;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.remoting.responses.Response;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class EntryWrappingInterceptor
extends DDAsyncInterceptor {
    @Inject
    EntryFactory entryFactory;
    @Inject
    InternalDataContainer<Object, Object> dataContainer;
    @Inject
    protected ClusteringDependentLogic cdl;
    @Inject
    VersionGenerator versionGenerator;
    @Inject
    protected DistributionManager distributionManager;
    @Inject
    ComponentRef<StateConsumer> stateConsumer;
    @Inject
    StateTransferLock stateTransferLock;
    @Inject
    ComponentRef<XSiteStateConsumer> xSiteStateConsumer;
    @Inject
    GroupManager groupManager;
    @Inject
    CacheNotifier<Object, Object> notifier;
    @Inject
    KeyPartitioner keyPartitioner;
    private final EntryWrappingVisitor entryWrappingVisitor = new EntryWrappingVisitor();
    private boolean isInvalidation;
    private boolean isSync;
    private boolean useRepeatableRead;
    private boolean isVersioned;
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final long EVICT_FLAGS_BITSET = FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.CACHE_MODE_LOCAL;
    private final InvocationSuccessFunction<AbstractDataCommand> dataReadReturnHandler = (rCtx, dataCommand, rv) -> {
        if (rCtx.isInTxScope() && this.useRepeatableRead) {
            this.addVersionRead(rCtx, (AbstractDataCommand)dataCommand);
        }
        if (rv != null && !(rv instanceof Response)) {
            Object value = dataCommand instanceof GetCacheEntryCommand ? ((CacheEntry)rv).getValue() : rv;
            CompletionStage<Void> stage = this.notifier.notifyCacheEntryVisited(dataCommand.getKey(), value, true, rCtx, (FlagAffectedCommand)dataCommand);
            stage = CompletionStages.isCompletedSuccessfully(stage) ? this.notifier.notifyCacheEntryVisited(dataCommand.getKey(), value, false, rCtx, (FlagAffectedCommand)dataCommand) : stage.thenCompose(v -> this.notifier.notifyCacheEntryVisited(dataCommand.getKey(), value, false, rCtx, (FlagAffectedCommand)dataCommand));
            return EntryWrappingInterceptor.delayedValue(stage, rv);
        }
        return rv;
    };
    private final InvocationSuccessFunction<VisitableCommand> commitEntriesSuccessHandler = (rCtx, rCommand, rv) -> EntryWrappingInterceptor.delayedValue(this.commitContextEntries(rCtx, null), rv);
    private final InvocationFinallyFunction<CommitCommand> commitEntriesFinallyHandler = this::commitEntriesFinally;
    private final InvocationSuccessFunction<PrepareCommand> prepareHandler = this::prepareHandler;
    private final InvocationSuccessFunction<DataWriteCommand> applyAndFixVersion = this::applyAndFixVersion;
    private final InvocationSuccessFunction<WriteCommand> applyAndFixVersionForMany = this::applyAndFixVersionForMany;
    private final InvocationFinallyFunction<GetAllCommand> getAllHandleFunction = this::getAllHandle;

    private void addVersionRead(InvocationContext rCtx, AbstractDataCommand dataCommand) {
        CacheEntry cacheEntry = rCtx.lookupEntry(dataCommand.getKey());
        cacheEntry.setSkipLookup(true);
        if (this.isVersioned && ((MVCCEntry)cacheEntry).isRead()) {
            this.addVersionRead((TxInvocationContext)rCtx, cacheEntry, dataCommand.getKey());
        }
    }

    @Start
    public void start() {
        this.isInvalidation = this.cacheConfiguration.clustering().cacheMode().isInvalidation();
        this.isSync = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
        this.useRepeatableRead = this.cacheConfiguration.transaction().transactionMode().isTransactional() && this.cacheConfiguration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ || this.cacheConfiguration.clustering().cacheMode().isScattered();
        this.isVersioned = Configurations.isTxVersioned(this.cacheConfiguration);
    }

    private boolean ignoreOwnership(FlagAffectedCommand command) {
        return this.distributionManager == null || command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK);
    }

    protected boolean canRead(DataCommand command) {
        return this.distributionManager.getCacheTopology().isSegmentReadOwner(command.getSegment());
    }

    protected boolean canReadKey(Object key) {
        return this.distributionManager.getCacheTopology().isReadOwner(key);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.wrapEntriesForPrepareAndApply(ctx, command, this.prepareHandler);
    }

    private Object prepareHandler(InvocationContext ctx, PrepareCommand command, Object rv) {
        if (command.isOnePhaseCommit()) {
            return this.invokeNextThenApply(ctx, command, this.commitEntriesSuccessHandler);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNextAndHandle(ctx, command, this.commitEntriesFinallyHandler);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    private Object visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) {
        Object key = command.getKey();
        CompletionStage<Void> stage = this.entryFactory.wrapEntryForReading(ctx, key, command.getSegment(), this.ignoreOwnership(command) || this.canRead(command));
        return EntryWrappingInterceptor.makeStage(this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, command, this.dataReadReturnHandler);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (Object key : command.getKeys()) {
            CompletionStage<Void> stage = this.entryFactory.wrapEntryForReading(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key));
            aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
        }
        return EntryWrappingInterceptor.makeStage(this.asyncInvokeNext(ctx, (VisitableCommand)command, this.aggregatedStageOrCompleted(aggregateCompletionStage))).andHandle(ctx, command, this.getAllHandleFunction);
    }

    private Object getAllHandle(InvocationContext rCtx, GetAllCommand command, Object rv, Throwable t) {
        if (this.useRepeatableRead) {
            for (Object key : command.getKeys()) {
                CacheEntry cacheEntry = rCtx.lookupEntry(key);
                if (cacheEntry == null) {
                    if (!trace) continue;
                    log.tracef(t, "Missing entry for " + key, new Object[0]);
                    continue;
                }
                cacheEntry.setSkipLookup(true);
            }
        }
        AggregateCompletionStage<Void> stage = CompletionStages.aggregateCompletionStage();
        if (t == null && rv instanceof Map) {
            boolean notify = !command.hasAnyFlag(FlagBitSets.SKIP_LISTENER_NOTIFICATION) && this.notifier.hasListener(CacheEntryVisited.class);
            log.tracef("Notifying getAll? %s; result %s", notify, rv);
            if (notify) {
                Map map = (Map)rv;
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null) continue;
                    Object finalValue = command.isReturnEntries() ? ((CacheEntry)value).getValue() : entry.getValue();
                    CompletionStage<Void> innerStage = this.notifier.notifyCacheEntryVisited(entry.getKey(), finalValue, true, rCtx, command);
                    stage.dependsOn(innerStage.thenCompose(ig -> this.notifier.notifyCacheEntryVisited(entry.getKey(), finalValue, false, rCtx, command)));
                }
            }
        }
        return EntryWrappingInterceptor.delayedValue(stage.freeze(), rv, t);
    }

    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        if (command.getKeys() != null) {
            for (Object key : command.getKeys()) {
                CompletionStage<Void> stage = this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), true, false);
                aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
            }
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command, this.aggregatedStageOrCompleted(aggregateCompletionStage));
    }

    private CompletionStage<Void> aggregatedStageOrCompleted(AggregateCompletionStage<Void> aggregateCompletionStage) {
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    private AggregateCompletionStage<Void> accumulateStage(CompletionStage<Void> stage, AggregateCompletionStage<Void> current) {
        if (!CompletionStages.isCompletedSuccessfully(stage)) {
            if (current == null) {
                current = CompletionStages.aggregateCompletionStage();
            }
            current.dependsOn(stage);
        }
        return current;
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (this.stateConsumer.running() != null) {
                this.stateConsumer.running().stopApplyingState(rCommand.getTopologyId());
            }
            if (this.xSiteStateConsumer.running() != null) {
                this.xSiteStateConsumer.running().endStateTransfer(null);
            }
            CompletionStage<Void> stage = null;
            if (!rCtx.isInTxScope()) {
                stage = this.applyChanges(rCtx, (WriteCommand)rCommand);
            }
            if (trace) {
                log.tracef("The return value is %s", rv);
            }
            return EntryWrappingInterceptor.delayedValue(stage, rv);
        });
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (Object key : command.getKeys()) {
            CompletionStage<Void> stage = this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), false, false);
            aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
            if (!trace) continue;
            log.tracef("Entry to be removed: %s", Util.toStr((Object)key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command, this.aggregatedStageOrCompleted(aggregateCompletionStage));
    }

    @Override
    public final Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    private CompletionStage<Void> wrapEntryIfNeeded(InvocationContext ctx, AbstractDataWriteCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getKey());
        }
        return this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), command.getSegment(), this.ignoreOwnership(command) || this.canRead(command), command.loadType() != VisitableCommand.LoadType.DONT_LOAD);
    }

    private void removeFromContextOnRetry(InvocationContext ctx, Object key) {
        if (this.useRepeatableRead) {
            MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
            if (trace) {
                log.tracef("This is a retry - resetting previous value in entry %s", entry);
            }
            if (entry != null) {
                entry.resetCurrentValue();
            }
        } else {
            if (trace) {
                log.tracef("This is a retry - removing looked up entry %s", ctx.lookupEntry(key));
            }
            ctx.removeLookedUpEntry(key);
        }
    }

    private void removeFromContextOnRetry(InvocationContext ctx, Collection<?> keys) {
        if (this.useRepeatableRead) {
            if (trace) {
                log.tracef("This is a retry - resetting previous values for %s", keys);
            }
            for (Object key : keys) {
                MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
                if (entry == null) continue;
                entry.resetCurrentValue();
            }
        } else {
            ctx.removeLookedUpEntries(keys);
        }
    }

    @Override
    public final Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    @Override
    public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) throws Throwable {
        this.entryFactory.wrapEntryForExpired(ctx, command.getKey(), command.getSegment());
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, CompletableFutures.completedNull());
    }

    @Override
    public final Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (Object key : command.getMap().keySet()) {
            CompletionStage<Void> stage = this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), command.loadType() != VisitableCommand.LoadType.DONT_LOAD);
            aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command, this.aggregatedStageOrCompleted(aggregateCompletionStage));
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        command.setFlagsBitSet(command.getFlagsBitSet() | EVICT_FLAGS_BITSET);
        return this.visitRemoveCommand(ctx, command);
    }

    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        if (command.isGroupOwner()) {
            this.dataContainer.forEach(internalCacheEntry -> {
                Object key = internalCacheEntry.getKey();
                if (!command.getGroupName().equals(this.groupManager.getGroup(key)) || ctx.lookupEntry(key) != null) {
                    return;
                }
                if (internalCacheEntry.getValue() != null) {
                    InvocationContext invocationContext = ctx;
                    synchronized (invocationContext) {
                        this.entryFactory.wrapExternalEntry(ctx, key, (CacheEntry)internalCacheEntry, true, false);
                    }
                }
            });
        }
        if (ctx.isInTxScope() && this.useRepeatableRead) {
            return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
                TxInvocationContext txCtx = (TxInvocationContext)rCtx;
                rCtx.forEachEntry((key, entry) -> {
                    entry.setSkipLookup(true);
                    if (this.isVersioned && ((MVCCEntry)entry).isRead()) {
                        this.addVersionRead(txCtx, (CacheEntry<?, ?>)entry, key);
                    }
                });
            });
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        CompletionStage<Void> stage = command instanceof TxReadOnlyKeyCommand ? this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), command.getSegment(), this.ignoreOwnership(command) || this.canRead(command), true) : this.entryFactory.wrapEntryForReading(ctx, command.getKey(), command.getSegment(), this.ignoreOwnership(command) || this.canRead(command));
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, stage);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        if (command instanceof TxReadOnlyManyCommand) {
            for (Object key : command.getKeys()) {
                CompletionStage<Void> stage = this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), this.ignoreOwnership(command) || this.canReadKey(key), true);
                aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
            }
        } else {
            for (Object key : command.getKeys()) {
                CompletionStage<Void> stage = this.entryFactory.wrapEntryForReading(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key));
                aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
            }
        }
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.aggregatedStageOrCompleted(aggregateCompletionStage));
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (Object key : command.getArguments().keySet()) {
            CompletionStage<Void> stage = this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), false);
            aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command, this.aggregatedStageOrCompleted(aggregateCompletionStage));
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (Object key : command.getAffectedKeys()) {
            CompletionStage<Void> stage = this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), false);
            aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command, this.aggregatedStageOrCompleted(aggregateCompletionStage));
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, this.wrapEntryIfNeeded(ctx, command));
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (Object key : command.getAffectedKeys()) {
            CompletionStage<Void> stage = this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), true);
            aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command, this.aggregatedStageOrCompleted(aggregateCompletionStage));
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (Object key : command.getAffectedKeys()) {
            CompletionStage<Void> stage = this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), true);
            aggregateCompletionStage = this.accumulateStage(stage, aggregateCompletionStage);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command, this.aggregatedStageOrCompleted(aggregateCompletionStage));
    }

    protected final CompletionStage<Void> commitContextEntries(InvocationContext ctx, FlagAffectedCommand command) {
        Flag stateTransferFlag = FlagBitSets.extractStateTransferFlag(ctx, command);
        if (ctx instanceof SingleKeyNonTxInvocationContext) {
            SingleKeyNonTxInvocationContext singleKeyCtx = (SingleKeyNonTxInvocationContext)ctx;
            return this.commitEntryIfNeeded(ctx, command, singleKeyCtx.getKey(), singleKeyCtx.getCacheEntry(), stateTransferFlag);
        }
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        Map<Object, CacheEntry> entries = ctx.getLookedUpEntries();
        for (Map.Entry<Object, CacheEntry> entry : entries.entrySet()) {
            CompletionStage<Void> stage = this.commitEntryIfNeeded(ctx, command, entry.getKey(), entry.getValue(), stateTransferFlag);
            if (CompletionStages.isCompletedSuccessfully(stage)) continue;
            if (aggregateCompletionStage == null) {
                aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            }
            aggregateCompletionStage.dependsOn(stage);
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    protected CompletionStage<Void> commitContextEntry(CacheEntry<?, ?> entry, InvocationContext ctx, FlagAffectedCommand command, Flag stateTransferFlag, boolean l1Invalidation) {
        return this.cdl.commitEntry(entry, command, ctx, stateTransferFlag, l1Invalidation);
    }

    private void checkTopology(InvocationContext ctx, WriteCommand command) {
        boolean syncRpc;
        boolean bl = syncRpc = this.isSync && !command.hasAnyFlag(FlagBitSets.FORCE_ASYNCHRONOUS) || command.hasAnyFlag(FlagBitSets.FORCE_SYNCHRONOUS);
        if (command.isSuccessful() && this.distributionManager != null) {
            int commandTopologyId = command.getTopologyId();
            int currentTopologyId = this.distributionManager.getCacheTopology().getTopologyId();
            if (syncRpc && currentTopologyId != commandTopologyId && commandTopologyId != -1 && (!ctx.isOriginLocal() || !(command instanceof DataCommand) || ctx.hasLockedKey(((DataCommand)((Object)command)).getKey()))) {
                if (trace) {
                    log.tracef("Cache topology changed while the command was executing: expected %d, got %d", commandTopologyId, currentTopologyId);
                }
                command.setValueMatcher(command.getValueMatcher().matcherForRetry());
                throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> applyChanges(InvocationContext ctx, WriteCommand command) {
        this.stateTransferLock.acquireSharedTopologyLock();
        try {
            if (!this.isInvalidation) {
                this.checkTopology(ctx, command);
            }
            CompletionStage<Void> cs = this.commitContextEntries(ctx, command);
            if (!this.isInvalidation && !CompletionStages.isCompletedSuccessfully(cs)) {
                CompletionStage<Void> completionStage = cs.thenRun(() -> this.checkTopology(ctx, command));
                return completionStage;
            }
            CompletionStage<Void> completionStage = cs;
            return completionStage;
        }
        finally {
            this.stateTransferLock.releaseSharedTopologyLock();
        }
    }

    protected Object setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(InvocationContext ctx, WriteCommand command, CompletionStage<Void> delay) {
        return EntryWrappingInterceptor.makeStage(this.asyncInvokeNext(ctx, (VisitableCommand)command, delay)).thenApply(ctx, command, this.applyAndFixVersionForMany);
    }

    private Object applyAndFixVersionForMany(InvocationContext ctx, WriteCommand writeCommand, Object rv) {
        if (!ctx.isInTxScope()) {
            return EntryWrappingInterceptor.delayedValue(this.applyChanges(ctx, writeCommand), rv);
        }
        if (trace) {
            log.tracef("The return value is %s", Util.toStr((Object)rv));
        }
        if (this.useRepeatableRead) {
            boolean addVersionRead = this.isVersioned && writeCommand.loadType() != VisitableCommand.LoadType.DONT_LOAD;
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            for (Object key : writeCommand.getAffectedKeys()) {
                CacheEntry cacheEntry = ctx.lookupEntry(key);
                if (cacheEntry == null) continue;
                cacheEntry.setSkipLookup(true);
                if (addVersionRead && ((MVCCEntry)cacheEntry).isRead()) {
                    this.addVersionRead(txCtx, cacheEntry, key);
                }
                ((MVCCEntry)cacheEntry).updatePreviousValue();
            }
        }
        return rv;
    }

    private void addVersionRead(TxInvocationContext<?> rCtx, CacheEntry<?, ?> cacheEntry, Object key) {
        IncrementableEntryVersion version = WriteSkewHelper.versionFromEntry(cacheEntry);
        if (version == null) {
            version = this.versionGenerator.nonExistingVersion();
            if (trace) {
                log.tracef("Adding non-existent version read for key %s", key);
            }
        } else if (trace) {
            log.tracef("Adding version read %s for key %s", version, key);
        }
        ((AbstractCacheTransaction)rCtx.getCacheTransaction()).addVersionRead(key, version);
    }

    protected Object setSkipRemoteGetsAndInvokeNextForDataCommand(InvocationContext ctx, DataWriteCommand command, CompletionStage<Void> delay) {
        return EntryWrappingInterceptor.makeStage(this.asyncInvokeNext(ctx, (VisitableCommand)command, delay)).thenApply(ctx, command, this.applyAndFixVersion);
    }

    private Object applyAndFixVersion(InvocationContext ctx, DataWriteCommand dataWriteCommand, Object rv) {
        CacheEntry cacheEntry;
        if (!ctx.isInTxScope()) {
            return EntryWrappingInterceptor.delayedValue(this.applyChanges(ctx, dataWriteCommand), rv);
        }
        if (trace) {
            log.tracef("The return value is %s", rv);
        }
        if (this.useRepeatableRead && (cacheEntry = ctx.lookupEntry(dataWriteCommand.getKey())) != null) {
            cacheEntry.setSkipLookup(true);
            if (this.isVersioned && dataWriteCommand.loadType() != VisitableCommand.LoadType.DONT_LOAD && ((MVCCEntry)cacheEntry).isRead()) {
                this.addVersionRead((TxInvocationContext)ctx, cacheEntry, dataWriteCommand.getKey());
            }
            ((MVCCEntry)cacheEntry).updatePreviousValue();
        }
        return rv;
    }

    private Object commitEntriesFinally(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) {
        if (t instanceof OutdatedTopologyException) {
            return new ExceptionSyncInvocationStage(t);
        }
        return EntryWrappingInterceptor.delayedValue(this.commitContextEntries(rCtx, null), rv, t);
    }

    private CompletionStage<Void> commitEntryIfNeeded(InvocationContext ctx, FlagAffectedCommand command, Object key, CacheEntry entry, Flag stateTransferFlag) {
        if (entry == null) {
            if (trace) {
                log.tracef("Entry for key %s is null : not calling commitUpdate", Util.toStr((Object)key));
            }
            return CompletableFutures.completedNull();
        }
        boolean l1Invalidation = command instanceof InvalidateL1Command;
        if (entry.isChanged()) {
            if (trace) {
                log.tracef("About to commit entry %s", entry);
            }
            return this.commitContextEntry(entry, ctx, command, stateTransferFlag, l1Invalidation);
        }
        if (trace) {
            log.tracef("Entry for key %s is not changed(%s): not calling commitUpdate", Util.toStr((Object)key), entry);
        }
        return CompletableFutures.completedNull();
    }

    protected final <P extends PrepareCommand> Object wrapEntriesForPrepareAndApply(TxInvocationContext ctx, P command, InvocationSuccessFunction<P> handler) throws Throwable {
        if (!ctx.isOriginLocal() || command.isReplayEntryWrapping()) {
            return this.applyModificationsAndThen(ctx, command, command.getModifications(), 0, handler);
        }
        if (ctx.isOriginLocal()) {
            for (WriteCommand mod : command.getModifications()) {
                if (mod.getTopologyId() >= command.getTopologyId() || !(mod instanceof FunctionalCommand)) continue;
                log.trace("Clearing looked up entries and replaying whole transaction");
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).clearLookedUpEntries();
                return this.applyModificationsAndThen(ctx, command, command.getModifications(), 0, handler);
            }
        }
        return handler.apply(ctx, command, null);
    }

    private <P extends PrepareCommand> Object applyModificationsAndThen(TxInvocationContext ctx, P command, WriteCommand[] modifications, int startIndex, InvocationSuccessFunction<P> handler) throws Throwable {
        for (int i = startIndex; i < modifications.length; ++i) {
            Object result;
            WriteCommand c = modifications[i];
            c.setTopologyId(command.getTopologyId());
            if (c.hasAnyFlag(FlagBitSets.PUT_FOR_X_SITE_STATE_TRANSFER)) {
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).setStateTransferFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
            }
            if (EntryWrappingInterceptor.isSuccessfullyDone(result = c.acceptVisitor(ctx, this.entryWrappingVisitor))) continue;
            int nextIndex = i + 1;
            if (nextIndex >= modifications.length) {
                return EntryWrappingInterceptor.makeStage(result).thenApply(ctx, command, handler);
            }
            return EntryWrappingInterceptor.makeStage(result).thenApply(ctx, command, (rCtx, rCommand, rv) -> this.applyModificationsAndThen(ctx, command, modifications, nextIndex, handler));
        }
        return handler.apply(ctx, command, null);
    }

    private final class EntryWrappingVisitor
    extends AbstractVisitor {
        private EntryWrappingVisitor() {
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) throws Throwable {
            EntryWrappingInterceptor.this.entryFactory.wrapEntryForExpired(ctx, command.getKey(), command.getSegment());
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }

        private Object handleWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
            CompletionStage<Void> stage = EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), command.getSegment(), EntryWrappingInterceptor.this.ignoreOwnership(command) || EntryWrappingInterceptor.this.canRead(command), command.loadType() != VisitableCommand.LoadType.DONT_LOAD);
            return EntryWrappingInterceptor.this.asyncInvokeNext(ctx, (VisitableCommand)command, stage);
        }

        private Object handleWriteManyCommand(InvocationContext ctx, WriteCommand command) {
            boolean ignoreOwnership = EntryWrappingInterceptor.this.ignoreOwnership(command);
            AggregateCompletionStage aggregateCompletionStage = null;
            for (Object key : command.getAffectedKeys()) {
                CompletionStage<Void> stage = EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, key, EntryWrappingInterceptor.this.keyPartitioner.getSegment(key), ignoreOwnership || EntryWrappingInterceptor.this.canReadKey(key), command.loadType() != VisitableCommand.LoadType.DONT_LOAD);
                aggregateCompletionStage = EntryWrappingInterceptor.this.accumulateStage(stage, aggregateCompletionStage);
            }
            return EntryWrappingInterceptor.this.asyncInvokeNext(ctx, (VisitableCommand)command, EntryWrappingInterceptor.this.aggregatedStageOrCompleted(aggregateCompletionStage));
        }
    }
}

