/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.globalstate.impl.GlobalConfigurationManagerImpl;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;

@Listener(observation=Listener.Observation.POST)
public class GlobalConfigurationStateListener {
    private final GlobalConfigurationManagerImpl gcm;

    GlobalConfigurationStateListener(GlobalConfigurationManagerImpl gcm) {
        this.gcm = gcm;
    }

    @CacheEntryCreated
    public CompletionStage<Void> createCache(CacheEntryCreatedEvent<ScopedState, Object> event) {
        if (!"cache".equals(((ScopedState)event.getKey()).getScope())) {
            return CompletableFutures.completedNull();
        }
        String cacheName = ((ScopedState)event.getKey()).getName();
        CacheState state = (CacheState)event.getValue();
        return this.gcm.createCacheLocally(cacheName, state);
    }

    @CacheEntryRemoved
    public CompletionStage<Void> removeCache(CacheEntryRemovedEvent<ScopedState, CacheState> event) {
        if (!"cache".equals(((ScopedState)event.getKey()).getScope())) {
            return CompletableFutures.completedNull();
        }
        String cacheName = ((ScopedState)event.getKey()).getName();
        Log.CONTAINER.debugf("Stopping cache %s because it was removed from global state", cacheName);
        return this.gcm.removeCacheLocally(cacheName, event.getOldValue());
    }
}

