/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LazyExecutorHolder;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask;
import org.hibernate.search.backend.impl.lucene.works.IndexUpdateVisitor;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;

public final class LuceneBackendResources {
    private final AbstractWorkspaceImpl workspace;
    private final ErrorHandler errorHandler;
    private final String indexName;
    private final IndexManager indexManager;
    private final LazyExecutorHolder asynchExecutor;
    private volatile IndexWorkVisitor<Void, LuceneWorkExecutor> workVisitor;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    LuceneBackendResources(WorkerBuildContext context, DirectoryBasedIndexManager indexManager, Properties props, AbstractWorkspaceImpl workspace) {
        this.indexName = indexManager.getIndexName();
        this.indexManager = indexManager;
        this.errorHandler = context.getErrorHandler();
        this.workspace = workspace;
        ReentrantReadWriteLock indexReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = indexReadWriteLock.readLock();
        this.writeLock = indexReadWriteLock.writeLock();
        int maxQueueLength = PropertiesParseHelper.extractMaxQueueSize(this.indexName, props);
        this.asynchExecutor = new LazyExecutorHolder(maxQueueLength, this.indexName, "Index updates queue processor for index " + this.indexName);
    }

    private LuceneBackendResources(LuceneBackendResources previous) {
        this.indexManager = previous.indexManager;
        this.indexName = previous.indexName;
        this.errorHandler = previous.errorHandler;
        this.workspace = previous.workspace;
        this.readLock = previous.readLock;
        this.writeLock = previous.writeLock;
        this.asynchExecutor = previous.asynchExecutor;
    }

    public int getMaxQueueLength() {
        return this.asynchExecutor.getMaxQueueLength();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public IndexWorkVisitor<Void, LuceneWorkExecutor> getWorkVisitor() {
        if (this.workVisitor == null) {
            this.workVisitor = new IndexUpdateVisitor(this.workspace);
        }
        return this.workVisitor;
    }

    public AbstractWorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    public void shutdown() {
        try {
            this.asynchExecutor.flushCloseExecutor();
        }
        finally {
            this.workspace.shutDownNow();
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Lock getParallelModificationLock() {
        return this.readLock;
    }

    public Lock getExclusiveModificationLock() {
        return this.writeLock;
    }

    public LuceneBackendResources onTheFlyRebuild() {
        return new LuceneBackendResources(this);
    }

    public void flushAndReleaseResources() {
        this.asynchExecutor.flushCloseExecutor();
        this.workspace.getCommitPolicy().onClose();
        this.workspace.closeIndexWriter();
    }

    public void submitToAsyncIndexingExecutor(LuceneBackendQueueTask luceneBackendQueueProcessor) {
        this.asynchExecutor.submitTask(luceneBackendQueueProcessor);
    }
}

