/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wildfly.core.jar.runtime.Arguments;
import org.wildfly.core.jar.runtime.BootableEnvironment;
import org.wildfly.core.jar.runtime.CmdUsage;
import org.wildfly.core.jar.runtime.Server;
import org.wildfly.core.jar.runtime._private.BootableJarLogger;

public final class BootableJar
implements Server.ShutdownHandler {
    private static final String DEP_1 = "ff";
    private static final String DEP_2 = "00";
    private BootableJarLogger log;
    private final BootableEnvironment environment;
    private final List<String> startServerArgs = new ArrayList<String>();
    private Server server;
    private final Arguments arguments;
    private final ModuleLoader loader;

    private BootableJar(BootableEnvironment environment, Arguments arguments, ModuleLoader loader, long unzipTime) throws Exception {
        this.environment = environment;
        this.arguments = arguments;
        this.loader = loader;
        this.startServerArgs.addAll(arguments.getServerArguments());
        this.startServerArgs.add("--read-only-server-config=standalone.xml");
        this.configureLogger();
        long t = System.currentTimeMillis();
        if (arguments.getDeployment() != null) {
            this.setupDeployment(arguments.getDeployment());
        }
        this.log.advertiseInstall(environment.getJBossHome(), unzipTime + (System.currentTimeMillis() - t));
    }

    @Override
    public void shutdown(int status) {
        if (status == 10) {
            this.log.cantRestartServer();
        }
        System.exit(status);
    }

    private void setupDeployment(Path deployment) throws Exception {
        Path deploymentDir = this.environment.resolveContentDir(DEP_1, DEP_2);
        Path target = deploymentDir.resolve("content");
        Files.createDirectories(deploymentDir, new FileAttribute[0]);
        boolean isExploded = Files.isDirectory(deployment, new LinkOption[0]);
        BootableJar.updateConfig(this.environment.resolveConfigurationDir("standalone.xml"), deployment.getFileName().toString(), isExploded);
        if (isExploded) {
            this.copyDirectory(deployment, target);
        } else {
            Files.copy(deployment, target, new CopyOption[0]);
        }
        this.log.installDeployment(deployment);
    }

    private static void updateConfig(Path configFile, String name, boolean isExploded) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(configFile.toFile());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(fileInputStream);
        Element root = document.getDocumentElement();
        NodeList lst = root.getChildNodes();
        for (int i = 0; i < lst.getLength(); ++i) {
            Node n = lst.item(i);
            if (!(n instanceof Element) || !"deployments".equals(n.getNodeName())) continue;
            throw BootableJarLogger.ROOT_LOGGER.deploymentAlreadyExist();
        }
        Element deployments = document.createElement("deployments");
        Element deployment = document.createElement("deployment");
        Element content = document.createElement("content");
        content.setAttribute("sha1", "ff00");
        if (isExploded) {
            content.setAttribute("archive", "false");
        }
        deployment.appendChild(content);
        deployment.setAttribute("name", name);
        deployment.setAttribute("runtime-name", name);
        deployments.appendChild(deployment);
        root.appendChild(deployments);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult output = new StreamResult(configFile.toFile());
        DOMSource input = new DOMSource(document);
        transformer.transform(input, output);
    }

    private void copyDirectory(Path src, Path target) throws IOException {
        Files.walk(src, new FileVisitOption[0]).forEach(file -> {
            try {
                Path targetFile = target.resolve(src.relativize((Path)file));
                if (Files.isDirectory(file, new LinkOption[0])) {
                    if (!Files.exists(targetFile, new LinkOption[0])) {
                        Files.createDirectory(targetFile, new FileAttribute[0]);
                    }
                } else {
                    Files.copy(file, targetFile, new CopyOption[0]);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void configureLogger() throws IOException {
        this.environment.setSystemProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        this.configureLogging();
        this.log = BootableJarLogger.ROOT_LOGGER;
    }

    private void configureLogging() throws IOException {
        if (!this.arguments.isVersion().booleanValue()) {
            this.loadBootConfigProperties();
            LogContext ctx = this.configureLogContext();
            LogContext.setLogContextSelector(() -> ctx);
        }
    }

    private LogContext configureLogContext() throws IOException {
        LogContext logContext = LogContext.create();
        Path bootLog = this.environment.resolveLogDir("server.log");
        Path loggingProperties = this.environment.resolveConfigurationDir("logging.properties");
        if (Files.exists(loggingProperties, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(loggingProperties, new OpenOption[0]);){
                this.environment.setSystemProperty("org.jboss.boot.log.file", bootLog.toAbsolutePath().toString());
                PropertyConfigurator configurator = new PropertyConfigurator(logContext);
                configurator.configure(in);
                logContext.getLogger("").attach(Configurator.ATTACHMENT_KEY, (Object)configurator);
            }
        }
        return logContext;
    }

    public void run() throws Exception {
        try {
            this.server = this.buildServer(this.startServerArgs);
        }
        catch (RuntimeException ex) {
            this.cleanup();
            throw ex;
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.server.start();
    }

    private void cleanup() {
        this.log.deletingHome(this.environment.getJBossHome());
        this.deleteDir(this.environment.getJBossHome());
    }

    private Server buildServer(List<String> args) throws IOException {
        String[] array = new String[args.size()];
        this.log.advertiseOptions(args);
        return Server.newSever(args.toArray(array), this.loader, this);
    }

    private void deleteDir(Path root) {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException ex) {
                        BootableJar.this.log.cantDelete(file.toString(), ex);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException ex) {
                        BootableJar.this.log.cantDelete(dir.toString(), ex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitAndClean() {
        try {
            ModelNode mn = new ModelNode();
            mn.get("address");
            mn.get("operation").set("read-attribute");
            mn.get("name").set("server-state");
            int i = 0;
            while (i < 10) {
                try {
                    ModelControllerClient client = this.server.getModelControllerClient();
                    if (client == null) {
                        this.log.nullController();
                        return;
                    }
                    ModelNode ret = client.execute(mn);
                    if (ret.hasDefined("result")) {
                        String val = ret.get("result").asString();
                        if ("stopped".equals(val)) {
                            this.log.serverStopped();
                            return;
                        }
                        this.log.serverNotStopped();
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    throw this.log.unexpectedExceptionWhileShuttingDown(ex);
                }
                ++i;
            }
            return;
        }
        finally {
            this.cleanup();
        }
    }

    private void loadBootConfigProperties() throws IOException {
        Path configFile = this.environment.resolveConfigurationDir("boot-config.properties");
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(reader);
                for (String key : properties.stringPropertyNames()) {
                    this.environment.setSystemProperty(key, properties.getProperty(key));
                }
            }
        }
    }

    public static void run(Path jbossHome, List<String> args, ModuleLoader moduleLoader, ModuleClassLoader moduleClassLoader, Long unzipTime) throws Exception {
        Arguments arguments;
        BootableJar.setTccl((ClassLoader)moduleClassLoader);
        BootableEnvironment environment = BootableEnvironment.of(jbossHome);
        try {
            arguments = Arguments.parseArguments(args, environment);
        }
        catch (Throwable ex) {
            System.err.println(ex);
            CmdUsage.printUsage(System.out);
            return;
        }
        if (arguments.isHelp().booleanValue()) {
            CmdUsage.printUsage(System.out);
            return;
        }
        BootableJar bootableJar = new BootableJar(environment, arguments, moduleLoader, unzipTime);
        BootableJar.configureJMX(moduleClassLoader, bootableJar.log);
        bootableJar.run();
    }

    private static void configureJMX(ModuleClassLoader moduleClassLoader, BootableJarLogger log) throws Exception {
        String mbeanServerBuilderName = BootableJar.getServiceName((ClassLoader)moduleClassLoader, "javax.management.MBeanServerBuilder");
        if (mbeanServerBuilderName != null) {
            System.setProperty("javax.management.builder.initial", mbeanServerBuilderName);
            ManagementFactory.getPlatformMBeanServer();
        }
        try {
            Method m = ModuleLoader.class.getDeclaredMethod("installMBeanServer", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            log.cantRegisterModuleMBeans(ex);
        }
    }

    private static String getServiceName(ClassLoader classLoader, String className) throws IOException {
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);){
            String line;
            if (stream == null) {
                String string = null;
                return string;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(35);
                if (i != -1) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).length() == 0) continue;
                String string = line;
                return string;
            }
            String string = null;
            return string;
        }
    }

    static void setTccl(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            BootableJar.this.log.shuttingDown();
            BootableJar.this.waitAndClean();
        }
    }
}

