/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.interposition;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.internal.jts.interposition.ServerControlWrapper;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteHeuristicServerTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Terminator;

public class ServerFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status getCurrentStatus(Uid uid) throws SystemException {
        if (!uid.valid()) {
            throw new BAD_PARAM();
        }
        try {
            ServerControl ctx = null;
            Hashtable hashtable = ServerControl.allServerControls;
            synchronized (hashtable) {
                ctx = (ServerControl)ServerControl.allServerControls.get(uid);
            }
            if (ctx == null) {
                Enumeration e = ServerControl.allServerControls.elements();
                while (e.hasMoreElements() && !(ctx = (ServerControl)e.nextElement()).getImplHandle().getSavingUid().equals(uid)) {
                }
            }
            if (ctx != null) {
                return ctx.getImplHandle().get_status();
            }
            throw new NoTransaction();
        }
        catch (NoTransaction ex) {
            return Status.StatusNoTransaction;
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_interposition_sfcaught("ServerFactory.getCurrentStatus", uid, e);
            return Status.StatusUnknown;
        }
    }

    public static Status getStatus(Uid u) throws NoTransaction, SystemException {
        Status s = Status.StatusUnknown;
        try {
            s = ServerFactory.getCurrentStatus(u);
        }
        catch (SystemException e2) {
            throw e2;
        }
        catch (Exception e3) {
            jtsLogger.i18NLogger.warn_interposition_sfcaught("ServerFactory.getStatus", u, e3);
            return Status.StatusUnknown;
        }
        if (s == Status.StatusUnknown || s == Status.StatusNoTransaction) {
            return ServerFactory.getOSStatus(u);
        }
        return s;
    }

    public static Status getOSStatus(Uid u) throws NoTransaction, SystemException {
        Status s = Status.StatusUnknown;
        if (!u.valid()) {
            throw new BAD_PARAM();
        }
        RecoveryStore store = StoreManager.getRecoveryStore();
        try {
            int status = store.currentState(u, ServerTransaction.typeName());
            switch (status) {
                case -1: {
                    return ServerFactory.getHeuristicStatus(u, store);
                }
                case 1: {
                    return Status.StatusCommitted;
                }
                case 2: {
                    return Status.StatusPrepared;
                }
                case 4: 
                case 5: 
                case 6: {
                    return Status.StatusPrepared;
                }
            }
            return Status.StatusUnknown;
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_interposition_sfcaught("ServerFactory.getStatus", u, e);
            return Status.StatusUnknown;
        }
    }

    public static ServerControl create_transaction(Uid u, Control parentControl, ArjunaTransactionImple parentImpl, Coordinator realCoord, Terminator realTerm, int time_out) {
        ServerControl tranControl = new ServerControl(u, parentControl, parentImpl, realCoord, realTerm);
        if (time_out != 0 && parentImpl == null) {
            TransactionReaper reaper = TransactionReaper.transactionReaper();
            reaper.insert(new ServerControlWrapper(tranControl), time_out);
        }
        return tranControl;
    }

    public static ServerControl create_subtransaction(Uid actUid, Coordinator realCoord, Terminator realTerm, ServerControl parent) {
        ServerControl toReturn;
        block5: {
            if (parent == null) {
                jtsLogger.i18NLogger.warn_interposition_sfnoparent("ServerFactory.create_subtransaction");
                return null;
            }
            toReturn = null;
            try {
                Control handle = parent.getControl();
                ArjunaTransactionImple tranHandle = parent.getImplHandle();
                toReturn = new ServerControl(actUid, handle, tranHandle, realCoord, realTerm);
                handle = null;
                tranHandle = null;
            }
            catch (Exception e) {
                if (toReturn == null) break block5;
                try {
                    toReturn.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return toReturn;
    }

    private static Status getHeuristicStatus(Uid uid, RecoveryStore recoveryStore) throws ObjectStoreException {
        int status = recoveryStore.currentState(uid, AssumedCompleteHeuristicServerTransaction.typeName());
        switch (status) {
            case -1: {
                return Status.StatusNoTransaction;
            }
            case 1: {
                return Status.StatusCommitted;
            }
            case 2: {
                return Status.StatusPrepared;
            }
            case 4: 
            case 5: 
            case 6: {
                return Status.StatusPrepared;
            }
        }
        return Status.StatusUnknown;
    }
}

