/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.webservices.dmr.Attribute;
import org.jboss.as.webservices.dmr.Element;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class WSSubsystemLegacyReader
implements XMLElementReader<List<ModelNode>> {
    WSSubsystemLegacyReader() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", "webservices");
        ArrayList<ModelNode> endpointConfigs = new ArrayList<ModelNode>();
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        while (reader.hasNext() && reader.nextTag() != 2) {
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEBSERVICES_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element != Element.ENDPOINT_CONFIG && !encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case MODIFY_WSDL_ADDRESS: {
                            boolean b = Boolean.parseBoolean(this.parseElementNoAttributes(reader));
                            subsystem.get("modify-wsdl-address").set(b);
                            break block0;
                        }
                        case WSDL_HOST: {
                            subsystem.get("wsdl-host").set(this.parseElementNoAttributes(reader));
                            break block0;
                        }
                        case WSDL_PORT: {
                            int port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-port").set(port);
                            break block0;
                        }
                        case WSDL_SECURE_PORT: {
                            int port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-secure-port").set(port);
                            break block0;
                        }
                        case ENDPOINT_CONFIG: {
                            this.readEndpointConfig(reader, subsystem.get("address"), endpointConfigs);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        list.add(subsystem);
        list.addAll(endpointConfigs);
    }

    private String parseElementNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        return reader.getElementText().trim();
    }

    private void readEndpointConfig(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationList) throws XMLStreamException {
        String configName = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block6: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.PROPERTY && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CONFIG_NAME: {
                    configName = this.parseElementNoAttributes(reader);
                    ModelNode node = new ModelNode();
                    node.get("operation").set("add");
                    node.get("address").set(address).add("endpoint-config", configName);
                    operationList.add(node);
                    continue block6;
                }
                case PRE_HANDLER_CHAINS: {
                    this.parseHandlerChains(reader, configName, operationList, true);
                    continue block6;
                }
                case POST_HANDLER_CHAINS: {
                    this.parseHandlerChains(reader, configName, operationList, false);
                    continue block6;
                }
                case PROPERTY: {
                    ModelNode operation = this.parseProperty(reader, configName);
                    operationList.add(operation);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseProperty(XMLExtendedStreamReader reader, String configName) throws XMLStreamException {
        String propertyName = null;
        String propertyValue = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block4: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTY_NAME: {
                    propertyName = this.parseElementNoAttributes(reader);
                    continue block4;
                }
                case PROPERTY_VALUE: {
                    propertyValue = this.parseElementNoAttributes(reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "webservices").add("endpoint-config", configName).add("property", propertyName);
        if (propertyValue != null) {
            operation.get("value").set(propertyValue);
        }
        return operation;
    }

    private ModelNode parseHandlerChains(XMLExtendedStreamReader reader, String configName, List<ModelNode> operationList, boolean isPreHandlerChain) throws XMLStreamException {
        ModelNode chainsNode = new ModelNode();
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block3: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.HANDLER_CHAIN && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case HANDLER_CHAIN: {
                    this.parseHandlerChain(reader, configName, operationList, isPreHandlerChain);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return chainsNode;
    }

    private void parseHandlerChain(XMLExtendedStreamReader reader, String configName, List<ModelNode> operationList, boolean isPreHandlerChain) throws XMLStreamException {
        String handlerChainId = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    handlerChainId = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (handlerChainId == null) {
            handlerChainId = "auto-generated-" + System.currentTimeMillis();
        }
        String protocolBindings = null;
        LinkedList<ModelNode> addHandlerOperations = new LinkedList<ModelNode>();
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.HANDLER && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROTOCOL_BINDINGS: {
                    protocolBindings = this.parseElementNoAttributes(reader);
                    continue block8;
                }
                case HANDLER: {
                    this.parseHandler(reader, configName, handlerChainId, isPreHandlerChain, addHandlerOperations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = new ModelNode();
        String handlerChainType = isPreHandlerChain ? "pre-handler-chain" : "post-handler-chain";
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "webservices").add("endpoint-config", configName).add(handlerChainType, handlerChainId);
        if (protocolBindings != null) {
            operation.get("protocol-bindings").set(protocolBindings);
        }
        operationList.add(operation);
        operationList.addAll(addHandlerOperations);
    }

    private void parseHandler(XMLExtendedStreamReader reader, String configName, String handlerChainId, boolean isPreHandlerChain, List<ModelNode> operations) throws XMLStreamException {
        String handlerName = null;
        String handlerClass = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block4: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case HANDLER_NAME: {
                    handlerName = this.parseElementNoAttributes(reader);
                    continue block4;
                }
                case HANDLER_CLASS: {
                    handlerClass = this.parseElementNoAttributes(reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = new ModelNode();
        String handlerChainType = isPreHandlerChain ? "pre-handler-chain" : "post-handler-chain";
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "webservices").add("endpoint-config", configName).add(handlerChainType, handlerChainId).add("handler", handlerName);
        operation.get("class").set(handlerClass);
        operations.add(operation);
    }
}

