/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.HeadersCompleter;
import org.jboss.as.cli.impl.aesh.cmd.HeadersConverter;
import org.jboss.as.cli.impl.aesh.cmd.LegacyBridge;
import org.jboss.as.cli.impl.aesh.cmd.deployment.AbstractDeployCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.CommandWithPermissions;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.OptionActivators;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.impl.aesh.cmd.security.ControlledCommandActivator;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.BatchCompliantCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;

@CommandDefinition(name="abstract-undeploy-deployment", description="", activator=ControlledCommandActivator.class)
public abstract class AbstractUndeployCommand
extends CommandWithPermissions
implements Command<CLICommandInvocation>,
BatchCompliantCommand,
LegacyBridge {
    @Deprecated
    @Option(hasValue=false, activator=HideOptionActivator.class)
    private boolean help;
    @Option(name="server-groups", activator=OptionActivators.UndeployServerGroupsActivator.class, completer=AbstractDeployCommand.ServerGroupsCompleter.class, required=false)
    public String serverGroups;
    @Option(name="all-relevant-server-groups", activator=OptionActivators.AllRelevantServerGroupsActivator.class, hasValue=false, required=false)
    public boolean allRelevantServerGroups;
    @Option(converter=HeadersConverter.class, completer=HeadersCompleter.class, required=false)
    public ModelNode headers;

    public AbstractUndeployCommand(CommandContext ctx, Permissions permissions) {
        super(ctx, AccessRequirements.undeployAccess(permissions), permissions);
    }

    protected abstract boolean keepContent();

    protected abstract String getName();

    protected abstract String getCommandName();

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("deployment " + this.getCommandName()));
            return CommandResult.SUCCESS;
        }
        return this.execute(commandInvocation.getCommandContext());
    }

    @Override
    public CommandResult execute(CommandContext ctx) throws CommandException {
        String name = this.getName();
        if (name == null) {
            throw new CommandException("No deployment name");
        }
        AbstractUndeployCommand.undeployName(ctx, name, this.allRelevantServerGroups, this.serverGroups, this.keepContent(), this.headers);
        return CommandResult.SUCCESS;
    }

    @Override
    public BatchCompliantCommand.BatchResponseHandler buildBatchResponseHandler(CommandContext commandContext, Attachments attachments) {
        return null;
    }

    static void undeployName(CommandContext ctx, String name, boolean allServerGroups, String serverGroups, boolean keepContent, ModelNode headers) throws CommandException {
        try {
            ModelNode request = AbstractUndeployCommand.buildRequest(ctx, name, allServerGroups, serverGroups, keepContent, headers);
            ModelNode result = ctx.getModelControllerClient().execute(request);
            if (!Util.isSuccess(result)) {
                throw new CommandException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandException("Failed to deploy", e);
        }
        catch (CommandFormatException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        return AbstractUndeployCommand.buildRequest(context, this.getName(), this.allRelevantServerGroups, this.serverGroups, this.keepContent(), this.headers);
    }

    private static ModelNode buildRequest(CommandContext ctx, String name, boolean allRelevantServerGroups, String serverGroupsStr, boolean keepContent, ModelNode headers) throws CommandFormatException {
        DefaultOperationRequestBuilder builder;
        List<String> deploymentNames;
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ModelControllerClient client = ctx.getModelControllerClient();
        boolean all = false;
        if (name.indexOf(42) < 0) {
            deploymentNames = Collections.singletonList(name);
        } else {
            deploymentNames = Util.getMatchingDeployments(client, name, null);
            if (deploymentNames.isEmpty()) {
                throw new CommandFormatException("No deployment matched wildcard expression " + name);
            }
            all = true;
        }
        for (String deploymentName : deploymentNames) {
            if (ctx.isDomainMode()) {
                List<Object> serverGroups;
                if (allRelevantServerGroups) {
                    if (keepContent) {
                        serverGroups = Util.getAllEnabledServerGroups(deploymentName, client);
                        if (all && serverGroups.isEmpty()) {
                            continue;
                        }
                    } else {
                        try {
                            serverGroups = Util.getServerGroupsReferencingDeployment(deploymentName, client);
                        }
                        catch (CommandLineException e) {
                            throw new CommandFormatException("Failed to retrieve all referencing server groups", e);
                        }
                    }
                } else {
                    serverGroups = serverGroupsStr == null ? Collections.emptyList() : Arrays.asList(serverGroupsStr.split(","));
                }
                if (serverGroups.isEmpty() && keepContent) {
                    throw new OperationFormatException("None of the server groups is specified or references deployment " + deploymentName);
                }
                if (!keepContent) {
                    try {
                        List<String> sg = Util.getServerGroupsReferencingDeployment(deploymentName, client);
                        keepContent = !serverGroups.containsAll(sg);
                    }
                    catch (CommandLineException e) {
                        throw new CommandFormatException("Failed to retrieve all referencing server groups", e);
                    }
                }
                for (String string : serverGroups) {
                    if (all && !Util.isDeploymentPresent(deploymentName, client, string)) continue;
                    ModelNode groupStep = Util.configureDeploymentOperation("undeploy", deploymentName, string);
                    steps.add(groupStep);
                    if (keepContent) continue;
                    groupStep = Util.configureDeploymentOperation("remove", deploymentName, string);
                    steps.add(groupStep);
                }
                continue;
            }
            builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("undeploy");
            builder.addNode("deployment", deploymentName);
            steps.add(builder.buildRequest());
        }
        if (!keepContent) {
            for (String deploymentName : deploymentNames) {
                builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("remove");
                builder.addNode("deployment", deploymentName);
                steps.add(builder.buildRequest());
            }
        } else if (ctx.isDomainMode() && allRelevantServerGroups && all && !steps.isDefined()) {
            throw new OperationFormatException("No enabled deployment found in any server-groups.");
        }
        if (headers != null) {
            ModelNode opHeaders = composite.get("operation-headers");
            opHeaders.set(headers);
        }
        return composite;
    }
}

