/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.algorithm.ContentEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.build.JwtEncryptionBuilder;
import io.smallrye.jwt.build.JwtEncryptionException;
import io.smallrye.jwt.build.JwtSignatureException;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.crypto.SecretKey;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;

class JwtEncryptionImpl
implements JwtEncryptionBuilder {
    boolean innerSigned;
    String claims;
    Map<String, Object> headers = new HashMap<String, Object>();

    JwtEncryptionImpl(String claims) {
        this.claims = claims;
    }

    JwtEncryptionImpl(String claims, boolean innerSigned) {
        this.claims = claims;
        this.innerSigned = innerSigned;
    }

    @Override
    public String encrypt(PublicKey keyEncryptionKey) throws JwtEncryptionException {
        return this.encryptInternal(keyEncryptionKey);
    }

    @Override
    public String encrypt(SecretKey keyEncryptionKey) throws JwtEncryptionException {
        return this.encryptInternal(keyEncryptionKey);
    }

    @Override
    public String encrypt(String keyLocation) throws JwtEncryptionException {
        Key key = null;
        try {
            key = KeyUtils.readEncryptionKey(keyLocation, (String)this.headers.get("kid"));
        }
        catch (Exception ex) {
            throw new JwtEncryptionException(ex);
        }
        return key instanceof PublicKey ? this.encryptInternal((PublicKey)key) : this.encryptInternal((SecretKey)key);
    }

    @Override
    public String encrypt() throws JwtSignatureException {
        return this.encryptInternal(JwtEncryptionImpl.getKeyEncryptionKeyFromConfig((String)this.headers.get("kid")));
    }

    @Override
    public JwtEncryptionBuilder header(String name, Object value) {
        if ("alg".equals(name)) {
            return this.keyEncryptionAlgorithm(JwtEncryptionImpl.toKeyEncryptionAlgorithm((String)value));
        }
        if ("enc".equals(name)) {
            return this.contentEncryptionAlgorithm(JwtEncryptionImpl.toContentEncryptionAlgorithm((String)value));
        }
        this.headers.put(name, value);
        return this;
    }

    @Override
    public JwtEncryptionBuilder keyEncryptionAlgorithm(KeyEncryptionAlgorithm algorithm) {
        this.headers.put("alg", algorithm.getAlgorithm());
        return this;
    }

    @Override
    public JwtEncryptionBuilder contentEncryptionAlgorithm(ContentEncryptionAlgorithm algorithm) {
        this.headers.put("enc", algorithm.getAlgorithm());
        return this;
    }

    @Override
    public JwtEncryptionBuilder keyEncryptionKeyId(String keyId) {
        this.headers.put("kid", keyId);
        return this;
    }

    private String encryptInternal(Key key) {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setPlaintext(this.claims);
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            jwe.getHeaders().setObjectHeaderValue(entry.getKey(), entry.getValue());
        }
        if (this.innerSigned && !this.headers.containsKey("cty")) {
            jwe.getHeaders().setObjectHeaderValue("cty", (Object)"JWT");
        }
        String keyAlgorithm = this.getKeyEncryptionAlgorithm(key);
        jwe.setAlgorithmHeaderValue(keyAlgorithm);
        jwe.setEncryptionMethodHeaderParameter(this.getContentEncryptionAlgorithm());
        if (key instanceof RSAPublicKey && keyAlgorithm.startsWith(KeyEncryptionAlgorithm.RSA_OAEP.getAlgorithm()) && ((RSAPublicKey)key).getModulus().bitLength() < 2048) {
            throw new JwtEncryptionException("A key of size 2048 bits or larger MUST be used with the '" + keyAlgorithm + "' algorithm");
        }
        jwe.setKey(key);
        try {
            return jwe.getCompactSerialization();
        }
        catch (JoseException ex) {
            throw new JwtEncryptionException(ex.getMessage(), ex);
        }
    }

    private String getKeyEncryptionAlgorithm(Key keyEncryptionKey) {
        String alg = (String)this.headers.get("alg");
        if ("dir".equals(alg)) {
            throw new JwtEncryptionException("Direct content encryption is currently not supported");
        }
        if (keyEncryptionKey instanceof RSAPublicKey) {
            if (alg == null) {
                return KeyEncryptionAlgorithm.RSA_OAEP_256.getAlgorithm();
            }
            return alg;
        }
        if (keyEncryptionKey instanceof SecretKey) {
            if (alg == null) {
                return KeyEncryptionAlgorithm.A256KW.getAlgorithm();
            }
            return alg;
        }
        if (keyEncryptionKey instanceof ECPublicKey) {
            if (alg == null) {
                return KeyEncryptionAlgorithm.ECDH_ES_A256KW.getAlgorithm();
            }
            return alg;
        }
        throw new JwtEncryptionException("Unsupported key encryption algorithm: " + keyEncryptionKey.getAlgorithm());
    }

    private String getContentEncryptionAlgorithm() {
        return this.headers.containsKey("enc") ? this.headers.get("enc").toString() : ContentEncryptionAlgorithm.A256GCM.name();
    }

    static Key getKeyEncryptionKeyFromConfig(String kid) {
        try {
            String keyLocation = (String)ConfigProvider.getConfig().getValue("smallrye.jwt.encrypt.key-location", String.class);
            try {
                return KeyUtils.readEncryptionKey(keyLocation, kid);
            }
            catch (Exception ex) {
                throw new JwtEncryptionException("Key encrypting key can not be loaded from: " + keyLocation);
            }
        }
        catch (NoSuchElementException ex) {
            throw new JwtEncryptionException("Please set a 'smallrye.jwt.encrypt.key-location' property");
        }
    }

    private static KeyEncryptionAlgorithm toKeyEncryptionAlgorithm(String value) {
        try {
            return KeyEncryptionAlgorithm.fromAlgorithm(value);
        }
        catch (Exception ex) {
            throw new JwtEncryptionException("Unsupported key encryption algorithm: " + value);
        }
    }

    private static ContentEncryptionAlgorithm toContentEncryptionAlgorithm(String value) {
        try {
            return ContentEncryptionAlgorithm.fromAlgorithm(value);
        }
        catch (Exception ex) {
            throw new JwtEncryptionException("Unsupported content encryption algorithm: " + value);
        }
    }
}

