/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ManagementModelNode
extends DefaultMutableTreeNode {
    private CliGuiContext cliGuiCtx;
    private CommandExecutor executor;
    private boolean isLeaf = false;
    private boolean isGeneric = false;

    public ManagementModelNode(CliGuiContext cliGuiCtx) {
        this.cliGuiCtx = cliGuiCtx;
        this.executor = cliGuiCtx.getExecutor();
        this.isLeaf = false;
        this.setUserObject(new UserObject());
    }

    private ManagementModelNode(CliGuiContext cliGuiCtx, UserObject userObject) {
        this.cliGuiCtx = cliGuiCtx;
        this.executor = cliGuiCtx.getExecutor();
        this.isLeaf = userObject.isLeaf;
        this.isGeneric = userObject.isGeneric;
        if (this.isGeneric) {
            this.setAllowsChildren(false);
        }
        this.setUserObject(userObject);
    }

    @Override
    public ManagementModelNode clone() {
        UserObject toBeCloned = (UserObject)this.getUserObject();
        UserObject clonedUsrObj = new UserObject(toBeCloned, this.addressPath(), true);
        return new ManagementModelNode(this.cliGuiCtx, clonedUsrObj);
    }

    public void explore() {
        if (this.isLeaf) {
            return;
        }
        if (this.isGeneric) {
            return;
        }
        this.removeAllChildren();
        try {
            String addressPath = this.addressPath();
            ModelNode resourceDesc = this.executor.doCommand(addressPath + ":read-resource-description");
            resourceDesc = resourceDesc.get("result");
            ModelNode response = this.executor.doCommand(addressPath + ":read-resource(include-runtime=true,include-defaults=true)");
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return;
            }
            List<String> childrenTypes = this.getChildrenTypes(addressPath);
            for (ModelNode node : result.asList()) {
                Property prop = node.asProperty();
                if (childrenTypes.contains(prop.getName())) {
                    if (this.hasGenericOperations(addressPath, prop.getName())) {
                        this.add(new ManagementModelNode(this.cliGuiCtx, new UserObject(node, prop.getName())));
                    }
                    if (!prop.getValue().isDefined()) continue;
                    for (ModelNode innerNode : prop.getValue().asList()) {
                        UserObject usrObj = new UserObject(innerNode, prop.getName(), innerNode.asProperty().getName());
                        this.add(new ManagementModelNode(this.cliGuiCtx, usrObj));
                    }
                    continue;
                }
                UserObject usrObj = new UserObject(node, resourceDesc, prop.getName(), prop.getValue().asString());
                this.add(new ManagementModelNode(this.cliGuiCtx, usrObj));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasGenericOperations(String addressPath, String resourceName) throws Exception {
        ModelNode response = this.executor.doCommand(addressPath + resourceName + "=*/:read-operation-names");
        if (response.get("outcome").asString().equals("failed")) {
            return false;
        }
        for (ModelNode node : response.get("result").asList()) {
            if (!node.asString().equals("add")) continue;
            return true;
        }
        return false;
    }

    private List<String> getChildrenTypes(String addressPath) throws Exception {
        ArrayList<String> childrenTypes = new ArrayList<String>();
        ModelNode readChildrenTypes = this.executor.doCommand(addressPath + ":read-children-types");
        for (ModelNode type : readChildrenTypes.get("result").asList()) {
            childrenTypes.add(type.asString());
        }
        return childrenTypes;
    }

    public String addressPath() {
        if (this.isLeaf) {
            ManagementModelNode parent = (ManagementModelNode)this.getParent();
            return parent.addressPath();
        }
        StringBuilder builder = new StringBuilder();
        for (Object pathElement : this.getUserObjectPath()) {
            UserObject userObj = (UserObject)pathElement;
            if (userObj.isRoot()) {
                builder.append(userObj.getName());
                continue;
            }
            builder.append(userObj.getName());
            builder.append("=");
            builder.append(userObj.getEscapedValue());
            builder.append("/");
        }
        return builder.toString();
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    public static String escapeAddressElement(String element) {
        element = element.replace(":", "\\:");
        element = element.replace("/", "\\/");
        element = element.replace("=", "\\=");
        element = element.replace(" ", "\\ ");
        element = element.replace("$", "\\$");
        return element;
    }

    class AttributeDescription {
        private ModelNode attributes;

        AttributeDescription(ModelNode attributes) {
            this.attributes = attributes;
        }

        AttributeDescription(AttributeDescription attrDesc) {
            this.attributes = attrDesc.attributes.clone();
        }

        public boolean isRuntime() {
            return this.attributes.get("storage").asString().equals("runtime");
        }

        public ModelType getType() {
            return this.attributes.get("type").asType();
        }

        public boolean isGraphable() {
            return this.isRuntime() && this.isNumeric();
        }

        public boolean isNumeric() {
            ModelType type = this.getType();
            return type == ModelType.BIG_DECIMAL || type == ModelType.BIG_INTEGER || type == ModelType.DOUBLE || type == ModelType.INT || type == ModelType.LONG;
        }
    }

    public class UserObject {
        private ModelNode backingNode;
        private String name;
        private String value;
        private boolean isLeaf;
        private boolean isGeneric = false;
        private boolean isRoot = false;
        private String separator;
        private AttributeDescription attribDesc = null;

        public UserObject() {
            this.backingNode = new ModelNode();
            this.name = "/";
            this.value = "";
            this.isLeaf = false;
            this.isRoot = true;
            this.separator = "";
        }

        public UserObject(UserObject usrObj, String addressPath, boolean isRoot) {
            if (usrObj.backingNode != null) {
                this.backingNode = usrObj.backingNode.clone();
            }
            this.name = addressPath;
            this.value = usrObj.value;
            this.isLeaf = usrObj.isLeaf;
            this.isRoot = isRoot;
            this.isGeneric = usrObj.isGeneric;
            this.separator = usrObj.separator;
            if (usrObj.attribDesc != null) {
                this.attribDesc = new AttributeDescription(usrObj.attribDesc);
            }
        }

        public UserObject(ModelNode backingNode, String name) {
            this.backingNode = backingNode;
            this.name = name;
            this.value = "*";
            this.isLeaf = false;
            this.isGeneric = true;
            this.separator = "=";
        }

        public UserObject(ModelNode backingNode, String name, String value) {
            this.backingNode = backingNode;
            this.name = name;
            this.value = value;
            this.isLeaf = false;
            this.separator = "=";
        }

        public UserObject(ModelNode backingNode, ModelNode resourceDesc, String name, String value) {
            this.attribDesc = new AttributeDescription(resourceDesc.get(new String[]{"attributes", name}));
            this.backingNode = backingNode;
            this.name = name;
            this.value = value;
            this.isLeaf = true;
            this.separator = this.attribDesc.isGraphable() ? " \u2245 " : " => ";
        }

        public ModelNode getBackingNode() {
            return this.backingNode;
        }

        public AttributeDescription getAttributeDescription() {
            return this.attribDesc;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getEscapedValue() {
            return ManagementModelNode.escapeAddressElement(this.value);
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public boolean isGeneric() {
            return this.isGeneric;
        }

        public String toString() {
            if (this.isRoot) {
                return this.name;
            }
            return this.name + this.separator + this.value;
        }
    }
}

