/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.topology.CacheTopology;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.AddressableNode;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.group.CacheMembership;
import org.wildfly.clustering.server.group.SingletonMembership;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.spi.group.Group;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class CacheGroup
implements Group<Address>,
AutoCloseable,
Function<GroupListener, ExecutorService> {
    private final Map<GroupListener, ExecutorService> listeners = new ConcurrentHashMap<GroupListener, ExecutorService>();
    private final Cache<?, ?> cache;
    private final NodeFactory<org.jgroups.Address> nodeFactory;
    private final SortedMap<Integer, Boolean> views = Collections.synchronizedSortedMap(new TreeMap());

    public CacheGroup(CacheGroupConfiguration config) {
        this.cache = config.getCache();
        this.nodeFactory = config.getMemberFactory();
        this.cache.getCacheManager().addListener((Object)this);
        this.cache.addListener((Object)this);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        this.cache.getCacheManager().removeListener((Object)this);
        for (ExecutorService executor : this.listeners.values()) {
            this.shutdown(executor);
        }
        this.listeners.clear();
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getName() {
        GlobalConfiguration global = this.cache.getCacheManager().getCacheManagerConfiguration();
        TransportConfiguration transport = global.transport();
        return transport.transport() != null ? transport.clusterName() : global.cacheManagerName();
    }

    public Node getLocalMember() {
        return this.createNode(this.cache.getCacheManager().getAddress());
    }

    public Membership getMembership() {
        if (this.isSingleton()) {
            return new SingletonMembership(this.getLocalMember());
        }
        EmbeddedCacheManager manager = this.cache.getCacheManager();
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? new CacheMembership(manager.getAddress(), (CacheTopology)dist.getCacheTopology(), (NodeFactory<Address>)this) : new CacheMembership(manager, (NodeFactory<Address>)this);
    }

    public boolean isSingleton() {
        return this.cache.getCacheManager().getTransport() == null;
    }

    public Node createNode(Address address) {
        return this.nodeFactory.createNode((Object)CacheGroup.toJGroupsAddress(address));
    }

    public Address getAddress(Node node) {
        return node instanceof AddressableNode ? JGroupsAddressCache.fromJGroupsAddress((org.jgroups.Address)((AddressableNode)node).getAddress()) : LocalModeAddress.INSTANCE;
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address == null || address == LocalModeAddress.INSTANCE) {
            return null;
        }
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress)address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }

    @Merged
    @ViewChanged
    public void viewChanged(final ViewChangedEvent event) {
        if (this.cache.getAdvancedCache().getDistributionManager() != null) {
            this.views.put(event.getViewId(), event.isMergeView());
        } else if (!this.listeners.isEmpty()) {
            final CacheMembership previousMembership = new CacheMembership(event.getLocalAddress(), event.getOldMembers(), (NodeFactory<Address>)this);
            final CacheMembership membership = new CacheMembership(event.getLocalAddress(), event.getNewMembers(), (NodeFactory<Address>)this);
            for (Map.Entry<GroupListener, ExecutorService> entry : this.listeners.entrySet()) {
                final GroupListener listener = entry.getKey();
                ExecutorService executor = entry.getValue();
                Runnable listenerTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.membershipChanged(previousMembership, membership, event.isMergeView());
                        }
                        catch (Throwable e) {
                            ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                        }
                    }
                };
                try {
                    executor.submit(listenerTask);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<?, ?> event) {
        if (event.isPre()) {
            return;
        }
        int viewId = event.getCache().getCacheManager().getTransport().getViewId();
        if (!this.listeners.isEmpty()) {
            Address localAddress = event.getCache().getCacheManager().getAddress();
            final CacheMembership previousMembership = new CacheMembership(localAddress, event.getWriteConsistentHashAtStart(), (NodeFactory<Address>)this);
            final CacheMembership membership = new CacheMembership(localAddress, event.getWriteConsistentHashAtEnd(), (NodeFactory<Address>)this);
            Boolean status = (Boolean)this.views.get(viewId);
            final boolean merged = status != null ? status : false;
            for (Map.Entry<GroupListener, ExecutorService> entry : this.listeners.entrySet()) {
                final GroupListener listener = entry.getKey();
                ExecutorService executor = entry.getValue();
                Runnable listenerTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.membershipChanged(previousMembership, membership, merged);
                        }
                        catch (Throwable e) {
                            ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                        }
                    }
                };
                try {
                    executor.submit(listenerTask);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
        this.views.headMap(viewId).clear();
    }

    public Registration register(GroupListener listener) {
        this.listeners.computeIfAbsent(listener, this);
        return () -> this.unregister(listener);
    }

    @Override
    public ExecutorService apply(GroupListener listener) {
        return new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD);
    }

    private void unregister(GroupListener listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }

    @Deprecated
    public void removeListener(Group.Listener listener) {
        this.unregister((GroupListener)listener);
    }
}

