/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.coarse;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.hotrod.RemoteCacheMutatorFactory;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.hotrod.logging.Logger;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class CoarseSessionAttributesFactory<S, C, L, V>
implements SessionAttributesFactory<C, Map<String, Object>> {
    private final RemoteCache<SessionAttributesKey, V> cache;
    private final Marshaller<Map<String, Object>, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final MutatorFactory<SessionAttributesKey, V> mutatorFactory;
    private final HttpSessionActivationListenerProvider<S, C, L> provider;

    public CoarseSessionAttributesFactory(HotRodSessionAttributesFactoryConfiguration<S, C, L, Map<String, Object>, V> configuration) {
        this.cache = configuration.getCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = configuration.getCacheProperties();
        this.mutatorFactory = new RemoteCacheMutatorFactory(this.cache);
        this.provider = configuration.getHttpSessionActivationListenerProvider();
    }

    public Map<String, Object> createValue(String id, Void context) {
        ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        Object value = this.marshaller.write(attributes);
        this.cache.put((Object)new SessionAttributesKey(id), value);
        return attributes;
    }

    public Map<String, Object> findValue(String id) {
        Object value = this.cache.get((Object)new SessionAttributesKey(id));
        if (value != null) {
            try {
                return (Map)this.marshaller.read(value);
            }
            catch (InvalidSerializedFormException e) {
                Logger.ROOT_LOGGER.failedToActivateSession(e, id.toString());
                this.remove(id);
            }
        }
        return null;
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, Object> values, ImmutableSessionMetaData metaData, C context) {
        ImmutableSessionAttributes attributes = this.createImmutableSessionAttributes(id, values);
        ImmutableSessionActivationNotifier notifier = new ImmutableSessionActivationNotifier(this.provider, (ImmutableSession)new CompositeImmutableSession(id, metaData, attributes), context);
        Mutator mutator = this.mutatorFactory.createMutator((Object)new SessionAttributesKey(id), this.marshaller.write(values));
        return new CoarseSessionAttributes(values, mutator, this.marshaller, this.immutability, this.properties, (SessionActivationNotifier)notifier);
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map<String, Object> values) {
        return new CoarseImmutableSessionAttributes(values);
    }

    public boolean remove(String id) {
        this.cache.remove((Object)new SessionAttributesKey(id));
        return true;
    }
}

