/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.reactive.publisher.impl.PublisherHandler;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class CancelPublisherCommand
extends BaseRpcCommand
implements InitializableCommand {
    public static final byte COMMAND_ID = 49;
    private PublisherHandler publisherHandler;
    private Object requestId;

    private CancelPublisherCommand() {
        super(null);
    }

    public CancelPublisherCommand(ByteString cacheName) {
        super(cacheName);
    }

    public CancelPublisherCommand(ByteString cacheName, Object requestId) {
        super(cacheName);
        this.requestId = requestId;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.publisherHandler.closePublisher(this.requestId);
        return CompletableFutures.completedNull();
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.publisherHandler = componentRegistry.getPublisherHandler().running();
    }

    @Override
    public byte getCommandId() {
        return 49;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.requestId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.requestId = input.readObject();
    }
}

