/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

public class InvalidateCommand
extends AbstractTopologyAffectedCommand
implements WriteCommand,
RemoteLockCommand {
    public static final int COMMAND_ID = 6;
    protected Object[] keys;
    protected CommandInvocationId commandInvocationId;

    public InvalidateCommand() {
    }

    public InvalidateCommand(long flagsBitSet, CommandInvocationId commandInvocationId, Object ... keys) {
        this.keys = keys;
        this.commandInvocationId = commandInvocationId;
        this.setFlagsBitSet(flagsBitSet);
    }

    public InvalidateCommand(long flagsBitSet, Collection<Object> keys, CommandInvocationId commandInvocationId) {
        this(flagsBitSet, commandInvocationId, keys == null || keys.isEmpty() ? Util.EMPTY_OBJECT_ARRAY : keys.toArray(new Object[keys.size()]));
    }

    @Override
    public byte getCommandId() {
        return 6;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    public String toString() {
        return "InvalidateCommand{keys=" + Util.toStr(Arrays.asList(this.keys)) + '}';
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallArray((Object[])this.keys, (ObjectOutput)output);
        output.writeLong(this.getFlagsBitSet());
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.keys = MarshallUtil.unmarshallArray((ObjectInput)input, Util::objectArray);
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateCommand(ctx, this);
    }

    public Object[] getKeys() {
        return this.keys;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return new HashSet<Object>(Arrays.asList(this.keys));
    }

    @Override
    public void fail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    @Override
    public Collection<?> getKeysToLock() {
        return Arrays.asList(this.keys);
    }

    @Override
    public Object getKeyLockOwner() {
        return this.commandInvocationId;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvalidateCommand that = (InvalidateCommand)obj;
        if (!this.hasSameFlags(that)) {
            return false;
        }
        return Arrays.equals(this.keys, that.keys);
    }

    public int hashCode() {
        return this.keys != null ? Arrays.hashCode(this.keys) : 0;
    }
}

