/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.util.Util;

@Immutable
public class Version {
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int PATCH_MASK = 63;
    private static final Version INSTANCE = new Version();
    public static final String INFINISPAN_VERSION = "infinispan.version";
    public static final String INFINISPAN_BRAND_NAME = "infinispan.brand.name";
    public static final String INFINISPAN_BRAND_VERSION = "infinispan.brand.version";
    public static final String INFINISPAN_CODENAME = "infinispan.codename";
    public static final String INFINISPAN_CORE_SCHEMA_VERSION = "infinispan.core.schema.version";
    public static final String INFINISPAN_MODULE_SLOT_PREFIX = "infinispan.module.slot.prefix";
    public static final String INFINISPAN_MODULE_SLOT_VERSION = "infinispan.module.slot.version";
    private final String version;
    private final String brandName;
    private final String brandVersion;
    private final String codename;
    private final String schemaVersion;
    private final byte[] versionId;
    private final String moduleSlot;
    private final short versionShort;
    private final short marshallVersion;
    private final String majorMinor;
    private final String major;
    private final String minor;

    private Version() {
        this(Version.class.getResourceAsStream("/META-INF/infinispan-version.properties"));
    }

    private Version(InputStream is) {
        Properties properties = new Properties();
        try {
            properties.load(is);
            Util.close((AutoCloseable)is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.version = properties.getProperty(INFINISPAN_VERSION, "0.0.0-SNAPSHOT");
        this.brandName = properties.getProperty(INFINISPAN_BRAND_NAME, "Infinispan");
        this.brandVersion = properties.getProperty(INFINISPAN_BRAND_VERSION, this.version);
        this.codename = properties.getProperty(INFINISPAN_CODENAME, "N/A");
        this.schemaVersion = properties.getProperty(INFINISPAN_CORE_SCHEMA_VERSION, "0.0");
        String[] parts = Version.getParts(this.version);
        this.versionId = Version.readVersionBytes(parts[0], parts[1], parts[2], parts[3]);
        this.versionShort = Version.getVersionShort(this.version);
        String modulePrefix = properties.getProperty(INFINISPAN_MODULE_SLOT_PREFIX, "ispn");
        String moduleVersion = properties.getProperty(INFINISPAN_MODULE_SLOT_VERSION, parts[0] + "." + parts[1]);
        this.moduleSlot = String.format("%s-%s", modulePrefix, moduleVersion);
        this.marshallVersion = Short.valueOf(parts[0] + parts[1]);
        this.majorMinor = String.format("%s.%s", parts[0], parts[1]);
        this.major = parts[0];
        this.minor = parts[1];
    }

    public static Version from(InputStream is) {
        return new Version(is);
    }

    public String version() {
        return this.version;
    }

    public String brandName() {
        return this.brandName;
    }

    public static String getVersion() {
        return Version.INSTANCE.version;
    }

    public static String getBrandName() {
        return Version.INSTANCE.brandName;
    }

    public static String getBrandVersion() {
        return Version.INSTANCE.brandVersion;
    }

    public static String getCodename() {
        return Version.INSTANCE.codename;
    }

    public static String getModuleSlot() {
        return Version.INSTANCE.moduleSlot;
    }

    public static short getMarshallVersion() {
        return Version.INSTANCE.marshallVersion;
    }

    public static String getSchemaVersion() {
        return Version.INSTANCE.schemaVersion;
    }

    public static String getMajorMinor() {
        return Version.INSTANCE.majorMinor;
    }

    public static String getMajor() {
        return Version.INSTANCE.major;
    }

    public static String getMinor() {
        return Version.INSTANCE.minor;
    }

    public static boolean compareTo(byte[] v) {
        return Arrays.equals(Version.INSTANCE.versionId, v);
    }

    public static short getVersionShort() {
        return Version.INSTANCE.versionShort;
    }

    public static short getVersionShort(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString is null");
        }
        String[] parts = Version.getParts(versionString);
        int a = 0;
        int b = 0;
        int c = 0;
        if (parts.length > 0) {
            a = Integer.parseInt(parts[0]);
        }
        if (parts.length > 1) {
            b = Integer.parseInt(parts[1]);
        }
        if (parts.length > 2) {
            c = Integer.parseInt(parts[2]);
        }
        return Version.encodeVersion(a, b, c);
    }

    private static short encodeVersion(int major, int minor, int patch) {
        return (short)((major << 11) + (minor << 6) + patch);
    }

    public static String decodeVersion(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        int patch = version & 0x3F;
        return major + "." + minor + "." + patch;
    }

    public static String decodeVersionForSerialization(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        return major + "." + minor;
    }

    public static void main(String[] args) {
        Version.printFullVersionInformation();
    }

    public static void printFullVersionInformation() {
        System.out.println(Version.INSTANCE.brandName);
        System.out.println();
        System.out.printf("Version: \t%s%n", Version.INSTANCE.brandVersion);
        System.out.printf("Codename: \t%s%n", Version.INSTANCE.codename);
        System.out.println();
    }

    public static String printVersion() {
        return Version.INSTANCE.brandName + " '" + Version.INSTANCE.codename + "' " + Version.INSTANCE.brandVersion;
    }

    private static byte[] readVersionBytes(String major, String minor, String micro, String modifier) {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i < major.length(); ++i) {
            baos.write(major.charAt(i));
        }
        for (i = 0; i < minor.length(); ++i) {
            baos.write(minor.charAt(i));
        }
        for (i = 0; i < micro.length(); ++i) {
            baos.write(micro.charAt(i));
        }
        if ("SNAPSHOT".equals(modifier)) {
            baos.write(83);
        } else {
            for (i = 0; i < modifier.length(); ++i) {
                baos.write(modifier.charAt(i));
            }
        }
        return baos.toByteArray();
    }

    private static String[] getParts(String version) {
        return version.split("[\\.\\-]");
    }
}

