/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EnumSetExternalizer<E extends Enum<E>>
implements Externalizer<EnumSet<E>> {
    public void writeObject(ObjectOutput output, EnumSet<E> set) throws IOException {
        Class<?> enumClass = this.findEnumClass(set);
        output.writeObject(enumClass);
        ?[] enumValues = enumClass.getEnumConstants();
        BitSet values = new BitSet(enumValues.length);
        for (int i = 0; i < enumValues.length; ++i) {
            values.set(i, set.contains(enumValues[i]));
        }
        DefaultExternalizer.BIT_SET.writeObject(output, values);
    }

    public EnumSet<E> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Class enumClass = (Class)input.readObject();
        BitSet values = (BitSet)DefaultExternalizer.BIT_SET.cast(BitSet.class).readObject(input);
        EnumSet<Enum> set = EnumSet.noneOf(enumClass);
        T[] enumValues = enumClass.getEnumConstants();
        for (int i = 0; i < enumValues.length; ++i) {
            if (!values.get(i)) continue;
            set.add((Enum)enumValues[i]);
        }
        return set;
    }

    public Class<EnumSet<E>> getTargetClass() {
        return EnumSet.class;
    }

    private Class<?> findEnumClass(final EnumSet<E> set) {
        EnumSet<E> nonEmptySet = set.isEmpty() ? EnumSet.complementOf(set) : set;
        Iterator values = nonEmptySet.iterator();
        if (values.hasNext()) {
            return ((Enum)values.next()).getDeclaringClass();
        }
        return (Class)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    Field field = EnumSet.class.getDeclaredField("elementType");
                    field.setAccessible(true);
                    return (Class)field.get(set);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

