/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.management;

import org.jboss.as.controller.access.management.AccessConstraintDefinition;

public class AccessConstraintKey {
    private final String type;
    private final boolean core;
    private final String subsystem;
    private final String name;

    public AccessConstraintKey(AccessConstraintDefinition definition) {
        this(definition.getType(), definition.isCore(), definition.getSubsystemName(), definition.getName());
    }

    public AccessConstraintKey(String type, boolean core, String subsystem, String name) {
        this.type = type;
        this.core = core;
        this.subsystem = core ? null : subsystem;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessConstraintKey that = (AccessConstraintKey)o;
        return this.core == that.core && this.name.equals(that.name) && !(this.subsystem == null ? that.subsystem != null : !this.subsystem.equals(that.subsystem)) && this.type.equals(that.type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + this.type + ",core=" + this.core + ",subsystem=" + this.subsystem + ",name=" + this.name + '}';
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.core ? 1 : 0);
        result = 31 * result + (this.subsystem != null ? this.subsystem.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String getType() {
        return this.type;
    }

    public boolean isCore() {
        return this.core;
    }

    public String getSubsystemName() {
        return this.subsystem;
    }

    public String getName() {
        return this.name;
    }
}

