/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.dmr.ModelNode;

class AliasStepHandler
implements OperationStepHandler {
    private final AliasEntry aliasEntry;

    AliasStepHandler(AliasEntry aliasEntry) {
        this.aliasEntry = aliasEntry;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String op = operation.require("operation").asString();
        PathAddress addr = PathAddress.pathAddress(operation.require("address"));
        PathAddress mapped = this.aliasEntry.convertToTargetAddress(addr);
        OperationStepHandler targetHandler = context.getRootResourceRegistration().getOperationHandler(mapped, op);
        if (op == null) {
            throw ControllerMessages.MESSAGES.aliasStepHandlerOperationNotFound(op, addr, mapped);
        }
        ModelNode copy = operation.clone();
        copy.get("address").set(mapped.toModelNode());
        context.addStep(copy, targetHandler, OperationContext.Stage.MODEL, true);
        context.stepCompleted();
    }
}

