/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.impl.ClientConfigurationImpl;
import org.jboss.as.controller.client.impl.RemotingModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public interface ModelControllerClient
extends Closeable {
    public ModelNode execute(ModelNode var1) throws IOException;

    public ModelNode execute(Operation var1) throws IOException;

    public ModelNode execute(ModelNode var1, OperationMessageHandler var2) throws IOException;

    public ModelNode execute(Operation var1, OperationMessageHandler var2) throws IOException;

    public AsyncFuture<ModelNode> executeAsync(ModelNode var1, OperationMessageHandler var2);

    public AsyncFuture<ModelNode> executeAsync(Operation var1, OperationMessageHandler var2);

    public static class Factory {
        public static ModelControllerClient create(InetAddress address, int port) {
            return Factory.create(ClientConfigurationImpl.create(address, port));
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port) {
            return Factory.create(ClientConfigurationImpl.create(protocol, address, port));
        }

        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler) {
            return Factory.create(ClientConfigurationImpl.create(address, port, handler));
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port, CallbackHandler handler) {
            return Factory.create(ClientConfigurationImpl.create(protocol, address, port, handler));
        }

        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return Factory.create(ClientConfigurationImpl.create(address, port, handler, saslOptions));
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return Factory.create(ClientConfigurationImpl.create(protocol, address, port, handler, saslOptions));
        }

        public static ModelControllerClient create(String hostName, int port) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(hostName, port));
        }

        public static ModelControllerClient create(String protocol, String hostName, int port) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(protocol, hostName, port));
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(hostName, port, handler));
        }

        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(protocol, hostName, port, handler));
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(hostName, port, handler, sslContext));
        }

        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(protocol, hostName, port, handler, sslContext));
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(hostName, port, handler, sslContext, connectionTimeout));
        }

        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(protocol, hostName, port, handler, sslContext, connectionTimeout));
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(hostName, port, handler, saslOptions));
        }

        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(ClientConfigurationImpl.create(protocol, hostName, port, handler, saslOptions));
        }

        public static ModelControllerClient create(ModelControllerClientConfiguration configuration) {
            return new RemotingModelControllerClient(configuration);
        }
    }
}

