/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SimpleSessionCreationMetaData;

public class SessionCreationMetaDataEntryMarshaller
implements ProtoStreamMarshaller<SessionCreationMetaDataEntry<Object>> {
    private static final Instant DEFAULT_CREATION_TIME = Instant.EPOCH;
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(30L);
    private static final int CREATION_TIME_INDEX = 1;
    private static final int TIMEOUT_INDEX = 2;

    public SessionCreationMetaDataEntry<Object> readFrom(ProtoStreamReader reader) throws IOException {
        Instant creationTime = DEFAULT_CREATION_TIME;
        Duration timeout = DEFAULT_TIMEOUT;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    creationTime = (Instant)reader.readObject(Instant.class);
                    continue block4;
                }
                case 2: {
                    timeout = (Duration)reader.readObject(Duration.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        SimpleSessionCreationMetaData metaData = new SimpleSessionCreationMetaData(creationTime);
        metaData.setTimeout(timeout);
        return new SessionCreationMetaDataEntry<Object>(metaData);
    }

    public void writeTo(ProtoStreamWriter writer, SessionCreationMetaDataEntry<Object> entry) throws IOException {
        Duration timeout;
        SessionCreationMetaData metaData = entry.getMetaData();
        Instant creationTime = metaData.getCreationTime();
        if (!creationTime.equals(DEFAULT_CREATION_TIME)) {
            writer.writeObject(1, (Object)creationTime);
        }
        if (!(timeout = metaData.getTimeout()).equals(DEFAULT_TIMEOUT)) {
            writer.writeObject(2, (Object)timeout);
        }
    }

    public Class<? extends SessionCreationMetaDataEntry<Object>> getJavaClass() {
        return SessionCreationMetaDataEntry.class;
    }
}

