/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Duration;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;

public class SimpleSessionAccessMetaData
implements SessionAccessMetaData {
    private volatile Duration sinceCreation = Duration.ZERO;
    private volatile Duration lastAccess = Duration.ZERO;

    @Override
    public Duration getSinceCreationDuration() {
        return this.sinceCreation;
    }

    @Override
    public Duration getLastAccessDuration() {
        return this.lastAccess;
    }

    @Override
    public void setLastAccessDuration(Duration sinceCreation, Duration lastAccess) {
        int nano = sinceCreation.getNano();
        this.sinceCreation = nano % 1000000 > 0 ? sinceCreation.withNanos(nano / 1000000 + 1) : sinceCreation;
        this.lastAccess = lastAccess.getNano() > 0 ? Duration.ofSeconds(lastAccess.getSeconds() + 1L) : lastAccess;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('{');
        builder.append("since-creation=").append(this.sinceCreation);
        builder.append("last-access=").append(this.lastAccess);
        return builder.append('}').toString();
    }
}

