/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.io.IOException;
import java.time.Duration;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.web.cache.session.SimpleSessionAccessMetaData;

public class SessionAccessMetaDataMarshaller
implements ProtoStreamMarshaller<SimpleSessionAccessMetaData> {
    private static final Duration DEFAULT_SINCE_CREATION = Duration.ZERO;
    private static final Duration DEFAULT_LAST_ACCESS = Duration.ofSeconds(1L);
    private static final int SINCE_CREATION_INDEX = 1;
    private static final int LAST_ACCESS_INDEX = 2;

    public SimpleSessionAccessMetaData readFrom(ProtoStreamReader reader) throws IOException {
        Duration sinceCreation = DEFAULT_SINCE_CREATION;
        Duration lastAccess = DEFAULT_LAST_ACCESS;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    sinceCreation = (Duration)reader.readObject(Duration.class);
                    continue block4;
                }
                case 2: {
                    lastAccess = (Duration)reader.readObject(Duration.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        SimpleSessionAccessMetaData metaData = new SimpleSessionAccessMetaData();
        metaData.setLastAccessDuration(sinceCreation, lastAccess);
        return metaData;
    }

    public void writeTo(ProtoStreamWriter writer, SimpleSessionAccessMetaData metaData) throws IOException {
        Duration lastAccess;
        Duration sinceCreation = metaData.getSinceCreationDuration();
        if (!sinceCreation.equals(DEFAULT_SINCE_CREATION)) {
            writer.writeObject(1, (Object)sinceCreation);
        }
        if (!(lastAccess = metaData.getLastAccessDuration()).equals(DEFAULT_LAST_ACCESS)) {
            writer.writeObject(2, (Object)lastAccess);
        }
    }

    public Class<? extends SimpleSessionAccessMetaData> getJavaClass() {
        return SimpleSessionAccessMetaData.class;
    }
}

