/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.election;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.function.Predicate;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jboss.as.network.OutboundSocketBinding;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.stack.IpAddress;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;

public class OutboundSocketBindingPreference
implements Predicate<GroupMember> {
    private final OutboundSocketBinding binding;
    private final JChannel channel;

    public OutboundSocketBindingPreference(OutboundSocketBinding binding, JChannel channel) {
        this.binding = binding;
        this.channel = channel;
    }

    @Override
    public boolean test(GroupMember member) {
        Address address;
        IpAddress physicalAddress;
        CacheContainerGroupMember infinispanMember;
        org.infinispan.remoting.transport.Address infinispanAddress;
        if (member instanceof CacheContainerGroupMember && (infinispanAddress = (org.infinispan.remoting.transport.Address)(infinispanMember = (CacheContainerGroupMember)member).getId()) instanceof JGroupsAddress && (physicalAddress = (IpAddress)this.channel.down(new Event(87, (Object)(address = ((JGroupsAddress)infinispanAddress).getJGroupsAddress())))) != null) {
            OutboundSocketBinding binding = this.binding;
            try {
                return binding.getResolvedDestinationAddress().equals(physicalAddress.getIpAddress()) && binding.getDestinationPort() == physicalAddress.getPort();
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return InetSocketAddress.createUnresolved(this.binding.getUnresolvedDestinationAddress(), this.binding.getDestinationPort()).toString();
    }
}

