/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.net;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class InetAddressExternalizer<A extends InetAddress>
implements Externalizer<A> {
    private final Class<A> targetClass;
    private final OptionalInt size;

    public InetAddressExternalizer(Class<A> targetClass, OptionalInt size) {
        this.targetClass = targetClass;
        this.size = size;
    }

    public void writeObject(ObjectOutput output, A address) throws IOException {
        if (!this.size.isPresent()) {
            int length = address != null ? ((InetAddress)address).getAddress().length : 0;
            IndexSerializer.UNSIGNED_BYTE.writeInt(output, length);
        }
        if (address != null) {
            output.write(((InetAddress)address).getAddress());
        }
    }

    public A readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size;
        int n = size = this.size.isPresent() ? this.size.getAsInt() : IndexSerializer.UNSIGNED_BYTE.readInt(input);
        if (size == 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        input.readFully(bytes);
        return (A)((InetAddress)this.targetClass.cast(InetAddress.getByAddress(bytes)));
    }

    public Class<A> getTargetClass() {
        return this.targetClass;
    }

    public OptionalInt size(A address) {
        if (this.size.isPresent()) {
            return this.size;
        }
        int length = address != null ? ((InetAddress)address).getAddress().length : 0;
        return OptionalInt.of(IndexSerializer.UNSIGNED_BYTE.size(length) + length);
    }
}

