/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class FieldSetProtoStreamMarshaller<T, V>
implements ProtoStreamMarshaller<T> {
    private static final int START_INDEX = 1;
    private final Class<T> targetClass;
    private final FieldSetMarshaller<T, V> marshaller;

    public FieldSetProtoStreamMarshaller(FieldSetMarshaller<T, V> marshaller) {
        this(marshaller.build(marshaller.createInitialValue()).getClass(), marshaller);
    }

    public FieldSetProtoStreamMarshaller(Class<T> targetClass, FieldSetMarshaller<T, V> marshaller) {
        this.targetClass = targetClass;
        this.marshaller = marshaller;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<V> valueReader = reader.createFieldSetReader(this.marshaller, 1);
        Object value = this.marshaller.createInitialValue();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (valueReader.contains(index)) {
                value = valueReader.readField(value);
                continue;
            }
            reader.skipField(tag);
        }
        return this.marshaller.build(value);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T value) throws IOException {
        writer.createFieldSetWriter(this.marshaller, 1).writeFields(value);
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

