/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ClassMarshaller;
import org.wildfly.clustering.marshalling.protostream.ObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EnumMapMarshaller<E extends Enum<E>>
implements ProtoStreamMarshaller<EnumMap<E, Object>> {
    public EnumMap<E, Object> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        Class enumClass = (Class)ClassMarshaller.ANY.readFrom(context, reader);
        EnumMap<Enum, Object> map = new EnumMap<Enum, Object>(enumClass);
        BitSet keys = BitSet.valueOf((byte[])AnyField.BYTE_ARRAY.cast(byte[].class).readFrom(context, reader));
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < enumValues.length; ++i) {
            if (!keys.get(i)) continue;
            map.put(enumValues[i], ObjectMarshaller.INSTANCE.readFrom(context, reader));
        }
        return map;
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, EnumMap<E, Object> map) throws IOException {
        Class<?> enumClass = this.findEnumClass(map);
        ClassMarshaller.ANY.writeTo(context, writer, enumClass);
        ?[] enumValues = enumClass.getEnumConstants();
        BitSet keys = new BitSet(enumValues.length);
        for (int i = 0; i < enumValues.length; ++i) {
            keys.set(i, map.containsKey(enumValues[i]));
        }
        AnyField.BYTE_ARRAY.writeTo(context, writer, keys.toByteArray());
        for (Object value : map.values()) {
            ObjectMarshaller.INSTANCE.writeTo(context, writer, value);
        }
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, EnumMap<E, Object> map) {
        Class<?> enumClass = this.findEnumClass(map);
        OptionalInt size = ClassMarshaller.ANY.size(context, enumClass);
        if (size.isPresent()) {
            ?[] enumValues = enumClass.getEnumConstants();
            int bytes = enumValues.length / 8;
            if (enumValues.length % 8 > 0) {
                ++bytes;
            }
            size = OptionalInt.of(size.getAsInt() + bytes + Predictable.unsignedIntSize(bytes));
            for (Object value : map.values()) {
                OptionalInt valueSize = ObjectMarshaller.INSTANCE.size(context, value);
                size = size.isPresent() && valueSize.isPresent() ? OptionalInt.of(size.getAsInt() + valueSize.getAsInt()) : OptionalInt.empty();
            }
        }
        return size;
    }

    public Class<? extends EnumMap<E, Object>> getJavaClass() {
        return EnumMap.class;
    }

    private Class<?> findEnumClass(final EnumMap<E, Object> map) {
        Iterator<E> values = map.keySet().iterator();
        if (values.hasNext()) {
            return ((Enum)values.next()).getDeclaringClass();
        }
        return (Class)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    Field field = EnumMap.class.getDeclaredField("keyType");
                    field.setAccessible(true);
                    return (Class)field.get(map);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

