/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanMetaDataEntry;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.server.offset.OffsetValue;

public class DefaultBeanMetaDataEntryMarshaller
implements ProtoStreamMarshaller<DefaultBeanMetaDataEntry<SessionID>> {
    private static final int NAME_INDEX = 1;
    private static final int GROUP_IDENTIFIER_INDEX = 2;
    private static final int CREATION_TIME_INDEX = 3;
    private static final int LAST_ACCESS_OFFSET_INDEX = 4;
    private static final Instant DEFAULT_CREATION_TIME = Instant.EPOCH;

    public Class<? extends DefaultBeanMetaDataEntry<SessionID>> getJavaClass() {
        return DefaultBeanMetaDataEntry.class;
    }

    public DefaultBeanMetaDataEntry<SessionID> readFrom(ProtoStreamReader reader) throws IOException {
        String name = null;
        SessionID groupId = null;
        Instant creationTime = Instant.EPOCH;
        Offset lastAccessOffset = Offset.forInstant((Duration)Duration.ZERO);
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    name = reader.readString();
                    continue block6;
                }
                case 2: {
                    groupId = (SessionID)reader.readObject(SessionID.class);
                    continue block6;
                }
                case 3: {
                    creationTime = (Instant)reader.readObject(Instant.class);
                    continue block6;
                }
                case 4: {
                    lastAccessOffset = (Offset)reader.readObject(lastAccessOffset.getClass().asSubclass(Offset.class));
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        DefaultBeanMetaDataEntry<Object> entry = new DefaultBeanMetaDataEntry<Object>(name, groupId, creationTime);
        entry.getLastAccessTime().setOffset(lastAccessOffset);
        return entry;
    }

    public void writeTo(ProtoStreamWriter writer, DefaultBeanMetaDataEntry<SessionID> metaData) throws IOException {
        Offset lastAccessOffset;
        OffsetValue<Instant> lastAccess;
        Instant creationTime;
        SessionID groupId;
        String name = metaData.getName();
        if (name != null) {
            writer.writeString(1, name);
        }
        if ((groupId = metaData.getGroupId()) != null) {
            writer.writeObject(2, (Object)groupId);
        }
        if (!DEFAULT_CREATION_TIME.equals(creationTime = (Instant)(lastAccess = metaData.getLastAccessTime()).getBasis())) {
            writer.writeObject(3, (Object)creationTime);
        }
        if (!(lastAccessOffset = lastAccess.getOffset()).isZero()) {
            writer.writeObject(4, (Object)lastAccessOffset);
        }
    }
}

