/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LocalScheduler<T>
implements Scheduler<T, Instant>,
Iterable<T>,
Runnable {
    private final ScheduledExecutorService executor;
    private final ScheduledEntries<T, Instant> entries;
    private final Predicate<T> task;
    private final Duration closeTimeout;
    private volatile Future<?> future = null;

    public LocalScheduler(ScheduledEntries<T, Instant> entries, Predicate<T> task, Duration closeTimeout) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DefaultThreadFactory(this.getClass()));
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.setRemoveOnCancelPolicy(entries.isSorted());
        this.executor = executor;
        this.entries = entries;
        this.task = task;
        this.closeTimeout = closeTimeout;
    }

    public void schedule(T id, Instant instant) {
        this.entries.add(id, instant);
        if (this.entries.isSorted()) {
            this.cancelIfPresent(id);
        }
        this.scheduleIfAbsent();
    }

    public void cancel(T id) {
        if (this.entries.isSorted()) {
            this.cancelIfPresent(id);
        }
        this.entries.remove(id);
        if (this.entries.isSorted()) {
            this.scheduleIfAbsent();
        }
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator entries = this.entries.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public T next() {
                return ((Map.Entry)entries.next()).getKey();
            }

            @Override
            public void remove() {
                entries.remove();
            }

            @Override
            public void forEachRemaining(final Consumer<? super T> action) {
                Consumer entryAction = new Consumer<Map.Entry<T, Instant>>(){

                    @Override
                    public void accept(Map.Entry<T, Instant> entry) {
                        action.accept(entry.getKey());
                    }
                };
                entries.forEachRemaining(entryAction);
            }
        };
    }

    public void close() {
        WildFlySecurityManager.doPrivilegedWithParameter((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        if (!this.closeTimeout.isNegative() && !this.closeTimeout.isZero()) {
            try {
                this.executor.awaitTermination(this.closeTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Iterator entries = this.entries.iterator();
        while (entries.hasNext()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Map.Entry entry = (Map.Entry)entries.next();
            if (((Instant)entry.getValue()).isAfter(Instant.now())) break;
            Object key = entry.getKey();
            if (!this.task.test(key)) continue;
            entries.remove();
        }
        LocalScheduler localScheduler = this;
        synchronized (localScheduler) {
            this.future = this.scheduleFirst();
        }
    }

    private Future<?> scheduleFirst() {
        Map.Entry<T, Instant> entry = this.entries.peek();
        return entry != null ? this.schedule(entry) : null;
    }

    private Future<?> schedule(Map.Entry<T, Instant> entry) {
        Duration delay = Duration.between(Instant.now(), entry.getValue());
        long millis = !delay.isNegative() ? delay.toMillis() + 1L : 0L;
        try {
            return this.executor.schedule(this, millis, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIfAbsent() {
        if (this.future == null) {
            LocalScheduler localScheduler = this;
            synchronized (localScheduler) {
                if (this.future == null) {
                    this.future = this.scheduleFirst();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIfPresent(T id) {
        if (this.future != null) {
            LocalScheduler localScheduler = this;
            synchronized (localScheduler) {
                Map.Entry<T, Instant> entry;
                if (this.future != null && (entry = this.entries.peek()) != null && entry.getKey().equals(id)) {
                    this.future.cancel(true);
                    this.future = null;
                }
            }
        }
    }
}

