/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.subsystem.resource.ResourceModelResolver;

public class PropertiesAttributeDefinition
extends MapAttributeDefinition
implements ResourceModelResolver<Map<String, String>> {
    private final Consumer<ModelNode> descriptionContributor = node -> {
        node.get("value-type").set(ModelType.STRING);
        node.get("expressions-allowed").set(new ModelNode(this.isAllowExpression()));
    };
    static final AttributeMarshaller MARSHALLER = new AttributeMarshaller(){

        public boolean isMarshallableAsElement() {
            return true;
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode model, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (model.hasDefined(attribute.getName())) {
                for (Property property : model.get(attribute.getName()).asPropertyList()) {
                    writer.writeStartElement(Element.PROPERTY.getLocalName());
                    writer.writeAttribute(Element.NAME.getLocalName(), property.getName());
                    AttributeMarshaller.marshallElementContent((String)property.getValue().asString(), (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
        }
    };
    static final AttributeParser PARSER = new AttributeParser(){

        public boolean isParseAsElement() {
            return true;
        }

        public XMLCardinality getCardinality(AttributeDefinition attribute) {
            return attribute.isRequired() ? XMLCardinality.Unbounded.REQUIRED : XMLCardinality.Unbounded.OPTIONAL;
        }

        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof MapAttributeDefinition);
            String name = reader.getAttributeValue(null, "name");
            ((MapAttributeDefinition)attribute).parseAndAddParameterElement(name, reader.getElementText(), operation, reader);
        }
    };

    PropertiesAttributeDefinition(Builder builder) {
        super((MapAttributeDefinition.Builder)builder);
    }

    public Map<String, String> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        List properties = this.resolveModelAttribute(context, model).asPropertyListOrEmpty();
        if (properties.isEmpty()) {
            return Map.of();
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Property property : properties) {
            result.put(property.getName(), property.getValue().asString());
        }
        return result;
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        this.descriptionContributor.accept(node);
    }

    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.descriptionContributor.accept(node);
    }

    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.descriptionContributor.accept(node);
    }

    public static class Builder
    extends MapAttributeDefinition.Builder<Builder, PropertiesAttributeDefinition> {
        public Builder() {
            this("properties");
        }

        public Builder(String name) {
            super(name);
            this.setXmlName(Element.PROPERTY.getLocalName());
            this.setRequired(false);
            this.setAllowExpression(true);
            this.setAllowNullElement(false);
            this.setAttributeMarshaller(MARSHALLER);
            this.setAttributeParser(PARSER);
            this.setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
        }

        public Builder(String name, PropertiesAttributeDefinition basis) {
            super(name, (MapAttributeDefinition)basis);
        }

        public PropertiesAttributeDefinition build() {
            if (this.elementValidator == null) {
                this.elementValidator = new ModelTypeValidator(ModelType.STRING, this.isNillable(), this.isAllowExpression());
            }
            return new PropertiesAttributeDefinition(this);
        }
    }
}

