/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Arrays;
import org.jboss.as.clustering.MarshalledValue;
import org.jboss.as.clustering.MarshallingContext;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.SimpleDataInput;
import org.jboss.marshalling.SimpleDataOutput;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SimpleMarshalledValue<T>
implements MarshalledValue<T, MarshallingContext>,
Externalizable {
    private static final long serialVersionUID = -8852566958387608376L;
    private volatile transient MarshallingContext context;
    private volatile transient T object;
    private volatile transient byte[] bytes;

    public SimpleMarshalledValue(T object, MarshallingContext context) {
        this.context = context;
        this.object = object;
    }

    public SimpleMarshalledValue() {
    }

    T peek() {
        return this.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes() throws IOException {
        byte[] bytes = this.bytes;
        if (bytes != null) {
            return bytes;
        }
        if (this.object == null) {
            return null;
        }
        int version = this.context.getCurrentVersion();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SimpleDataOutput data = new SimpleDataOutput(Marshalling.createByteOutput((OutputStream)output));
        data.writeInt(version);
        try (Marshaller marshaller = this.context.createMarshaller(version);){
            marshaller.start((ByteOutput)data);
            ClassLoader currentLoader = null;
            ClassLoader contextLoader = this.context.getContextClassLoader(version);
            if (contextLoader != null) {
                currentLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)contextLoader);
            }
            try {
                marshaller.writeObject(this.object);
            }
            finally {
                if (contextLoader != null) {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)currentLoader);
                }
            }
            marshaller.finish();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T get(MarshallingContext context) throws IOException, ClassNotFoundException {
        if (this.object == null) {
            this.context = context;
            if (this.bytes != null) {
                ByteArrayInputStream input = new ByteArrayInputStream(this.bytes);
                SimpleDataInput data = new SimpleDataInput(Marshalling.createByteInput((InputStream)input));
                int version = data.readInt();
                try (Unmarshaller unmarshaller = context.createUnmarshaller(version);){
                    unmarshaller.start((ByteInput)data);
                    ClassLoader currentLoader = null;
                    ClassLoader contextLoader = context.getContextClassLoader(version);
                    if (contextLoader != null) {
                        currentLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)contextLoader);
                    }
                    try {
                        this.object = unmarshaller.readObject();
                    }
                    finally {
                        if (contextLoader != null) {
                            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)currentLoader);
                        }
                    }
                    unmarshaller.finish();
                    this.bytes = null;
                }
            }
        }
        return this.object;
    }

    public int hashCode() {
        return this.object != null ? this.object.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SimpleMarshalledValue)) {
            return false;
        }
        SimpleMarshalledValue value = (SimpleMarshalledValue)object;
        if (this.object != null && value.object != null) {
            return this.object.equals(value.object);
        }
        try {
            byte[] us = this.getBytes();
            byte[] them = value.getBytes();
            return us != null && them != null ? Arrays.equals(us, them) : us == them;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        if (this.object != null) {
            return this.object.toString();
        }
        byte[] bytes = this.bytes;
        return bytes != null ? bytes.toString() : null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] bytes = this.getBytes();
        if (bytes != null) {
            out.writeInt(bytes.length);
            out.write(bytes);
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        byte[] bytes = null;
        if (size > 0) {
            bytes = new byte[size];
            in.read(bytes);
        }
        this.bytes = bytes;
    }
}

