/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.Marshaller;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.transaction.ClientHandlers;
import org.wildfly.httpclient.transaction.Constants;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionMessages;
import org.wildfly.httpclient.transaction.RequestBuilder;
import org.wildfly.httpclient.transaction.RequestType;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

class HttpSubordinateTransactionHandle
implements SubordinateTransactionControl {
    private final HttpTargetContext targetContext;
    private final Xid id;
    private final SSLContext sslContext;
    private final AuthenticationConfiguration authenticationConfiguration;

    HttpSubordinateTransactionHandle(Xid id, HttpTargetContext targetContext, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration) {
        this.id = id;
        this.targetContext = targetContext;
        this.sslContext = sslContext;
        this.authenticationConfiguration = authenticationConfiguration;
    }

    Xid getId() {
        return this.id;
    }

    @Override
    public void commit(boolean onePhase) throws XAException {
        this.processOperation(RequestType.XA_COMMIT, null, onePhase ? Boolean.TRUE : null);
    }

    @Override
    public void rollback() throws XAException {
        this.processOperation(RequestType.XA_ROLLBACK);
    }

    @Override
    public void end(int flags) throws XAException {
    }

    @Override
    public void beforeCompletion() throws XAException {
        this.processOperation(RequestType.XA_BEFORE_COMPLETION);
    }

    @Override
    public int prepare() throws XAException {
        boolean readOnly = this.processOperation(RequestType.XA_PREPARE, result -> {
            String header = HeadersHelper.getResponseHeader(result, Constants.READ_ONLY);
            return Boolean.parseBoolean(header);
        }, null);
        return readOnly ? 3 : 0;
    }

    @Override
    public void forget() throws XAException {
        this.processOperation(RequestType.XA_FORGET);
    }

    private void processOperation(RequestType requestType) throws XAException {
        this.processOperation(requestType, null, null);
    }

    private <T> T processOperation(RequestType requestType, Function<ClientResponse, T> resultFunction, Boolean onePhase) throws XAException {
        RequestBuilder builder = new RequestBuilder().setRequestType(requestType).setVersion(this.targetContext.getProtocolVersion()).setOnePhase(onePhase);
        ClientRequest request = builder.createRequest(this.targetContext.getUri().getPath());
        CompletableFuture result = new CompletableFuture();
        HttpMarshallerFactory marshallerFactory = this.targetContext.getHttpMarshallerFactory(request);
        Marshaller marshaller = marshallerFactory.createMarshaller(result);
        if (marshaller != null) {
            this.targetContext.sendRequest(request, this.sslContext, this.authenticationConfiguration, ClientHandlers.xidHttpMarshaller(marshaller, this.id), ClientHandlers.emptyHttpResultHandler(result, resultFunction), result::completeExceptionally, null, null);
        }
        try {
            try {
                return result.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HttpRemoteTransactionMessages.MESSAGES.interruptedXA(-3);
            }
        }
        catch (ExecutionException e) {
            try {
                throw e.getCause();
            }
            catch (XAException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                XAException xaException = new XAException(-3);
                xaException.initCause(ex);
                throw xaException;
            }
        }
    }
}

