/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.client;

import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;

public final class ClientRequestor
implements AutoCloseable {
    private final ClientSession queueSession;
    private final ClientProducer requestProducer;
    private final ClientConsumer replyConsumer;
    private final SimpleString replyQueue;

    public ClientRequestor(ClientSession session, SimpleString requestAddress) throws Exception {
        this.queueSession = session;
        this.requestProducer = this.queueSession.createProducer(requestAddress);
        this.replyQueue = SimpleString.of(String.valueOf(requestAddress) + "." + String.valueOf(UUID.randomUUID()));
        this.queueSession.createQueue(QueueConfiguration.of(this.replyQueue).setDurable(false).setTemporary(true));
        this.replyConsumer = this.queueSession.createConsumer(this.replyQueue);
    }

    public ClientRequestor(ClientSession session, String requestAddress) throws Exception {
        this(session, SimpleString.of(requestAddress));
    }

    public ClientMessage request(ClientMessage request) throws Exception {
        return this.request(request, 0L);
    }

    public ClientMessage request(ClientMessage request, long timeout) throws Exception {
        request.putStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME, this.replyQueue);
        this.requestProducer.send(request);
        return this.replyConsumer.receive(timeout);
    }

    @Override
    public void close() throws Exception {
        this.replyConsumer.close();
        this.requestProducer.close();
        this.queueSession.deleteQueue(this.replyQueue);
    }
}

