/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;
import org.wildfly.common.Assert;
import org.wildfly.security.key.RSAParameterSpec;
import org.wildfly.security.key.RawDHPrivateKey;
import org.wildfly.security.key.RawDSAPrivateKey;
import org.wildfly.security.key.RawECPrivateKey;
import org.wildfly.security.key.RawPBEKey;
import org.wildfly.security.key.RawRSAMultiPrimePrivateCrtKey;
import org.wildfly.security.key.RawRSAPrivateKey;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.MaskedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.OneTimePasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public final class KeyUtil {
    private static final KeyClonerCreator CLONER_CREATOR = new KeyClonerCreator();

    private KeyUtil() {
    }

    public static AlgorithmParameterSpec getParameters(Key key) {
        return KeyUtil.getParameters(key, AlgorithmParameterSpec.class);
    }

    public static <P extends AlgorithmParameterSpec> P getParameters(Key key, Class<P> paramSpecClass) {
        if (key instanceof Password) {
            AlgorithmParameterSpec parameterSpec = ((Password)key).getParameterSpec();
            return (P)(paramSpecClass.isInstance(parameterSpec) ? (AlgorithmParameterSpec)paramSpecClass.cast(parameterSpec) : null);
        }
        if (key instanceof RSAKey && paramSpecClass.isAssignableFrom(RSAParameterSpec.class)) {
            return (P)((AlgorithmParameterSpec)paramSpecClass.cast(new RSAParameterSpec((RSAKey)((Object)key))));
        }
        if (key instanceof DSAKey && paramSpecClass.isAssignableFrom(DSAParams.class)) {
            DSAKey dsaKey = (DSAKey)((Object)key);
            DSAParams dsaParams = dsaKey.getParams();
            return (P)((AlgorithmParameterSpec)paramSpecClass.cast(new DSAParameterSpec(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG())));
        }
        if (key instanceof ECKey && paramSpecClass.isAssignableFrom(ECParameterSpec.class)) {
            return (P)((AlgorithmParameterSpec)paramSpecClass.cast(((ECKey)((Object)key)).getParams()));
        }
        if (key instanceof DHKey && paramSpecClass.isAssignableFrom(DHParameterSpec.class)) {
            return (P)((AlgorithmParameterSpec)paramSpecClass.cast(((DHKey)((Object)key)).getParams()));
        }
        if (key instanceof PBEKey && paramSpecClass.isAssignableFrom(PBEParameterSpec.class)) {
            PBEKey pbeKey = (PBEKey)key;
            byte[] salt = pbeKey.getSalt();
            return (P)(salt == null ? null : (AlgorithmParameterSpec)paramSpecClass.cast(new PBEParameterSpec(salt, pbeKey.getIterationCount())));
        }
        return null;
    }

    public static boolean hasParameters(Key key, AlgorithmParameterSpec parameters) {
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("parameters", parameters);
        AlgorithmParameterSpec keyParameters = KeyUtil.getParameters(key, AlgorithmParameterSpec.class);
        return keyParameters != null && KeyUtil.parametersEqual(keyParameters, parameters);
    }

    public static boolean parametersEqual(AlgorithmParameterSpec p1, AlgorithmParameterSpec p2) {
        Assert.checkNotNullParam("p1", p1);
        Assert.checkNotNullParam("p2", p2);
        if (p1 instanceof DSAParams && p2 instanceof DSAParams) {
            DSAParams dsa1 = (DSAParams)((Object)p1);
            DSAParams dsa2 = (DSAParams)((Object)p2);
            return Objects.equals(dsa1.getG(), dsa2.getG()) && Objects.equals(dsa1.getP(), dsa2.getP()) && Objects.equals(dsa1.getQ(), dsa2.getQ());
        }
        if (p1 instanceof ECParameterSpec && p2 instanceof ECParameterSpec) {
            ECParameterSpec ec1 = (ECParameterSpec)p1;
            ECParameterSpec ec2 = (ECParameterSpec)p2;
            return ec1.getCofactor() == ec2.getCofactor() && Objects.equals(ec1.getCurve(), ec2.getCurve()) && Objects.equals(ec1.getGenerator(), ec2.getGenerator()) && Objects.equals(ec1.getOrder(), ec2.getOrder());
        }
        if (p1 instanceof DHParameterSpec && p2 instanceof DHParameterSpec) {
            DHParameterSpec dh1 = (DHParameterSpec)p1;
            DHParameterSpec dh2 = (DHParameterSpec)p2;
            return dh1.getL() == dh2.getL() && Objects.equals(dh1.getP(), dh2.getP()) && Objects.equals(dh1.getG(), dh2.getG());
        }
        if (p1 instanceof PBEParameterSpec && p2 instanceof PBEParameterSpec) {
            PBEParameterSpec pbe1 = (PBEParameterSpec)p1;
            PBEParameterSpec pbe2 = (PBEParameterSpec)p2;
            AlgorithmParameterSpec param1 = pbe1.getParameterSpec();
            AlgorithmParameterSpec param2 = pbe2.getParameterSpec();
            return pbe1.getIterationCount() == pbe2.getIterationCount() && Arrays.equals(pbe1.getSalt(), pbe2.getSalt()) && (param1 == null ? param2 == null : param2 != null && KeyUtil.parametersEqual(param1, param2));
        }
        if (p1 instanceof IvParameterSpec && p2 instanceof IvParameterSpec) {
            IvParameterSpec iv1 = (IvParameterSpec)p1;
            IvParameterSpec iv2 = (IvParameterSpec)p2;
            return Arrays.equals(iv1.getIV(), iv2.getIV());
        }
        return p1.equals(p2);
    }

    public static int parametersHashCode(AlgorithmParameterSpec param) {
        if (param == null) {
            return 0;
        }
        if (param instanceof DSAParams) {
            DSAParams dsaParams = (DSAParams)((Object)param);
            return Objects.hash(dsaParams.getG(), dsaParams.getP(), dsaParams.getQ());
        }
        if (param instanceof ECParameterSpec) {
            ECParameterSpec ecSpec = (ECParameterSpec)param;
            return ecSpec.getCofactor() * 31 + Objects.hash(ecSpec.getCurve(), ecSpec.getGenerator(), ecSpec.getOrder());
        }
        if (param instanceof DHParameterSpec) {
            DHParameterSpec dhSpec = (DHParameterSpec)param;
            return dhSpec.getL() * 31 + Objects.hash(dhSpec.getP(), dhSpec.getG());
        }
        if (param instanceof PBEParameterSpec) {
            PBEParameterSpec pbeSpec = (PBEParameterSpec)param;
            AlgorithmParameterSpec parameterSpec = pbeSpec.getParameterSpec();
            return (pbeSpec.getIterationCount() * 31 + Arrays.hashCode(pbeSpec.getSalt())) * 31 + KeyUtil.parametersHashCode(parameterSpec);
        }
        if (param instanceof IvParameterSpec) {
            return Arrays.hashCode(((IvParameterSpec)param).getIV());
        }
        if (param instanceof RSAParameterSpec || param instanceof IteratedSaltedPasswordAlgorithmSpec || param instanceof IteratedPasswordAlgorithmSpec || param instanceof SaltedPasswordAlgorithmSpec || param instanceof DigestPasswordAlgorithmSpec || param instanceof MaskedPasswordAlgorithmSpec || param instanceof OneTimePasswordAlgorithmSpec) {
            return param.hashCode();
        }
        return param.getClass().hashCode();
    }

    public static boolean hasSameParameters(Key key1, Key key2) {
        Assert.checkNotNullParam("key1", key1);
        Assert.checkNotNullParam("key2", key2);
        AlgorithmParameterSpec param1 = KeyUtil.getParameters(key1, AlgorithmParameterSpec.class);
        AlgorithmParameterSpec param2 = KeyUtil.getParameters(key2, AlgorithmParameterSpec.class);
        return param1 == null && param2 == null || param1 != null && param2 != null && KeyUtil.parametersEqual(param1, param2);
    }

    public static <T extends Key> T cloneKey(Class<T> expectType, T key) {
        Assert.checkNotNullParam("expectType", expectType);
        if (key instanceof Destroyable) {
            if (((Destroyable)((Object)key)).isDestroyed()) {
                return (T)((Key)expectType.cast(key));
            }
            return (T)((Key)expectType.cast(((UnaryOperator)CLONER_CREATOR.get(key.getClass())).apply(key)));
        }
        return (T)((Key)expectType.cast(key));
    }

    private static class KeyClonerCreator
    extends ClassValue<UnaryOperator<Key>> {
        private KeyClonerCreator() {
        }

        @Override
        protected UnaryOperator<Key> computeValue(Class<?> type) {
            Method method;
            try {
                method = type.getMethod("destroy", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return UnaryOperator.identity();
            }
            if (method.getDeclaringClass() == Destroyable.class) {
                return UnaryOperator.identity();
            }
            UnaryOperator<Key> op = this.checkForCloneMethod(type, type);
            if (op != null) {
                return op;
            }
            op = this.checkForCopyCtor(type, type);
            if (op != null) {
                return op;
            }
            if (PrivateKey.class.isAssignableFrom(type)) {
                if (DSAPrivateKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, DSAPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, DSAPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawDSAPrivateKey::new;
                }
                if (ECPrivateKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, ECPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, ECPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawECPrivateKey::new;
                }
                if (RSAMultiPrimePrivateCrtKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, RSAMultiPrimePrivateCrtKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, RSAMultiPrimePrivateCrtKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawRSAMultiPrimePrivateCrtKey::new;
                }
                if (RSAPrivateKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, RSAPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, RSAPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawRSAPrivateKey::new;
                }
                if (DHPrivateKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, DHPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, DHPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawDHPrivateKey::new;
                }
                op = this.checkForCloneMethod(type, PrivateKey.class);
                if (op != null) {
                    return op;
                }
                op = this.checkForCopyCtor(type, PrivateKey.class);
                if (op != null) {
                    return op;
                }
            } else {
                if (SecretKey.class.isAssignableFrom(type)) {
                    if (PBEKey.class.isAssignableFrom(type)) {
                        op = this.checkForCloneMethod(type, PBEKey.class);
                        if (op != null) {
                            return op;
                        }
                        op = this.checkForCopyCtor(type, PBEKey.class);
                        if (op != null) {
                            return op;
                        }
                        return RawPBEKey::new;
                    }
                    op = this.checkForCloneMethod(type, SecretKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, SecretKey.class);
                    if (op != null) {
                        return op;
                    }
                    return orig -> new SecretKeySpec(orig.getEncoded(), orig.getAlgorithm());
                }
                op = this.checkForCloneMethod(type, Key.class);
                if (op != null) {
                    return op;
                }
            }
            return orig -> {
                throw Assert.unsupported();
            };
        }

        private UnaryOperator<Key> checkForCloneMethod(Class<?> declType, Class<?> returnType) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handle = AccessController.doPrivileged(() -> {
                try {
                    return lookup.findVirtual(declType, "clone", MethodType.methodType(returnType));
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    return null;
                }
            });
            return handle == null ? null : KeyClonerCreator.produceOp(handle);
        }

        private UnaryOperator<Key> checkForCopyCtor(Class<?> declType, Class<?> paramType) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handle = AccessController.doPrivileged(() -> {
                try {
                    return lookup.findConstructor(declType, MethodType.methodType(Void.TYPE, paramType));
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    return null;
                }
            });
            return handle == null ? null : KeyClonerCreator.produceOp(handle);
        }

        private static UnaryOperator<Key> produceOp(MethodHandle handle) {
            return original -> {
                try {
                    return handle.invoke((Key)original);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new UndeclaredThrowableException(throwable);
                }
            };
        }
    }
}

