/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.StoppedExecutorException;

@MessageLogger(projectCode="JBTHR", length=5)
interface Messages
extends BasicLogger {
    public static final Messages msg = Logger.getMessageLogger(MethodHandles.lookup(), Messages.class, "org.jboss.threads");
    public static final Messages intMsg = Logger.getMessageLogger(MethodHandles.lookup(), Messages.class, "org.jboss.threads.interrupt-handler");

    @Message(value="JBoss Threads version %s")
    @LogMessage(level=Logger.Level.INFO)
    public void version(String var1);

    @Message(id=3, value="Operation timed out")
    public TimeoutException operationTimedOut();

    @Message(id=4, value="Operation was cancelled")
    public CancellationException operationCancelled();

    @Message(id=5, value="Operation failed")
    public ExecutionException operationFailed(@Cause Throwable var1);

    @Message(id=9, value="Executor has been shut down")
    public StoppedExecutorException shutDownInitiated();

    @Message(id=12, value="Cannot await termination of a thread pool from one of its own threads")
    public IllegalStateException cannotAwaitWithin();

    @Message(id=103, value="The current thread does not support interrupt handlers")
    public IllegalStateException noInterruptHandlers();

    @Message(id=108, value="Interrupt handler %s threw an exception")
    @LogMessage(level=Logger.Level.ERROR)
    public void interruptHandlerThrew(@Cause Throwable var1, InterruptHandler var2);

    @Message(id=109, value="Keep-alive time must be positive but was %s")
    public IllegalArgumentException nonPositiveKeepAlive(Duration var1);

    @Message(id=200, value="%s() not allowed on container-managed executor")
    public SecurityException notAllowedContainerManaged(String var1);
}

