/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.common.Assert;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.CreationListener;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client._private.Log;

public final class ContextTransactionManager
implements TransactionManager {
    static final ContextTransactionManager INSTANCE = new ContextTransactionManager();
    private static final AtomicInteger defaultTimeoutRef = new AtomicInteger(300);
    private static final TransactionPermission SET_TIMEOUT_PERMISSION = TransactionPermission.forName("setGlobalDefaultTransactionTimeout");
    final ThreadLocal<State> stateRef = ThreadLocal.withInitial(State::new);

    private ContextTransactionManager() {
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.begin(CreationListener.CreatedBy.TRANSACTION_MANAGER);
    }

    void begin(CreationListener.CreatedBy createdBy) throws NotSupportedException, SystemException {
        State state = this.stateRef.get();
        if (state.transaction != null) {
            throw Log.log.nestedNotSupported();
        }
        this.resume(LocalTransactionContext.getCurrent().beginTransaction(state.getTimeout(), false, createdBy));
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        State state = this.stateRef.get();
        try {
            if (state.transaction == null) {
                throw Log.log.noTransaction();
            }
            state.transaction.commitAndDissociate();
        }
        finally {
            state.transaction = null;
        }
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        State state = this.stateRef.get();
        try {
            if (state.transaction == null) {
                throw Log.log.noTransaction();
            }
            state.transaction.rollbackAndDissociate();
        }
        finally {
            state.transaction = null;
        }
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        State state = this.stateRef.get();
        if (state.transaction == null) {
            throw Log.log.noTransaction();
        }
        state.transaction.setRollbackOnly();
    }

    @Override
    public int getStatus() throws SystemException {
        State state = this.stateRef.get();
        return state == null || state.transaction == null ? 6 : state.transaction.getStatus();
    }

    @Override
    public AbstractTransaction getTransaction() {
        AbstractTransaction transaction = this.stateRef.get().transaction;
        if (transaction != null) {
            transaction.verifyAssociation();
        }
        return transaction;
    }

    @Override
    public void setTransactionTimeout(int timeout) {
        Assert.checkMinimumParameter("timeout", 0, timeout);
        this.stateRef.get().setTimeout(timeout);
    }

    public int getTransactionTimeout() {
        return this.stateRef.get().getTimeout();
    }

    public int getConfiguredTransactionTimeout() {
        return this.stateRef.get().getConfiguredTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractTransaction suspend() throws SystemException {
        State state = this.stateRef.get();
        AbstractTransaction transaction = state.transaction;
        if (transaction == null) {
            return null;
        }
        try {
            transaction.suspend();
            AbstractTransaction abstractTransaction = transaction;
            return abstractTransaction;
        }
        finally {
            state.transaction = null;
        }
    }

    @Override
    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction != null && !(transaction instanceof AbstractTransaction)) {
            throw Log.log.notSupportedTransaction(transaction);
        }
        this.resume((AbstractTransaction)transaction);
    }

    void resume(AbstractTransaction transaction) throws IllegalStateException, SystemException {
        State state = this.stateRef.get();
        if (state.transaction != null) {
            throw Log.log.alreadyAssociated();
        }
        state.transaction = transaction;
        if (transaction != null) {
            try {
                transaction.resume();
            }
            catch (Throwable t) {
                state.transaction = null;
                throw t;
            }
        }
    }

    boolean isAvailable() {
        return this.stateRef.get().available;
    }

    boolean setAvailable(boolean available) {
        this.stateRef.get().available = available;
        return this.stateRef.get().available;
    }

    public static ContextTransactionManager getInstance() {
        return INSTANCE;
    }

    public static int getGlobalDefaultTransactionTimeout() {
        return defaultTimeoutRef.get();
    }

    public static int setGlobalDefaultTransactionTimeout(int newTimeout) {
        Assert.checkMinimumParameter("newTimeout", 1, newTimeout);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_TIMEOUT_PERMISSION);
        }
        return defaultTimeoutRef.getAndSet(newTimeout);
    }

    public static int setMinimumGlobalDefaultTransactionTimeout(int minimumTimeout) {
        Assert.checkMinimumParameter("minimumTimeout", 1, minimumTimeout);
        int oldVal = defaultTimeoutRef.get();
        if (oldVal >= minimumTimeout) {
            return oldVal;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_TIMEOUT_PERMISSION);
        }
        while (!defaultTimeoutRef.compareAndSet(oldVal, minimumTimeout) && oldVal < minimumTimeout) {
            oldVal = defaultTimeoutRef.get();
        }
        return oldVal;
    }

    public static int setMaximumGlobalDefaultTransactionTimeout(int maximumTimeout) {
        Assert.checkMinimumParameter("maximumTimeout", 1, maximumTimeout);
        int oldVal = defaultTimeoutRef.get();
        if (oldVal <= maximumTimeout) {
            return oldVal;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_TIMEOUT_PERMISSION);
        }
        while (!defaultTimeoutRef.compareAndSet(oldVal, maximumTimeout) && oldVal > maximumTimeout) {
            oldVal = defaultTimeoutRef.get();
        }
        return oldVal;
    }

    ThreadLocal<State> getStateRef() {
        return this.stateRef;
    }

    static final class State {
        AbstractTransaction transaction;
        private int timeout = 0;
        boolean available = true;

        State() {
        }

        int getConfiguredTimeout() {
            return this.timeout;
        }

        int getTimeout() {
            int timeout = this.timeout;
            return timeout == 0 ? defaultTimeoutRef.get() : timeout;
        }

        void setTimeout(int timeout) {
            this.timeout = timeout;
        }
    }
}

