/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.uri.AbstractCFSchema;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.uri.schema.connector.TCPTransportConfigurationSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.TCPServerLocatorSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.jboss.logging.Logger;

public class TCPSchema
extends AbstractCFSchema {
    private static final Logger logger = Logger.getLogger(TCPSchema.class);

    @Override
    public String getSchemaName() {
        return "tcp";
    }

    @Override
    protected ActiveMQConnectionFactory internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        JMSConnectionOptions options = this.newConectionOptions(uri, query);
        List<TransportConfiguration> configurations = TCPTransportConfigurationSchema.getTransportConfigurations(uri, query, TransportConstants.ALLOWABLE_CONNECTOR_KEYS, name, NettyConnectorFactory.class.getName());
        TransportConfiguration[] tcs = new TransportConfiguration[configurations.size()];
        configurations.toArray(tcs);
        ActiveMQConnectionFactory factory = options.isHa() ? ActiveMQJMSClient.createConnectionFactoryWithHA(options.getFactoryTypeEnum(), tcs) : ActiveMQJMSClient.createConnectionFactoryWithoutHA(options.getFactoryTypeEnum(), tcs);
        this.setData(uri, query, factory);
        this.checkIgnoredQueryFields(factory, query);
        return factory;
    }

    @Override
    protected void internalPopulateObject(URI uri, Map<String, String> query, ActiveMQConnectionFactory bean) throws Exception {
        super.internalPopulateObject(uri, query, bean);
        this.checkIgnoredQueryFields(bean, query);
    }

    private void checkIgnoredQueryFields(ActiveMQConnectionFactory factory, Map<String, String> query) throws Exception {
        Properties factoryProperties = new Properties();
        BeanSupport.getProperties(factory, factoryProperties);
        for (String key : query.keySet()) {
            if (key.equals("ha") || key.equals("type") || TransportConstants.ALLOWABLE_CONNECTOR_KEYS.contains(key) || factoryProperties.containsKey(key)) continue;
            logger.debugf("Connection factory parameter %s is not standard", (Object)key);
        }
    }

    @Override
    protected URI internalNewURI(ActiveMQConnectionFactory bean) throws Exception {
        String query = BeanSupport.getData(null, bean);
        TransportConfiguration[] staticConnectors = bean.getStaticConnectors();
        return TCPServerLocatorSchema.getURI(query, staticConnectors);
    }
}

