/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.apache.activemq.artemis.utils.AbstractByteBufPool;
import org.apache.activemq.artemis.utils.ByteUtil;

public class TypedProperties {
    private Map<SimpleString, PropertyValue> properties;
    private int size;
    private final Predicate<SimpleString> internalPropertyPredicate;
    private boolean internalProperties;

    public TypedProperties() {
        this.internalPropertyPredicate = null;
    }

    public TypedProperties(Predicate<SimpleString> internalPropertyPredicate) {
        this.internalPropertyPredicate = internalPropertyPredicate;
    }

    public synchronized int size() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public synchronized int getMemoryOffset() {
        return this.properties == null ? 0 : this.size + 8 * this.properties.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedProperties(TypedProperties other) {
        TypedProperties typedProperties = other;
        synchronized (typedProperties) {
            this.properties = other.properties == null ? null : new HashMap<SimpleString, PropertyValue>(other.properties);
            this.size = other.size;
            this.internalPropertyPredicate = other.internalPropertyPredicate;
            this.internalProperties = other.internalProperties;
        }
    }

    public void putBooleanProperty(SimpleString key, boolean value) {
        this.doPutValue(key, BooleanValue.of(value));
    }

    public void putByteProperty(SimpleString key, byte value) {
        this.doPutValue(key, ByteValue.valueOf(value));
    }

    public void putBytesProperty(SimpleString key, byte[] value) {
        this.doPutValue(key, value == null ? NullValue.INSTANCE : new BytesValue(value));
    }

    public void putShortProperty(SimpleString key, short value) {
        this.doPutValue(key, new ShortValue(value));
    }

    public void putIntProperty(SimpleString key, int value) {
        this.doPutValue(key, new IntValue(value));
    }

    public void putLongProperty(SimpleString key, long value) {
        this.doPutValue(key, new LongValue(value));
    }

    public void putFloatProperty(SimpleString key, float value) {
        this.doPutValue(key, new FloatValue(value));
    }

    public void putDoubleProperty(SimpleString key, double value) {
        this.doPutValue(key, new DoubleValue(value));
    }

    public void putSimpleStringProperty(SimpleString key, SimpleString value) {
        this.doPutValue(key, value == null ? NullValue.INSTANCE : new StringValue(value));
    }

    public void putNullValue(SimpleString key) {
        this.doPutValue(key, NullValue.INSTANCE);
    }

    public void putCharProperty(SimpleString key, char value) {
        this.doPutValue(key, new CharValue(value));
    }

    public void putTypedProperties(TypedProperties otherProps) {
        if (otherProps == null || otherProps == this || otherProps.properties == null) {
            return;
        }
        otherProps.forEachInternal(this::doPutValue);
    }

    public TypedProperties putProperty(SimpleString key, Object value) {
        TypedProperties.setObjectProperty(key, value, this);
        return this;
    }

    public Object getProperty(SimpleString key) {
        return this.doGetProperty(key);
    }

    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof SimpleString) {
            return Boolean.valueOf(((SimpleString)value).toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Byte.valueOf(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof SimpleString) {
            return Byte.parseByte(((SimpleString)value).toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public Character getCharProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            throw new NullPointerException("Invalid conversion: " + key);
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Double.valueOf(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof SimpleString) {
            return Double.parseDouble(((SimpleString)value).toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Integer.valueOf(null);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof SimpleString) {
            return Integer.parseInt(((SimpleString)value).toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Long.valueOf(null);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof SimpleString) {
            return Long.parseLong(((SimpleString)value).toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Short.valueOf(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof SimpleString) {
            return Short.parseShort(((SimpleString)value).toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Float.valueOf(null);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof SimpleString) {
            return Float.valueOf(Float.parseFloat(((SimpleString)value).toString()));
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return null;
        }
        if (value instanceof SimpleString) {
            return (SimpleString)value;
        }
        if (value instanceof Boolean) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Character) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Byte) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Short) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Integer) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Long) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Float) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Double) {
            return new SimpleString(value.toString());
        }
        throw new ActiveMQPropertyConversionException("Invalid conversion: " + key);
    }

    public Object removeProperty(SimpleString key) {
        return this.doRemoveProperty(key);
    }

    public synchronized boolean containsProperty(SimpleString key) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(key);
    }

    public synchronized Set<SimpleString> getPropertyNames() {
        if (this.properties == null) {
            return Collections.emptySet();
        }
        return new HashSet<SimpleString>(this.properties.keySet());
    }

    public synchronized boolean clearInternalProperties() {
        return this.internalProperties && this.removeInternalProperties();
    }

    private synchronized boolean removeInternalProperties() {
        if (this.internalPropertyPredicate == null) {
            return false;
        }
        if (this.properties == null) {
            return false;
        }
        if (this.properties.isEmpty()) {
            return false;
        }
        int removedBytes = 0;
        boolean removed = false;
        Iterator<Map.Entry<SimpleString, PropertyValue>> keyNameIterator = this.properties.entrySet().iterator();
        while (keyNameIterator.hasNext()) {
            Map.Entry<SimpleString, PropertyValue> entry = keyNameIterator.next();
            SimpleString propertyName = entry.getKey();
            if (!this.internalPropertyPredicate.test(propertyName)) continue;
            PropertyValue propertyValue = entry.getValue();
            removedBytes += propertyName.sizeof() + propertyValue.encodeSize();
            keyNameIterator.remove();
            removed = true;
        }
        this.internalProperties = false;
        this.size -= removedBytes;
        return removed;
    }

    public synchronized void forEachKey(Consumer<SimpleString> action) {
        if (this.properties != null) {
            this.properties.keySet().forEach(action::accept);
        }
    }

    public synchronized void forEach(BiConsumer<SimpleString, Object> action) {
        if (this.properties != null) {
            this.properties.forEach((? super K k, ? super V v) -> action.accept((SimpleString)k, v.getValue()));
        }
    }

    private synchronized void forEachInternal(BiConsumer<SimpleString, PropertyValue> action) {
        if (this.properties != null) {
            this.properties.forEach(action::accept);
        }
    }

    public static boolean searchProperty(SimpleString key, ByteBuf buffer, int startIndex) {
        int index = startIndex;
        byte b = buffer.getByte(index);
        ++index;
        if (b == 0) {
            return false;
        }
        int numHeaders = buffer.getInt(index);
        index += 4;
        block10: for (int i = 0; i < numHeaders; ++i) {
            int keyLength;
            if (key.equals(buffer, index += 4, keyLength = buffer.getInt(index))) {
                return true;
            }
            if (i == numHeaders - 1) {
                return false;
            }
            byte type = buffer.getByte(index += keyLength);
            ++index;
            switch (type) {
                case 0: {
                    continue block10;
                }
                case 5: 
                case 11: {
                    index += 2;
                    continue block10;
                }
                case 2: 
                case 3: {
                    ++index;
                    continue block10;
                }
                case 4: 
                case 10: {
                    index += 4 + buffer.getInt(index);
                    continue block10;
                }
                case 6: {
                    index += 4;
                    continue block10;
                }
                case 7: {
                    index += 8;
                    continue block10;
                }
                case 8: {
                    index += 4;
                    continue block10;
                }
                case 9: {
                    index += 8;
                    continue block10;
                }
                default: {
                    throw ActiveMQUtilBundle.BUNDLE.invalidType(type);
                }
            }
        }
        return false;
    }

    public synchronized void decode(ByteBuf buffer, TypedPropertiesDecoderPools keyValuePools) {
        byte b = buffer.readByte();
        if (b == 0) {
            this.properties = null;
            this.size = 0;
        } else {
            int numHeaders = buffer.readInt();
            this.properties = new HashMap<SimpleString, PropertyValue>(numHeaders, 1.0f);
            this.size = 0;
            block13: for (int i = 0; i < numHeaders; ++i) {
                SimpleString key = SimpleString.readSimpleString(buffer, keyValuePools == null ? null : keyValuePools.getPropertyKeysPool());
                byte type = buffer.readByte();
                switch (type) {
                    case 0: {
                        PropertyValue val = NullValue.INSTANCE;
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 11: {
                        PropertyValue val = new CharValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 2: {
                        PropertyValue val = BooleanValue.of(buffer.readBoolean());
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 3: {
                        PropertyValue val = ByteValue.valueOf(buffer.readByte());
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 4: {
                        PropertyValue val = new BytesValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 5: {
                        PropertyValue val = new ShortValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 6: {
                        PropertyValue val = new IntValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 7: {
                        PropertyValue val = new LongValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 8: {
                        PropertyValue val = new FloatValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 9: {
                        PropertyValue val = new DoubleValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 10: {
                        PropertyValue val = StringValue.readStringValue(buffer, keyValuePools == null ? null : keyValuePools.getPropertyValuesPool());
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    default: {
                        throw ActiveMQUtilBundle.BUNDLE.invalidType(type);
                    }
                }
            }
        }
    }

    public void decode(ByteBuf buffer) {
        this.decode(buffer, null);
    }

    public synchronized void encode(ByteBuf buffer) {
        if (this.properties == null || this.size == 0) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(1);
            buffer.writeInt(this.properties.size());
            this.properties.forEach((? super K key, ? super V value) -> {
                byte[] data = key.getData();
                buffer.writeInt(data.length);
                buffer.writeBytes(data);
                value.write(buffer);
            });
        }
    }

    public synchronized int getEncodeSize() {
        if (this.properties == null || this.size == 0) {
            return 1;
        }
        return 5 + this.size;
    }

    public synchronized void clear() {
        if (this.properties != null) {
            this.properties.clear();
        }
        this.size = 0;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("TypedProperties[");
        if (this.properties != null) {
            Iterator<Map.Entry<SimpleString, PropertyValue>> iter = this.properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<SimpleString, PropertyValue> iterItem = iter.next();
                sb.append(iterItem.getKey() + "=");
                Object theValue = iterItem.getValue().getValue();
                if (theValue == null) {
                    sb.append("NULL-value");
                } else if (theValue instanceof byte[]) {
                    sb.append("[" + ByteUtil.maxString(ByteUtil.bytesToHex((byte[])theValue, 2), 150) + ")");
                    if (iterItem.getKey().toString().startsWith("_AMQ_ROUTE_TO")) {
                        sb.append(",bytesAsLongs(");
                        try {
                            ByteBuffer buff = ByteBuffer.wrap((byte[])theValue);
                            while (buff.hasRemaining()) {
                                long bindingID = buff.getLong();
                                sb.append(bindingID);
                                if (!buff.hasRemaining()) continue;
                                sb.append(",");
                            }
                        }
                        catch (Throwable e) {
                            sb.append("error-converting-longs=" + e.getMessage());
                        }
                        sb.append("]");
                    }
                } else {
                    sb.append(theValue.toString());
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.append("]").toString();
    }

    private synchronized void doPutValue(SimpleString key, PropertyValue value) {
        PropertyValue oldValue;
        if (!this.internalProperties && this.internalPropertyPredicate != null && this.internalPropertyPredicate.test(key)) {
            this.internalProperties = true;
        }
        if (this.properties == null) {
            this.properties = new HashMap<SimpleString, PropertyValue>();
        }
        this.size = (oldValue = this.properties.put(key, value)) != null ? (this.size += value.encodeSize() - oldValue.encodeSize()) : (this.size += SimpleString.sizeofString(key) + value.encodeSize());
    }

    private synchronized Object doRemoveProperty(SimpleString key) {
        if (this.properties == null) {
            return null;
        }
        PropertyValue val = this.properties.remove(key);
        if (val == null) {
            return null;
        }
        this.size -= SimpleString.sizeofString(key) + val.encodeSize();
        return val.getValue();
    }

    private synchronized Object doGetProperty(SimpleString key) {
        if (this.properties == null) {
            return null;
        }
        PropertyValue val = this.properties.get(key);
        if (val == null) {
            return null;
        }
        return val.getValue();
    }

    public synchronized boolean isEmpty() {
        if (this.properties == null) {
            return true;
        }
        return this.properties.isEmpty();
    }

    public synchronized Set<String> getMapNames() {
        if (this.properties == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>(this.properties.size());
        for (SimpleString name : this.properties.keySet()) {
            names.add(name.toString());
        }
        return names;
    }

    public synchronized Map<String, Object> getMap() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> m = new HashMap<String, Object>(this.properties.size());
        for (Map.Entry<SimpleString, PropertyValue> entry : this.properties.entrySet()) {
            Object val = entry.getValue().getValue();
            if (val instanceof SimpleString) {
                m.put(entry.getKey().toString(), ((SimpleString)val).toString());
                continue;
            }
            m.put(entry.getKey().toString(), val);
        }
        return m;
    }

    public static void setObjectProperty(SimpleString key, Object value, TypedProperties properties) {
        if (value == null) {
            properties.putNullValue(key);
        } else if (value instanceof Boolean) {
            properties.putBooleanProperty(key, (Boolean)value);
        } else if (value instanceof Byte) {
            properties.putByteProperty(key, (Byte)value);
        } else if (value instanceof Character) {
            properties.putCharProperty(key, ((Character)value).charValue());
        } else if (value instanceof Short) {
            properties.putShortProperty(key, (Short)value);
        } else if (value instanceof Integer) {
            properties.putIntProperty(key, (Integer)value);
        } else if (value instanceof Long) {
            properties.putLongProperty(key, (Long)value);
        } else if (value instanceof Float) {
            properties.putFloatProperty(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            properties.putDoubleProperty(key, (Double)value);
        } else if (value instanceof String) {
            properties.putSimpleStringProperty(key, new SimpleString((String)value));
        } else if (value instanceof SimpleString) {
            properties.putSimpleStringProperty(key, (SimpleString)value);
        } else if (value instanceof byte[]) {
            properties.putBytesProperty(key, (byte[])value);
        } else {
            throw new ActiveMQPropertyConversionException(value.getClass() + " is not a valid property type");
        }
    }

    public static class TypedPropertiesStringSimpleStringPools {
        private SimpleString.StringSimpleStringPool propertyKeysPool;
        private SimpleString.StringSimpleStringPool propertyValuesPool;

        public TypedPropertiesStringSimpleStringPools() {
            this.propertyKeysPool = new SimpleString.StringSimpleStringPool();
            this.propertyValuesPool = new SimpleString.StringSimpleStringPool();
        }

        public TypedPropertiesStringSimpleStringPools(int keyPoolCapacity, int valuePoolCapacity) {
            this.propertyKeysPool = new SimpleString.StringSimpleStringPool(keyPoolCapacity);
            this.propertyValuesPool = new SimpleString.StringSimpleStringPool(valuePoolCapacity);
        }

        public SimpleString.StringSimpleStringPool getPropertyKeysPool() {
            return this.propertyKeysPool;
        }

        public SimpleString.StringSimpleStringPool getPropertyValuesPool() {
            return this.propertyValuesPool;
        }
    }

    public static class TypedPropertiesDecoderPools {
        private SimpleString.ByteBufSimpleStringPool propertyKeysPool;
        private StringValue.ByteBufStringValuePool propertyValuesPool;

        public TypedPropertiesDecoderPools() {
            this.propertyKeysPool = new SimpleString.ByteBufSimpleStringPool();
            this.propertyValuesPool = new StringValue.ByteBufStringValuePool();
        }

        public TypedPropertiesDecoderPools(int keyPoolCapacity, int valuePoolCapacity) {
            this.propertyKeysPool = new SimpleString.ByteBufSimpleStringPool(keyPoolCapacity);
            this.propertyValuesPool = new StringValue.ByteBufStringValuePool(valuePoolCapacity);
        }

        public SimpleString.ByteBufSimpleStringPool getPropertyKeysPool() {
            return this.propertyKeysPool;
        }

        public StringValue.ByteBufStringValuePool getPropertyValuesPool() {
            return this.propertyValuesPool;
        }
    }

    public static final class StringValue
    extends PropertyValue {
        final SimpleString val;

        private StringValue(SimpleString val) {
            this.val = val;
        }

        static StringValue readStringValue(ByteBuf byteBuf, ByteBufStringValuePool pool) {
            if (pool == null) {
                return new StringValue(SimpleString.readSimpleString(byteBuf));
            }
            return (StringValue)pool.getOrCreate(byteBuf);
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(10);
            SimpleString.writeSimpleString(buffer, this.val);
        }

        @Override
        public int encodeSize() {
            return 1 + SimpleString.sizeofString(this.val);
        }

        public static final class ByteBufStringValuePool
        extends AbstractByteBufPool<StringValue> {
            public static final int DEFAULT_MAX_LENGTH = 36;
            private final int maxLength;

            public ByteBufStringValuePool() {
                this.maxLength = 36;
            }

            public ByteBufStringValuePool(int capacity) {
                this(capacity, 36);
            }

            public ByteBufStringValuePool(int capacity, int maxCharsLength) {
                super(capacity);
                this.maxLength = maxCharsLength;
            }

            @Override
            protected boolean isEqual(StringValue entry, ByteBuf byteBuf, int offset, int length) {
                if (entry == null || entry.val == null) {
                    return false;
                }
                return entry.val.equals(byteBuf, offset, length);
            }

            @Override
            protected boolean canPool(ByteBuf byteBuf, int length) {
                assert (length % 2 == 0) : "length must be a multiple of 2";
                int expectedStringLength = length >> 1;
                return expectedStringLength <= this.maxLength;
            }

            @Override
            protected StringValue create(ByteBuf byteBuf, int length) {
                return new StringValue(SimpleString.readSimpleString(byteBuf, length));
            }
        }
    }

    private static final class CharValue
    extends PropertyValue {
        final char val;

        private CharValue(char val) {
            this.val = val;
        }

        private CharValue(ByteBuf buffer) {
            this.val = (char)buffer.readShort();
        }

        @Override
        public Object getValue() {
            return Character.valueOf(this.val);
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(11);
            buffer.writeShort((short)this.val);
        }

        @Override
        public int encodeSize() {
            return 3;
        }
    }

    private static final class DoubleValue
    extends PropertyValue {
        final double val;

        private DoubleValue(double val) {
            this.val = val;
        }

        private DoubleValue(ByteBuf buffer) {
            this.val = Double.longBitsToDouble(buffer.readLong());
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(9);
            buffer.writeLong(Double.doubleToLongBits(this.val));
        }

        @Override
        public int encodeSize() {
            return 9;
        }
    }

    private static final class FloatValue
    extends PropertyValue {
        final float val;

        private FloatValue(float val) {
            this.val = val;
        }

        private FloatValue(ByteBuf buffer) {
            this.val = Float.intBitsToFloat(buffer.readInt());
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.val);
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(8);
            buffer.writeInt(Float.floatToIntBits(this.val));
        }

        @Override
        public int encodeSize() {
            return 5;
        }
    }

    private static final class LongValue
    extends PropertyValue {
        final long val;

        private LongValue(long val) {
            this.val = val;
        }

        private LongValue(ByteBuf buffer) {
            this.val = buffer.readLong();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(7);
            buffer.writeLong(this.val);
        }

        @Override
        public int encodeSize() {
            return 9;
        }
    }

    private static final class IntValue
    extends PropertyValue {
        final int val;

        private IntValue(int val) {
            this.val = val;
        }

        private IntValue(ByteBuf buffer) {
            this.val = buffer.readInt();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(6);
            buffer.writeInt(this.val);
        }

        @Override
        public int encodeSize() {
            return 5;
        }
    }

    private static final class ShortValue
    extends PropertyValue {
        final short val;

        private ShortValue(short val) {
            this.val = val;
        }

        private ShortValue(ByteBuf buffer) {
            this.val = buffer.readShort();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(5);
            buffer.writeShort(this.val);
        }

        @Override
        public int encodeSize() {
            return 3;
        }
    }

    private static final class BytesValue
    extends PropertyValue {
        final byte[] val;

        private BytesValue(byte[] val) {
            this.val = val;
        }

        private BytesValue(ByteBuf buffer) {
            int len = buffer.readInt();
            this.val = new byte[len];
            buffer.readBytes(this.val);
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(4);
            buffer.writeInt(this.val.length);
            buffer.writeBytes(this.val);
        }

        @Override
        public int encodeSize() {
            return 5 + this.val.length;
        }
    }

    private static final class ByteValue
    extends PropertyValue {
        private static final int ENCODE_SIZE = 2;
        private static final ByteValue[] VALUES = new ByteValue[256];
        private final byte val;
        private final Byte objectVal;

        private static ByteValue valueOf(byte b) {
            int offset = 128;
            int index = b + 128;
            ByteValue value = VALUES[index];
            if (value == null) {
                ByteValue.VALUES[index] = new ByteValue(b);
                return ByteValue.VALUES[index];
            }
            return value;
        }

        private ByteValue(byte val) {
            this.val = val;
            this.objectVal = val;
        }

        @Override
        public Object getValue() {
            return this.objectVal;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(3);
            buffer.writeByte(this.val);
        }

        @Override
        public int encodeSize() {
            return 2;
        }
    }

    private static final class BooleanValue
    extends PropertyValue {
        private static final int ENCODE_SIZE = 2;
        private static final BooleanValue TRUE = new BooleanValue(true);
        private static final BooleanValue FALSE = new BooleanValue(false);
        private final boolean val;
        private final Boolean objVal;

        private BooleanValue(boolean val) {
            this.val = val;
            this.objVal = val;
        }

        private static BooleanValue of(boolean val) {
            if (val) {
                return TRUE;
            }
            return FALSE;
        }

        @Override
        public Object getValue() {
            return this.objVal;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(2);
            buffer.writeBoolean(this.val);
        }

        @Override
        public int encodeSize() {
            return 2;
        }
    }

    private static final class NullValue
    extends PropertyValue {
        private static final NullValue INSTANCE = new NullValue();

        private NullValue() {
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void write(ByteBuf buffer) {
            buffer.writeByte(0);
        }

        @Override
        public int encodeSize() {
            return 1;
        }
    }

    private static abstract class PropertyValue {
        private PropertyValue() {
        }

        abstract Object getValue();

        abstract void write(ByteBuf var1);

        abstract int encodeSize();

        public String toString() {
            return "" + this.getValue();
        }
    }
}

