package org.jboss.remoting3._private;

import java.util.Locale;
import org.jboss.remoting3.ChannelBusyException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.wildfly.security.auth.AuthenticationException;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.security.sasl.SaslException;
import java.lang.Exception;
import org.jboss.remoting3.NotOpenException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.net.SocketAddress;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-12-07T07:12:32-0300")
public class Messages_$logger extends DelegatingBasicLogger implements Messages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    public Messages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void connectionError(final IOException cause) {
        super.log.logf(FQCN, DEBUG, null, connectionError$str(), cause);
    }
    protected String connectionError$str() {
        return "JBREM000200: Remote connection failed: %s";
    }
    protected String invalidMessage$str() {
        return "JBREM000201: Received invalid message on %s";
    }
    @Override
    public final IOException invalidMessage(final Object connection) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidMessage$str(), connection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String abruptClose$str() {
        return "JBREM000202: Abrupt close on %s";
    }
    @Override
    public final IOException abruptClose(final Object connection) {
        final IOException result = new IOException(String.format(getLoggingLocale(), abruptClose$str(), connection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void bufferUnderflowRaw() {
        super.log.logf(FQCN, WARN, null, bufferUnderflowRaw$str());
    }
    protected String bufferUnderflowRaw$str() {
        return "JBREM000203: Message missing protocol byte";
    }
    @Override
    public final void bufferUnderflow(final int id) {
        super.log.logf(FQCN, WARN, null, bufferUnderflow$str(), id);
    }
    protected String bufferUnderflow$str() {
        return "JBREM000204: Buffer underflow parsing message with protocol ID %02x";
    }
    @Override
    public final void failedToAccept(final Exception e) {
        super.log.logf(FQCN, DEBUG, null, failedToAccept$str(), e);
    }
    protected String failedToAccept$str() {
        return "JBREM000205: Failed to accept a connection: %s";
    }
    protected String channelNotOpen$str() {
        return "JBREM000206: Channel is not open";
    }
    @Override
    public final NotOpenException channelNotOpen() {
        final NotOpenException result = new NotOpenException(String.format(getLoggingLocale(), channelNotOpen$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String channelBusy$str() {
        return "JBREM000207: Failed to send a message (channel is busy)";
    }
    @Override
    public final ChannelBusyException channelBusy() {
        final ChannelBusyException result = new ChannelBusyException(String.format(getLoggingLocale(), channelBusy$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String writeInterrupted$str() {
        return "JBREM000208: Write operation interrupted";
    }
    @Override
    public final InterruptedIOException writeInterrupted() {
        final InterruptedIOException result = new InterruptedIOException(String.format(getLoggingLocale(), writeInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void exceptionInUserHandler(final Throwable throwable) {
        super.log.logf(FQCN, ERROR, throwable, exceptionInUserHandler$str());
    }
    protected String exceptionInUserHandler$str() {
        return "JBREM000209: An exception occurred in a message handler";
    }
    @Override
    public final void duplicateMessageId(final short messageId, final SocketAddress peerAddress) {
        super.log.logf(FQCN, FATAL, null, duplicateMessageId$str(), messageId, peerAddress);
    }
    protected String duplicateMessageId$str() {
        return "JBREM000210: Internal Error: received a message with duplicate ID %d from %s";
    }
    protected String duplicateMessageIdException$str() {
        return "Internal Error: received a message with a duplicate ID";
    }
    @Override
    public final IOException duplicateMessageIdException() {
        final IOException result = new IOException(String.format(getLoggingLocale(), duplicateMessageIdException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidWorker$str() {
        return "JBREM000211: Invalid XNIO worker; the worker must match the Remoting Endpoint worker";
    }
    @Override
    public final IllegalArgumentException invalidWorker() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidWorker$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToConfigureSslContext$str() {
        return "JBREM000212: Failed to configure SSL context";
    }
    @Override
    public final IOException failedToConfigureSslContext(final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToConfigureSslContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unknownProtocolId(final int id) {
        super.log.logf(FQCN, TRACE, null, unknownProtocolId$str(), id);
    }
    protected String unknownProtocolId$str() {
        return "Message with unknown protocol ID %d received";
    }
    @Override
    public final void rejectedInvalidMechanism(final String name) {
        super.log.logf(FQCN, TRACE, null, rejectedInvalidMechanism$str(), name);
    }
    protected String rejectedInvalidMechanism$str() {
        return "Rejected invalid SASL mechanism %s";
    }
    protected String authenticationExceptionIo$str() {
        return "JBREM000300: Authentication failed due to I/O error";
    }
    @Override
    public final AuthenticationException authenticationExceptionIo(final IOException e) {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), authenticationExceptionIo$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechanismNameTooLong$str() {
        return "JBREM000301: Mechanism name \"%s\" is too long";
    }
    @Override
    public final IOException mechanismNameTooLong(final String mechName) {
        final IOException result = new IOException(String.format(getLoggingLocale(), mechanismNameTooLong$str(), mechName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationMessageTooLarge$str() {
        return "JBREM000302: Authentication message too large";
    }
    @Override
    public final IOException authenticationMessageTooLarge() {
        final IOException result = new IOException(String.format(getLoggingLocale(), authenticationMessageTooLarge$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationExtraResponse$str() {
        return "JBREM000303: Authentication protocol failed (extra response)";
    }
    @Override
    public final AuthenticationException authenticationExtraResponse() {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), authenticationExtraResponse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serverRejectedAuthentication$str() {
        return "JBREM000304: Server rejected authentication";
    }
    @Override
    public final AuthenticationException serverRejectedAuthentication() {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), serverRejectedAuthentication$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationExceptionClosed$str() {
        return "JBREM000305: Authentication failed (connection closed)";
    }
    @Override
    public final AuthenticationException authenticationExceptionClosed() {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), authenticationExceptionClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationNoSaslClient$str() {
        return "JBREM000306: Authentication failed (SASL client construction failure)";
    }
    @Override
    public final AuthenticationException authenticationNoSaslClient(final SaslException e) {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), authenticationNoSaslClient$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationInterrupted$str() {
        return "JBREM000307: Authentication interrupted";
    }
    @Override
    public final AuthenticationException authenticationInterrupted() {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), authenticationInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAuthMechanismsLeft$str() {
        return "JBREM000308: Authentication failed (no mechanisms left), tried: %s";
    }
    @Override
    public final AuthenticationException noAuthMechanismsLeft(final String triedStr) {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), noAuthMechanismsLeft$str(), triedStr));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationNotSupported$str() {
        return "JBREM000309: Authentication not supported for this peer";
    }
    @Override
    public final AuthenticationException authenticationNotSupported() {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), authenticationNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
